/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.util.HashMap;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-node-ssh")
@I18n(value="create.node.ssh")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class CreateNodeSshCommand
implements AdminCommand {
    @Inject
    private CommandRunner cr;
    @Param(name="name", primary=true)
    private String name;
    @Param(name="nodehost")
    private String nodehost;
    @Param(name="installdir")
    private String installdir;
    @Param(name="nodedir", optional=true)
    private String nodedir;
    @Param(name="sshport", optional=true)
    private String sshport;
    @Param(name="sshuser", optional=true)
    private String sshuser;
    @Param(name="sshkeyfile", optional=true)
    private String sshkeyfile;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    private static final String NL = System.getProperty("line.separator");

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        StringBuilder msg = new StringBuilder();
        this.setDefaults();
        try {
            this.validate();
        }
        catch (CommandValidationException e) {
            if (!this.force) {
                report.setMessage(e.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            msg.append(e.getMessage()).append(NL);
            msg.append(Strings.get("create.node.ssh.continue.force"));
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_create-node", report);
        ParameterMap map = new ParameterMap();
        map.add((Object)"DEFAULT", (Object)this.name);
        map.add((Object)"installdir", (Object)this.installdir);
        map.add((Object)"nodehost", (Object)this.nodehost);
        map.add((Object)"nodedir", (Object)this.nodedir);
        map.add((Object)"sshport", (Object)this.sshport);
        map.add((Object)"sshuser", (Object)this.sshuser);
        map.add((Object)"sshkeyfile", (Object)this.sshkeyfile);
        ci.parameters(map);
        ci.execute();
        if (StringUtils.ok((String)report.getMessage())) {
            if (msg.length() > 0) {
                msg.append(NL);
            }
            msg.append(report.getMessage());
        }
        report.setMessage(msg.toString());
    }

    private void setDefaults() {
        if (this.sshport == null) {
            this.sshport = "22";
        }
        if (this.sshuser == null) {
            this.sshuser = "${user.name}";
        }
    }

    private void validate() throws CommandValidationException {
        HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
        TokenResolver resolver = new TokenResolver(systemPropsMap);
        if (StringUtils.ok((String)this.sshkeyfile)) {
            File kfile = new File(resolver.resolve(this.sshkeyfile));
            if (!kfile.isAbsolute()) {
                throw new CommandValidationException(Strings.get("key.path.not.absolute", kfile.getPath()));
            }
            if (!kfile.exists()) {
                throw new CommandValidationException(Strings.get("key.path.not.found", kfile.getPath()));
            }
            if (!kfile.canRead()) {
                throw new CommandValidationException(Strings.get("key.path.not.readable", kfile.getPath(), System.getProperty("user.name")));
            }
        }
    }
}

