/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.osgijavaeebase.Extender;
import org.jvnet.hk2.component.Habitat;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ExtenderManager {
    private static final Logger logger = Logger.getLogger(ExtenderManager.class.getPackage().getName());
    private BundleContext context;
    private Events events;
    private EventListener listener;
    private ServiceTracker extenderTracker;
    private GlassFishServerTracker glassFishServerTracker;

    public ExtenderManager(BundleContext context) {
        this.context = context;
    }

    public void start() throws Exception {
        this.glassFishServerTracker = new GlassFishServerTracker(this.context);
        this.glassFishServerTracker.open();
    }

    public void stop() throws Exception {
        this.unregisterGlassFishShutdownHook();
        if (this.glassFishServerTracker != null) {
            this.glassFishServerTracker.close();
            this.glassFishServerTracker = null;
        }
        if (this.extenderTracker != null) {
            this.extenderTracker.close();
            this.extenderTracker = null;
        }
        this.stopExtenders();
    }

    public synchronized void startExtenders() {
        if (this.extenderTracker != null) {
            return;
        }
        this.extenderTracker = new ExtenderTracker(this.context);
        this.extenderTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopExtenders() {
        try {
            ServiceReference[] refs = this.context.getServiceReferences(Extender.class.getName(), null);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    Extender e = (Extender)Extender.class.cast(this.context.getService(ref));
                    try {
                        e.stop();
                    }
                    finally {
                        this.context.ungetService(ref);
                    }
                }
            }
        }
        catch (InvalidSyntaxException e) {
            logger.logp(Level.WARNING, "ExtenderManager", "stopExtenders", "Not able to stop all extenders", e);
        }
    }

    private void unregisterGlassFishShutdownHook() {
        if (this.listener != null) {
            this.events.unregister(this.listener);
        }
    }

    private class GlassFishServerTracker
    extends ServiceTracker {
        public GlassFishServerTracker(BundleContext context) {
            super(context, Habitat.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            logger.logp(Level.FINE, "ExtenderManager$GlassFishServerTracker", "addingService", "Habitat has been created");
            ServiceReference habitatServiceRef = this.context.getServiceReference(Habitat.class.getName());
            Habitat habitat = (Habitat)Habitat.class.cast(this.context.getService(habitatServiceRef));
            ExtenderManager.this.events = (Events)habitat.getComponent(Events.class);
            ExtenderManager.this.listener = new EventListener(){

                public void event(EventListener.Event event) {
                    if (EventTypes.SERVER_READY.equals((Object)event.type())) {
                        ExtenderManager.this.startExtenders();
                    } else if (EventTypes.PREPARE_SHUTDOWN.equals((Object)event.type())) {
                        ExtenderManager.this.stopExtenders();
                    }
                }
            };
            ExtenderManager.this.events.register(ExtenderManager.this.listener);
            if (((ServerEnvironment)habitat.getComponent(ServerEnvironment.class)).getStatus() == ServerEnvironment.Status.started) {
                ExtenderManager.this.startExtenders();
            }
            this.close();
            return super.addingService(reference);
        }
    }

    private class ExtenderTracker
    extends ServiceTracker {
        ExtenderTracker(BundleContext context) {
            super(context, Extender.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            Extender e = (Extender)Extender.class.cast(this.context.getService(reference));
            e.start();
            return e;
        }

        public void removedService(ServiceReference reference, Object service) {
            Extender e = (Extender)Extender.class.cast(this.context.getService(reference));
            e.stop();
        }
    }
}

