/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.security;

import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.security.web.integration.PrincipalGroupFactory;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.auth.x500.X500Principal;
import org.glassfish.security.common.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AppservCertificateLoginModule
implements LoginModule {
    private Subject subject;
    protected Map<String, ?> _sharedState;
    protected Map<String, ?> _options;
    protected final Logger _logger = LogDomains.getLogger(AppservCertificateLoginModule.class, (String)"javax.enterprise.system.core.security");
    private CallbackHandler callbackHandler;
    private boolean success = false;
    private String[] groups = null;
    private boolean commitsuccess = false;
    private X509Certificate[] certs = null;
    private X500Principal x500Principal;
    private String appName = null;

    @Override
    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this._sharedState = sharedState;
        this._options = options;
        this.callbackHandler = callbackHandler;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Login module initialized: " + this.getClass().toString());
        }
    }

    @Override
    public final boolean login() throws LoginException {
        this.extractCredentials();
        this.authenticateUser();
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "JAAS login complete.");
        }
        return true;
    }

    @Override
    public final boolean commit() throws LoginException {
        if (!this.success) {
            return false;
        }
        Set<Principal> principalSet = this.subject.getPrincipals();
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] != null) {
                Group g = PrincipalGroupFactory.getGroupInstance(this.groups[i], "certificate");
                principalSet.add((Principal)g);
            }
            this.groups[i] = null;
        }
        this.groups = null;
        this.commitsuccess = true;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "JAAS authentication committed.");
        }
        return true;
    }

    @Override
    public final boolean abort() throws LoginException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "JAAS authentication aborted.");
        }
        if (!this.success) {
            return false;
        }
        if (this.success && !this.commitsuccess) {
            int i;
            this.success = false;
            for (i = 0; i < this.groups.length; ++i) {
                this.groups[i] = null;
            }
            this.groups = null;
            if (this.certs != null) {
                for (i = 0; i < this.certs.length; ++i) {
                    this.certs[i] = null;
                }
                this.certs = null;
            }
            this.x500Principal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public final boolean logout() throws LoginException {
        int i;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "JAAS logout for: " + this.subject.toString());
        }
        this.subject.getPrincipals().clear();
        this.subject.getPublicCredentials().clear();
        this.subject.getPrivateCredentials().clear();
        this.success = false;
        this.commitsuccess = false;
        if (this.groups != null) {
            for (i = 0; i < this.groups.length; ++i) {
                this.groups[i] = null;
            }
            this.groups = null;
        }
        if (this.certs != null) {
            for (i = 0; i < this.certs.length; ++i) {
                this.certs[i] = null;
            }
            this.certs = null;
        }
        this.x500Principal = null;
        return true;
    }

    private final void extractCredentials() throws LoginException {
        Set<List> creds = this.subject.getPublicCredentials(List.class);
        Iterator<List> itr = creds.iterator();
        if (!itr.hasNext()) {
            this.success = false;
            throw new LoginException("No Certificate Credential found.");
        }
        List certCred = itr.next();
        if (certCred == null || certCred.isEmpty()) {
            this.success = false;
            throw new LoginException("No Certificate(s) found.");
        }
        try {
            this.certs = certCred.toArray(new X509Certificate[certCred.size()]);
        }
        catch (Exception ex) {
            throw (LoginException)new LoginException("No Certificate(s) found.").initCause(ex);
        }
        this.x500Principal = this.certs[0].getSubjectX500Principal();
        CertificateRealm.AppContextCallback appContext = new CertificateRealm.AppContextCallback();
        try {
            this.callbackHandler.handle(new Callback[]{appContext});
            this.appName = appContext.getModuleID();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected final void commitUserAuthentication(String[] groups) {
        this.groups = groups;
        this.success = groups != null;
    }

    protected abstract void authenticateUser() throws LoginException;

    protected String getAppName() {
        return this.appName;
    }

    protected X509Certificate[] getCerts() {
        return this.certs;
    }

    protected X500Principal getX500Principal() {
        return this.x500Principal;
    }

    protected Subject getSubject() {
        return this.subject;
    }
}

