/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.core;

import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSNotEnabledException;
import com.sun.enterprise.ee.cms.core.GMSNotInitializedException;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GMSFactory {
    private static Logger LOG = Logger.getLogger("ShoalLogger");
    private static Hashtable<String, GroupManagementService> groups = new Hashtable();
    private static Map<String, Boolean> gmsEnabledMap = new HashMap<String, Boolean>();
    private static String memberToken;

    private GMSFactory() {
    }

    public static Runnable startGMSModule(String serverToken, String groupName, GroupManagementService.MemberType memberType, Properties properties) {
        if (serverToken == null) {
            throw new RuntimeException("Server Token was not specified and cannot be null");
        }
        if (groupName == null) {
            throw new RuntimeException("Group Name was not specified and cannot be null");
        }
        GroupManagementService gms = null;
        gmsEnabledMap.put(groupName, Boolean.TRUE);
        try {
            gms = GMSFactory.getGMSModule(groupName);
        }
        catch (GMSException e) {
            gms = GMSFactory.getGroupManagementServiceInstance();
            gms.initialize(serverToken, groupName, memberType, properties);
            memberToken = serverToken;
            groups.put(GMSFactory.getCompositeKey(groupName), gms);
        }
        return (Runnable)((Object)gms);
    }

    public static GroupManagementService getGMSModule(String groupName) throws GMSNotEnabledException, GMSException, GMSNotInitializedException {
        if (groupName == null) {
            throw new GMSException("Group Name was not specified and cannot be null");
        }
        String key = GMSFactory.getCompositeKey(groupName);
        if (groups.containsKey(key)) {
            return groups.get(key);
        }
        if (!GMSFactory.isGMSEnabled(groupName)) {
            throw new GMSNotEnabledException(new StringBuffer().append("Group Management Service is not ").append("enabled for group").append(groupName).toString());
        }
        throw new GMSNotInitializedException(new StringBuffer().append("Group Management Service is not ").append("initialized for group ").append(groupName).toString());
    }

    public static GroupManagementService getGMSModule() throws GMSException {
        Collection instances = GMSFactory.getAllGMSInstancesForMember();
        if (instances.size() == 0) {
            throw new GMSNotInitializedException(new StringBuffer().append("Group Management Service is not ").append("initialized for any group ").toString());
        }
        GroupManagementService gms = (GroupManagementService)instances.toArray()[0];
        return gms;
    }

    public static Collection getAllGMSInstancesForMember() {
        return groups.values();
    }

    private static String getCompositeKey(String groupName) {
        return memberToken + "::" + groupName;
    }

    public static boolean isGMSEnabled(String groupName) {
        Boolean val = gmsEnabledMap.get(groupName);
        return val != null && !val.equals(Boolean.FALSE);
    }

    public static void setGMSEnabledState(String groupName, Boolean value) {
        gmsEnabledMap.put(groupName, value);
    }

    public static void removeGMSModule(String groupName) {
        String key;
        if (groupName != null && groups.containsKey(key = GMSFactory.getCompositeKey(groupName))) {
            groups.remove(key);
        }
    }

    private static GroupManagementService findByServiceLoader() {
        GroupManagementService groupManagementService = null;
        ServiceLoader<GroupManagementService> loader = ServiceLoader.load(GroupManagementService.class);
        Iterator<GroupManagementService> iter = loader.iterator();
        if (iter.hasNext()) {
            try {
                groupManagementService = (GroupManagementService)iter.next().getClass().newInstance();
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "error instantiating GroupManagementService service", t);
            }
        }
        if (groupManagementService == null) {
            LOG.log(Level.SEVERE, "fatal error, no GroupManagementService implementations found");
        } else if (LOG.isLoggable(Level.CONFIG)) {
            LOG.log(Level.CONFIG, "findByServiceLoader() loaded service " + groupManagementService.getClass().getName());
        }
        return groupManagementService;
    }

    private static GroupManagementService findByClassLoader(String classname) {
        GroupManagementService gmsImpl = null;
        try {
            Class<?> GmsImplClass = Class.forName(classname);
            gmsImpl = (GroupManagementService)GmsImplClass.newInstance();
            if (gmsImpl == null) {
                LOG.log(Level.SEVERE, "fatal error, no GroupManagementService implementations found");
            } else if (LOG.isLoggable(Level.CONFIG)) {
                LOG.log(Level.CONFIG, "findByClassLoader() loaded service " + gmsImpl.getClass().getName());
            }
        }
        catch (Throwable x) {
            LOG.log(Level.SEVERE, "fatal error instantiating GroupManagementService service", x);
        }
        return gmsImpl;
    }

    public static GroupManagementService getGroupManagementServiceInstance() {
        GroupManagementService gmsImpl = null;
        try {
            gmsImpl = GMSFactory.findByServiceLoader();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (gmsImpl == null) {
            String classname = null;
            classname = "com.sun.enterprise.ee.cms.impl.common.GroupManagementServiceImpl";
            gmsImpl = GMSFactory.findByClassLoader(classname);
        }
        return gmsImpl;
    }
}

