/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.util.ExecException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class KeystoreManager {
    private static final String KEYTOOL_CMD = System.getenv("JAVA_HOME") == null ? "keytool" : System.getenv("JAVA_HOME") + "/bin/keytool";
    private static String CERTIFICATE_DN_PREFIX = "CN=";
    private static String CERTIFICATE_DN_SUFFIX = ",OU=GlassFish,O=Oracle Corporation,L=Santa Clara,ST=California,C=US";
    public static final String CERTIFICATE_ALIAS = "s1as";
    public static final String INSTANCE_SECURE_ADMIN_ALIAS = "glassfish-instance";
    public static final String DEFAULT_MASTER_PASSWORD = "changeit";
    private static final String SKID_EXTENSION_SYSTEM_PROPERTY = "-J-Dsun.security.internal.keytool.skid";
    private static final String INSTANCE_CN_SUFFIX = "-instance";
    protected PEFileLayout _fileLayout = null;
    private static final StringManager _strMgr = StringManager.getManager(KeystoreManager.class);

    protected String getCertificateDN(RepositoryConfig cfg, String CNSuffix) {
        String cn = this.getCNFromCfg(cfg);
        if (cn == null) {
            try {
                cn = NetUtils.getCanonicalHostName();
            }
            catch (Exception e) {
                cn = "localhost";
            }
        }
        String x509DistinguishedName = CERTIFICATE_DN_PREFIX + cn + (CNSuffix != null ? CNSuffix : "") + CERTIFICATE_DN_SUFFIX;
        System.out.println(_strMgr.getString("CertificateDN", (Object)x509DistinguishedName));
        return x509DistinguishedName;
    }

    protected PEFileLayout getFileLayout(RepositoryConfig config) {
        if (this._fileLayout == null) {
            this._fileLayout = new PEFileLayout(config);
        }
        return this._fileLayout;
    }

    protected void createSSLCertificateDatabase(RepositoryConfig config, String masterPassword) {
        try {
            this.createKeyStore(config, masterPassword);
            this.createTrustStore(config, masterPassword);
        }
        catch (RepositoryException re) {
            String msg = _strMgr.getString("SomeProblemWithKeytool", (Object)re.getMessage());
            System.err.println(msg);
            try {
                PEFileLayout lo = this.getFileLayout(config);
                File src = lo.getKeyStoreTemplate();
                File dest = lo.getKeyStore();
                FileUtils.copy((File)src, (File)dest);
                src = lo.getTrustStoreTemplate();
                dest = lo.getTrustStore();
                FileUtils.copy((File)src, (File)dest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void createKeyStore(RepositoryConfig config, String masterPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File keystore = layout.getKeyStore();
        this.addSelfSignedCertToKeyStore(keystore, CERTIFICATE_ALIAS, config, masterPassword, null);
        this.addSelfSignedCertToKeyStore(keystore, INSTANCE_SECURE_ADMIN_ALIAS, config, masterPassword, INSTANCE_CN_SUFFIX);
    }

    private void addSelfSignedCertToKeyStore(File keystore, String alias, RepositoryConfig config, String masterPassword, String CNSuffix) throws RepositoryException {
        String[] keytoolCmd = new String[]{"-genkey", "-keyalg", "RSA", "-keystore", keystore.getAbsolutePath(), "-alias", alias, "-dname", this.getCertificateDN(config, CNSuffix), "-validity", "3650", "-keypass", masterPassword, "-storepass", masterPassword, SKID_EXTENSION_SYSTEM_PROPERTY};
        KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 60L);
        p.execute("keystoreNotCreated", keystore);
    }

    protected void createTrustStore(RepositoryConfig config, String masterPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getTrustStoreTemplate();
        File truststore = layout.getTrustStore();
        try {
            FileUtils.copy((File)src, (File)truststore);
        }
        catch (IOException ioe) {
            throw new RepositoryException(_strMgr.getString("trustStoreNotCreated", (Object)truststore), ioe);
        }
        this.changeKeystorePassword(DEFAULT_MASTER_PASSWORD, masterPassword, truststore);
        this.copyCert(layout, CERTIFICATE_ALIAS, masterPassword);
        this.copyCert(layout, INSTANCE_SECURE_ADMIN_ALIAS, masterPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCert(PEFileLayout layout, String alias, String masterPassword) throws RepositoryException {
        File keystore = layout.getKeyStore();
        File truststore = layout.getTrustStore();
        File certFile = null;
        String[] input = new String[]{masterPassword};
        String[] keytoolCmd = null;
        KeytoolExecutor p = null;
        try {
            certFile = new File(layout.getConfigRoot(), alias + ".cer");
            keytoolCmd = new String[]{"-export", "-keystore", keystore.getAbsolutePath(), "-alias", alias, "-file", certFile.getAbsolutePath()};
            p = new KeytoolExecutor(keytoolCmd, 30L, input);
            p.execute("trustStoreNotCreated", truststore);
            keytoolCmd = new String[]{"-import", "-noprompt", "-keystore", truststore.getAbsolutePath(), "-alias", alias, "-file", certFile.getAbsolutePath()};
            p = new KeytoolExecutor(keytoolCmd, 30L, input);
            p.execute("trustStoreNotCreated", truststore);
            certFile.delete();
            certFile = null;
        }
        finally {
            if (certFile != null) {
                certFile.delete();
            }
        }
    }

    protected void changeKeystorePassword(String oldPassword, String newPassword, File keystore) throws RepositoryException {
        if (!oldPassword.equals(newPassword)) {
            String[] keytoolCmd = new String[]{"-storepasswd", "-keystore", keystore.getAbsolutePath()};
            KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 30L, new String[]{oldPassword, newPassword, newPassword});
            p.execute("keyStorePasswordNotChanged", keystore);
        }
    }

    protected void changeS1ASAliasPassword(RepositoryConfig config, String storePassword, String oldKeyPassword, String newKeyPassword) throws RepositoryException {
        if (!storePassword.equals(oldKeyPassword) && !oldKeyPassword.equals(newKeyPassword)) {
            PEFileLayout layout = this.getFileLayout(config);
            File src = layout.getTrustStoreTemplate();
            File keystore = layout.getKeyStore();
            String[] keytoolCmd = new String[]{"-list", "-keystore", keystore.getAbsolutePath(), "-alias", CERTIFICATE_ALIAS};
            KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 30L, new String[]{storePassword});
            try {
                p.execute("s1asKeyPasswordNotChanged", keystore);
            }
            catch (RepositoryException ex) {
                return;
            }
            keytoolCmd = new String[]{"-keypasswd", "-keystore", keystore.getAbsolutePath(), "-alias", CERTIFICATE_ALIAS};
            p = new KeytoolExecutor(keytoolCmd, 30L, new String[]{storePassword, oldKeyPassword, newKeyPassword, newKeyPassword});
            p.execute("s1asKeyPasswordNotChanged", keystore);
        }
    }

    protected void changeSSLCertificateDatabasePassword(RepositoryConfig config, String oldPassword, String newPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File keystore = layout.getKeyStore();
        File truststore = layout.getTrustStore();
        if (keystore.exists()) {
            this.changeKeystorePassword(oldPassword, newPassword, keystore);
            try {
                this.changeS1ASAliasPassword(config, newPassword, oldPassword, newPassword);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (truststore.exists()) {
            this.changeKeystorePassword(oldPassword, newPassword, truststore);
        }
    }

    protected void chmod(String args, File file) throws IOException {
        if (OS.isUNIX()) {
            if (args == null || file == null) {
                throw new IOException(_strMgr.getString("nullArg"));
            }
            if (!file.exists()) {
                throw new IOException(_strMgr.getString("fileNotFound"));
            }
            String[] argsString = args.split(" +");
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("/bin/chmod");
            for (String arg : argsString) {
                cmdList.add(arg);
            }
            cmdList.add(file.getAbsolutePath());
            new ProcessBuilder(cmdList).start();
        }
    }

    private String getCNFromCfg(RepositoryConfig cfg) {
        String option = (String)cfg.get("keytooloptions");
        if (option == null || option.length() == 0) {
            return null;
        }
        String value = this.getCNFromOption(option);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    private String getValueFromOptionForName(String option, String name, boolean ignoreNameCase) {
        String[] pairs;
        Pattern p = Pattern.compile(":");
        for (String pair : pairs = p.split(option)) {
            boolean found;
            p = Pattern.compile("=");
            String[] nv = p.split(pair);
            String n = nv[0].trim();
            String v = nv[1].trim();
            boolean bl = found = ignoreNameCase ? n.equalsIgnoreCase(name) : n.equals(name);
            if (!found) continue;
            return v;
        }
        return null;
    }

    private String getCNFromOption(String option) {
        return this.getValueFromOptionForName(option, "CN", true);
    }

    protected class KeytoolExecutor
    extends ProcessExecutor {
        public KeytoolExecutor(String[] args, long timeoutInSeconds) {
            super(args, timeoutInSeconds);
            this.setExecutionRetentionFlag(true);
            this.addKeytoolCommand();
        }

        public KeytoolExecutor(String[] args, long timeoutInSeconds, String[] inputLines) {
            super(args, timeoutInSeconds, inputLines);
            this.setExecutionRetentionFlag(true);
            this.addKeytoolCommand();
        }

        protected String getExceptionMessage() {
            return this.getLatestOutput(this.mOutFile) + " " + this.getFileBuffer(this.mErrFile);
        }

        private void addKeytoolCommand() {
            if (!this.mCmdStrings[0].equals(KEYTOOL_CMD)) {
                String[] newArgs = new String[this.mCmdStrings.length + 1];
                newArgs[0] = KEYTOOL_CMD;
                System.arraycopy(this.mCmdStrings, 0, newArgs, 1, this.mCmdStrings.length);
                this.mCmdStrings = newArgs;
            }
        }

        public void execute(String keystoreErrorMsg, File keystoreName) throws RepositoryException {
            try {
                super.execute();
                if (this.getProcessExitValue() != 0) {
                    throw new RepositoryException(_strMgr.getString(keystoreErrorMsg, (Object)keystoreName) + this.getLastExecutionError() + " " + this.getLastExecutionOutput());
                }
            }
            catch (ExecException ex) {
                throw new RepositoryException(_strMgr.getString(keystoreErrorMsg, (Object)keystoreName) + this.getLastExecutionError() + " " + this.getLastExecutionOutput(), ex);
            }
        }
    }
}

