/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import java.net.URI;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.osgijavaeebase.OSGiApplicationInfo;
import org.glassfish.osgijavaeebase.OSGiDeploymentRequest;
import org.glassfish.osgijavaeebase.OSGiUndeploymentRequest;
import org.glassfish.server.ServerEnvironmentImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class OSGiContainer {
    private BundleContext context;
    protected Map<Bundle, OSGiApplicationInfo> applications = new HashMap<Bundle, OSGiApplicationInfo>();
    protected Map<OSGiApplicationInfo, ServiceRegistration> regs = new HashMap<OSGiApplicationInfo, ServiceRegistration>();
    private static final Logger logger = Logger.getLogger(OSGiContainer.class.getPackage().getName());
    private Deployment deployer = (Deployment)Globals.get(Deployment.class);
    private ArchiveFactory archiveFactory = (ArchiveFactory)Globals.get(ArchiveFactory.class);
    private ServerEnvironmentImpl env = (ServerEnvironmentImpl)Globals.get(ServerEnvironmentImpl.class);

    protected OSGiContainer(BundleContext ctx) {
        this.context = ctx;
    }

    protected BundleContext getBundleContext() {
        return this.context;
    }

    public synchronized void deploy(Bundle b) throws Exception {
        this.preDeploy(b);
        OSGiApplicationInfo osgiAppInfo = this.applications.get(b);
        if (osgiAppInfo != null) {
            logger.logp(Level.WARNING, "OSGiContainer", "deploy", "Bundle {0} is already deployed at {1} ", new Object[]{b, osgiAppInfo.getAppInfo().getSource()});
            return;
        }
        ActionReport report = this.getReport();
        osgiAppInfo = this.deployJavaEEArtifacts(b, report);
        if (osgiAppInfo == null) {
            throw new Exception("Deployment of " + b + " failed because of following reason: " + report.getMessage(), report.getFailureCause());
        }
        try {
            this.applications.put(b, osgiAppInfo);
            ServiceRegistration reg = this.context.registerService(OSGiApplicationInfo.class.getName(), (Object)osgiAppInfo, (Dictionary)new Properties());
            this.regs.put(osgiAppInfo, reg);
            this.postDeploy(osgiAppInfo);
            logger.logp(Level.INFO, "OSGiContainer", "deploy", "deployed bundle {0} at {1}", new Object[]{osgiAppInfo.getBundle(), osgiAppInfo.getAppInfo().getSource().getURI()});
        }
        catch (Exception e) {
            logger.logp(Level.WARNING, "OSGiContainer", "deploy", "Undeploying the bundle because of e = {0}", new Object[]{e});
            this.undeploy(b);
        }
    }

    public synchronized void undeploy(Bundle b) throws Exception {
        OSGiApplicationInfo osgiAppInfo = this.applications.get(b);
        if (osgiAppInfo == null) {
            throw new RuntimeException("No applications for bundle " + b);
        }
        this.applications.remove(b);
        this.regs.remove(osgiAppInfo).unregister();
        this.preUndeploy(osgiAppInfo);
        ActionReport report = this.getReport();
        this.undeployJavaEEArtifacts(osgiAppInfo, report);
        URI location = osgiAppInfo.getAppInfo().getSource().getURI();
        switch (report.getActionExitCode()) {
            case FAILURE: {
                logger.logp(Level.WARNING, "OSGiContainer", "undeploy", "Failed to undeploy {0} from {1}. See previous messages for further information.", new Object[]{b, location});
                break;
            }
            default: {
                logger.logp(Level.INFO, "OSGiContainer", "undeploy", "Undeployed bundle {0} from {1}", new Object[]{b, location});
            }
        }
        this.postUndeploy(osgiAppInfo);
    }

    public void undeployAll() {
        for (Bundle b : new HashSet<Bundle>(this.applications.keySet())) {
            try {
                this.undeploy(b);
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, "OSGiContainer", "undeployAll", "Exception undeploying bundle {0}", new Object[]{b.getLocation()});
                logger.logp(Level.SEVERE, "OSGiContainer", "undeployAll", "Exception Stack Trace", e);
            }
        }
    }

    protected void preDeploy(Bundle b) throws Exception {
    }

    protected void postDeploy(OSGiApplicationInfo osgiApplicationInfo) throws Exception {
    }

    protected void preUndeploy(OSGiApplicationInfo osgiApplicationInfo) throws Exception {
    }

    protected void postUndeploy(OSGiApplicationInfo osgiApplicationInfo) throws Exception {
    }

    private OSGiApplicationInfo deployJavaEEArtifacts(Bundle b, ActionReport report) {
        OSGiDeploymentRequest request = this.createOSGiDeploymentRequest(this.deployer, this.archiveFactory, this.env, report, b);
        return request.execute();
    }

    protected ActionReport undeployJavaEEArtifacts(OSGiApplicationInfo osgiAppInfo, ActionReport report) {
        OSGiUndeploymentRequest request = this.createOSGiUndeploymentRequest(this.deployer, this.env, report, osgiAppInfo);
        request.execute();
        return report;
    }

    protected ActionReport getReport() {
        return (ActionReport)Globals.getDefaultHabitat().getComponent(ActionReport.class, "plain");
    }

    public boolean isDeployed(Bundle bundle) {
        return this.applications.containsKey(bundle);
    }

    protected abstract OSGiUndeploymentRequest createOSGiUndeploymentRequest(Deployment var1, ServerEnvironmentImpl var2, ActionReport var3, OSGiApplicationInfo var4);

    protected abstract OSGiDeploymentRequest createOSGiDeploymentRequest(Deployment var1, ArchiveFactory var2, ServerEnvironmentImpl var3, ActionReport var4, Bundle var5);
}

