/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.common;

import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.EmbeddedSecurity;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.embedded.EmbeddedFileSystem;
import org.glassfish.api.embedded.EmbeddedLifecycle;
import org.glassfish.api.embedded.Server;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class EmbeddedSecurityLifeCycle
implements EmbeddedLifecycle {
    private static final Logger _logger = LogDomains.getLogger(EmbeddedSecurityLifeCycle.class, (String)"javax.enterprise.system.core.security");
    @Inject
    private EmbeddedSecurity embeddedSecurity;
    @Inject
    private SecurityService securityService;

    public void creation(Server server) {
        EmbeddedFileSystem fileSystem = server.getFileSystem();
        File instanceRoot = fileSystem.instanceRoot;
        if (instanceRoot == null) {
            return;
        }
        try {
            List<String> keyFileNames = this.embeddedSecurity.getKeyFileNames(this.securityService);
            for (String keyFileName : keyFileNames) {
                FileUtils.getManagedFile((String)("config" + File.separator + this.embeddedSecurity.parseFileName(keyFileName)), (File)instanceRoot);
            }
            FileUtils.getManagedFile((String)("config" + File.separator + "login.conf"), (File)instanceRoot);
            FileUtils.getManagedFile((String)("config" + File.separator + "server.policy"), (File)instanceRoot);
            FileUtils.getManagedFile((String)("config" + File.separator + "cacerts.jks"), (File)instanceRoot);
            FileUtils.getManagedFile((String)("config" + File.separator + "keystore.jks"), (File)instanceRoot);
            String keystoreFile = null;
            String truststoreFile = null;
            try {
                keystoreFile = Util.writeConfigFileToTempDir("keystore.jks").getAbsolutePath();
                truststoreFile = Util.writeConfigFileToTempDir("cacerts.jks").getAbsolutePath();
            }
            catch (IOException ex) {
                _logger.log(Level.SEVERE, "Error obtaining keystore and truststore files for embedded server", ex);
            }
            System.setProperty("javax.net.ssl.keyStore", keystoreFile);
            System.setProperty("javax.net.ssl.trustStore", truststoreFile);
        }
        catch (IOException ioEx) {
            _logger.log(Level.WARNING, "IOException", ioEx);
        }
    }

    public void destruction(Server server) {
    }
}

