/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.security.common.MasterPassword;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-password-aliases")
@Scoped(value=PerLookup.class)
@I18n(value="list.password.alias")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class ListPasswordAlias
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListPasswordAlias.class);
    @Inject(name="Security SSL Password Provider Service")
    private MasterPassword masterPasswordHelper;
    @Param(name="target", primary=true, optional=true, defaultValue="server")
    private String target;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PasswordAdapter pa = this.masterPasswordHelper.getMasterPasswordAdapter();
            Enumeration e = pa.getAliases();
            if (!e.hasMoreElements()) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                report.setMessage(localStrings.getLocalString("list.password.alias.nothingtolist", "Nothing to list"));
            }
            while (e.hasMoreElements()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage((String)e.nextElement());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            report.setMessage(localStrings.getLocalString("list.password.alias.fail", "Listing of Password Alias failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
            return;
        }
    }
}

