/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.impl.EntityManagerFactoryWrapper;
import com.sun.enterprise.container.common.impl.QueryWrapper;
import com.sun.enterprise.container.common.impl.TypedQueryWrapper;
import com.sun.enterprise.container.common.spi.JavaEEContainer;
import com.sun.enterprise.container.common.spi.util.CallFlowAgent;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.EntityManagerMethod;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerWrapper
implements EntityManager,
Serializable {
    static Logger _logger = LogDomains.getLogger(EntityManagerWrapper.class, (String)"javax.enterprise.system.util");
    private String unitName;
    private PersistenceContextType contextType;
    private Map emProperties;
    private transient EntityManagerFactory entityManagerFactory;
    private transient TransactionManager txManager;
    private transient InvocationManager invMgr;
    private transient EntityManager extendedEntityManager;
    private transient EntityManager nonTxEntityManager;
    private transient ComponentEnvManager compEnvMgr;
    private transient CallFlowAgent callFlowAgent;

    public EntityManagerWrapper(TransactionManager txManager, InvocationManager invMgr, ComponentEnvManager compEnvMgr, CallFlowAgent callFlowAgent) {
        this.txManager = txManager;
        this.invMgr = invMgr;
        this.compEnvMgr = compEnvMgr;
        this.callFlowAgent = callFlowAgent;
    }

    public void initializeEMWrapper(String unitName, PersistenceContextType contextType, Map emProperties) {
        this.unitName = unitName;
        this.contextType = contextType;
        this.emProperties = emProperties;
    }

    private void init() {
        this.entityManagerFactory = EntityManagerFactoryWrapper.lookupEntityManagerFactory(this.invMgr, this.compEnvMgr, this.unitName);
        if (this.entityManagerFactory == null) {
            throw new IllegalStateException("Unable to retrieve EntityManagerFactory for unitName " + this.unitName);
        }
    }

    private void doTransactionScopedTxCheck() {
        if (this.contextType != PersistenceContextType.TRANSACTION) {
            return;
        }
        this.doTxRequiredCheck();
    }

    private void doTxRequiredCheck() {
        if (this.entityManagerFactory == null) {
            this.init();
        }
        Transaction tx = null;
        try {
            tx = this.txManager.getTransaction();
        }
        catch (Exception e) {
            throw new IllegalStateException("exception retrieving tx", e);
        }
        if (tx == null) {
            throw new TransactionRequiredException();
        }
    }

    private EntityManager _getDelegate() {
        if (this.entityManagerFactory == null) {
            this.init();
        }
        EntityManager delegate = null;
        if (this.nonTxEntityManager != null) {
            this.cleanupNonTxEntityManager();
        }
        if (this.contextType == PersistenceContextType.TRANSACTION) {
            JavaEETransaction tx = null;
            try {
                tx = (JavaEETransaction)this.txManager.getTransaction();
            }
            catch (Exception e) {
                throw new IllegalStateException("exception retrieving tx", e);
            }
            if (tx != null) {
                delegate = tx.getExtendedEntityManager(this.entityManagerFactory);
                if (delegate == null && (delegate = tx.getTxEntityManager(this.entityManagerFactory)) == null) {
                    delegate = this.entityManagerFactory.createEntityManager(this.emProperties);
                    tx.addTxEntityManagerMapping(this.entityManagerFactory, delegate);
                }
            } else {
                delegate = this.nonTxEntityManager = this.entityManagerFactory.createEntityManager(this.emProperties);
            }
        } else {
            Object cc;
            ComponentInvocation ci;
            if (this.extendedEntityManager == null && (ci = this.invMgr.getCurrentInvocation()) != null && (cc = ci.getContainer()) instanceof JavaEEContainer) {
                this.extendedEntityManager = ((JavaEEContainer)cc).lookupExtendedEntityManager(this.entityManagerFactory);
            }
            delegate = this.extendedEntityManager;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("In EntityManagerWrapper::_getDelegate(). Logical entity manager  = " + this);
            _logger.fine("Physical entity manager = " + delegate);
        }
        return delegate;
    }

    private void cleanupNonTxEntityManager() {
        if (this.nonTxEntityManager != null) {
            this.nonTxEntityManager.close();
            this.nonTxEntityManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.PERSIST);
            }
            this._getDelegate().persist(entity);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.MERGE);
            }
            Object object = this._getDelegate().merge(entity);
            return (T)object;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REMOVE);
            }
            this._getDelegate().remove(entity);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND);
            }
            returnValue = this._getDelegate().find(entityClass, primaryKey);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND);
            }
            returnValue = this._getDelegate().find(entityClass, primaryKey, properties);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND_CLASS_OBJECT_LOCKMODETYPE);
            }
            returnValue = this._getDelegate().find(entityClass, primaryKey, lockMode);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND_CLASS_OBJECT_LOCKMODETYPE_PROPERTIES);
            }
            returnValue = this._getDelegate().find(entityClass, primaryKey, lockMode, properties);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_REFERENCE);
            }
            returnValue = this._getDelegate().getReference(entityClass, primaryKey);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.doTxRequiredCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FLUSH);
            }
            this._getDelegate().flush();
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public Query createQuery(String ejbqlString) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(ejbqlString);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, ejbqlString);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public <T> TypedQuery<T> createQuery(String ejbqlString, Class<T> resultClass) {
        TypedQuery<T> returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_STRING_CLASS);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(ejbqlString, resultClass);
            if (this.nonTxEntityManager != null) {
                TypedQuery<T> queryDelegate = returnValue;
                returnValue = TypedQueryWrapper.createQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, ejbqlString, resultClass);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        TypedQuery<T> returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_CRITERIA_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(criteriaQuery);
            if (this.nonTxEntityManager != null) {
                TypedQuery<T> queryDelegate = returnValue;
                returnValue = TypedQueryWrapper.createQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, criteriaQuery);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public Query createNamedQuery(String name) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedQuery(name);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createNamedQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, name);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        TypedQuery<T> returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedQuery(name, resultClass);
            if (this.nonTxEntityManager != null) {
                TypedQuery<T> queryDelegate = returnValue;
                returnValue = TypedQueryWrapper.createNamedQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, name, resultClass);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public Query createNativeQuery(String sqlString) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createNativeQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, sqlString);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING_CLASS);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString, resultClass);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createNativeQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, sqlString, resultClass);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString, resultSetMapping);
            if (this.nonTxEntityManager != null) {
                Query queryDelegate = returnValue;
                returnValue = QueryWrapper.createNativeQueryWrapper(this.entityManagerFactory, this.emProperties, delegate, queryDelegate, sqlString, resultSetMapping);
                this.nonTxEntityManager = null;
            }
        }
        catch (RuntimeException re) {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            throw re;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH);
            }
            this._getDelegate().refresh(entity);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, Map<String, Object> properties) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH_OBJECT_PROPERTIES);
            }
            this._getDelegate().refresh(entity, properties);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH_OBJECT_LOCKMODETYPE);
            }
            this._getDelegate().refresh(entity, lockMode);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH_OBJECT_LOCKMODETYPE_MAP);
            }
            this._getDelegate().refresh(entity, lockMode, properties);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CONTAINS);
            }
            EntityManager delegate = this._getDelegate();
            boolean bl = delegate.contains(entity);
            return bl;
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockModeType getLockMode(Object o) {
        this.doTxRequiredCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_LOCK_MODE);
            }
            LockModeType lockModeType = this._getDelegate().getLockMode(o);
            return lockModeType;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String propertyName, Object value) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.SET_PROPERTY);
            }
            this._getDelegate().setProperty(propertyName, value);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_PROPERTIES);
            }
            Map map = this._getDelegate().getProperties();
            return map;
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void close() {
        if (this.callFlowAgent.isEnabled()) {
            this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CLOSE);
            this.callFlowAgent.entityManagerMethodEnd();
        }
        throw new IllegalStateException();
    }

    public boolean isOpen() {
        if (this.callFlowAgent.isEnabled()) {
            this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.IS_OPEN);
            this.callFlowAgent.entityManagerMethodEnd();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityTransaction getTransaction() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_TRANSACTION);
            }
            EntityTransaction entityTransaction = this._getDelegate().getTransaction();
            return entityTransaction;
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory getEntityManagerFactory() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_ENTITY_MANAGER_FACTORY);
            }
            if (this.entityManagerFactory == null) {
                this.init();
            }
            EntityManagerFactory entityManagerFactory = this.entityManagerFactory;
            return entityManagerFactory;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CriteriaBuilder getCriteriaBuilder() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_CRITERIA_BUILDER);
            }
            CriteriaBuilder criteriaBuilder = this._getDelegate().getCriteriaBuilder();
            return criteriaBuilder;
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metamodel getMetamodel() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_METAMODEL);
            }
            Metamodel metamodel = this._getDelegate().getMetamodel();
            return metamodel;
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.LOCK);
            }
            this._getDelegate().lock(entity, lockMode);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.LOCK_LOCKMODETYPE_MAP);
            }
            this._getDelegate().lock(entity, lockMode, properties);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CLEAR);
            }
            this._getDelegate().clear();
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Object o) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.DETATCH);
            }
            this._getDelegate().detach(o);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDelegate() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_DELEGATE);
            }
            EntityManager entityManager = this._getDelegate();
            return entityManager;
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.nonTxEntityManager = null;
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_FLUSH_MODE);
            }
            FlushModeType flushModeType = this._getDelegate().getFlushMode();
            return flushModeType;
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushMode) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.SET_FLUSH_MODE);
            }
            this._getDelegate().setFlushMode(flushMode);
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void joinTransaction() {
        this.doTxRequiredCheck();
        if (this.callFlowAgent.isEnabled()) {
            this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.JOIN_TRANSACTION);
            this.callFlowAgent.entityManagerMethodEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unwrap(Class<T> tClass) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.UNWRAP);
            }
            Object object = this._getDelegate().unwrap(tClass);
            return (T)object;
        }
        finally {
            if (this.nonTxEntityManager != null) {
                this.cleanupNonTxEntityManager();
            }
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }
}

