/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.admin.util.ColumnFormatter;
import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.backup.BackupRestoreManager;
import com.sun.enterprise.backup.BackupWarningException;
import com.sun.enterprise.backup.DirectoryFilter;
import com.sun.enterprise.backup.Status;
import com.sun.enterprise.backup.ZipFilenameFilter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.ArrayList;

public class ListManager
extends BackupRestoreManager {
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListManager.class);
    File[] zips;
    private static final String BACKUP = strings.get("backup-list.backup-config");
    private static final String USER = strings.get("backup-list.user-name");
    private static final String DATE = strings.get("backup-list.date");
    private static final String FILENAME = strings.get("backup-list.filename");

    public ListManager(BackupRequest req) throws BackupException, BackupWarningException {
        super(req);
    }

    public String list() throws BackupException {
        StringBuffer sb = new StringBuffer();
        String[] headings = new String[]{BACKUP, USER, DATE, FILENAME};
        ArrayList<Integer> badPropsList = null;
        ColumnFormatter cf = null;
        boolean itemInRow = false;
        this.findZips(this.request.backupConfig == null);
        for (int i = 0; i < this.zips.length; ++i) {
            Status status = new Status();
            if (this.request.verbose) {
                sb.append(status.read(this.zips[i], this.request.terse));
                sb.append("\n\n");
                continue;
            }
            if (cf == null) {
                cf = new ColumnFormatter(headings);
                badPropsList = new ArrayList<Integer>();
            }
            if (!status.loadProps(this.zips[i])) {
                badPropsList.add(new Integer(i));
                continue;
            }
            String filename = status.getFileName();
            if (filename == null) {
                filename = strings.get("backup-list.unavailable");
            }
            cf.addRow(new Object[]{status.getBackupConfigName(), status.getUserName(), status.getTimeStamp(), filename});
            itemInRow = true;
        }
        if (cf != null) {
            sb.append(cf.toString());
        }
        if (!itemInRow && !this.request.terse) {
            sb.append("\n" + strings.get("backup-list.nothing"));
        }
        if (badPropsList != null && !badPropsList.isEmpty()) {
            sb.append("\n\n");
            sb.append(strings.get("backup-list.bad-props"));
            for (Integer iInt : badPropsList) {
                sb.append("\n");
                sb.append(this.zips[iInt]);
            }
        }
        return sb.toString();
    }

    void init() throws BackupException, BackupWarningException {
        super.init();
        if (!FileUtils.safeIsDirectory((File)this.request.domainDir)) {
            throw new BackupException("backup-res.NoDomainDir", this.request.domainDir);
        }
        if (!FileUtils.safeIsDirectory((File)this.getBackupDirectory(this.request))) {
            throw new BackupWarningException("backup-res.NoBackupDir", this.getBackupDirectory(this.request));
        }
    }

    private void findZips(boolean subdirs) throws BackupWarningException {
        ArrayList<File> zipList = new ArrayList<File>();
        File[] files = this.getBackupDirectory(this.request).listFiles(new ZipFilenameFilter());
        if (subdirs) {
            int i;
            for (i = 0; files != null && i < files.length; ++i) {
                zipList.add(files[i]);
            }
            File[] dirs = this.getBackupDirectory(this.request).listFiles(new DirectoryFilter());
            for (i = 0; dirs != null && i < dirs.length; ++i) {
                files = dirs[i].listFiles(new ZipFilenameFilter());
                for (int j = 0; files != null && j < files.length; ++j) {
                    zipList.add(files[j]);
                }
            }
            if (zipList.size() > 0) {
                this.zips = zipList.toArray(new File[0]);
            }
        } else {
            this.zips = files;
        }
        if (this.zips == null || this.zips.length <= 0) {
            throw new BackupWarningException("backup-res.NoBackupFiles", this.getBackupDirectory(this.request));
        }
    }
}

