/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.ee.resources;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.sql.DataSource;
import org.glassfish.osgi.ee.resources.BaseResourceManager;
import org.glassfish.osgi.ee.resources.Invalidate;
import org.glassfish.osgi.ee.resources.ResourceManager;
import org.jvnet.hk2.component.Habitat;
import org.osgi.framework.BundleContext;

public class JDBCResourceManager
extends BaseResourceManager
implements ResourceManager {
    public JDBCResourceManager(Habitat habitat) {
        super(habitat);
    }

    public void registerResources(BundleContext context) {
        this.registerJdbcResources(context);
    }

    private void registerJdbcResources(BundleContext context) {
        Resources resources = ((Domain)this.getHabitat().getComponent(Domain.class)).getResources();
        Collection jdbcResources = resources.getResources(JdbcResource.class);
        for (JdbcResource resource : jdbcResources) {
            ResourceRef resRef = this.getResourceHelper().getResourceRef(resource.getJndiName());
            this.registerJdbcResource(resource, resRef, context);
        }
    }

    public void registerResource(BindableResource resource, ResourceRef resRef, BundleContext bundleContext) {
        this.registerJdbcResource((JdbcResource)resource, resRef, bundleContext);
    }

    private void registerJdbcResource(JdbcResource resource, ResourceRef resRef, BundleContext bundleContext) {
        if (resource.getEnabled().equalsIgnoreCase("true") && resRef != null && resRef.getEnabled().equalsIgnoreCase("true")) {
            String poolName = resource.getPoolName();
            JdbcConnectionPool pool = (JdbcConnectionPool)this.getResources().getResourceByName(JdbcConnectionPool.class, poolName);
            String className = pool.getResType().equalsIgnoreCase("java.sql.Driver") ? pool.getDriverClassname() : pool.getDatasourceClassname();
            Class[] intf = new Class[]{DataSource.class, Invalidate.class};
            Object proxy = this.getProxy(resource.getJndiName(), intf, this.getClassLoader());
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("osgi.jdbc.driver.class", className);
            ((Dictionary)properties).put("jndi-name", resource.getJndiName());
            this.registerResourceAsService(bundleContext, (BindableResource)resource, "javax.sql.DataSource", properties, proxy);
        }
    }

    public boolean handlesResource(BindableResource resource) {
        return resource instanceof JdbcResource;
    }
}

