/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.embedded.Server;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class Util {
    @Inject
    private static Habitat habitat;
    @Inject
    private ProcessEnvironment penv;
    private CallbackHandler callbackHandler;
    private Object appClientMsgSecConfigs;

    public static Habitat getDefaultHabitat() {
        return habitat;
    }

    public static Util getInstance() {
        return (Util)habitat.getComponent(Util.class);
    }

    public boolean isACC() {
        return this.penv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }

    public boolean isServer() {
        return this.penv.getProcessType().isServer();
    }

    public boolean isNotServerORACC() {
        return this.penv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Other);
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public Object getAppClientMsgSecConfigs() {
        return this.appClientMsgSecConfigs;
    }

    public void setAppClientMsgSecConfigs(Object appClientMsgSecConfigs) {
        this.appClientMsgSecConfigs = appClientMsgSecConfigs;
    }

    public static boolean isEmbeddedServer() {
        List servers = Server.getServerNames();
        return !servers.isEmpty();
    }

    public static File writeConfigFileToTempDir(String fileName) throws IOException {
        File filePath = new File(fileName);
        if (filePath.exists()) {
            return filePath;
        }
        File localFile = null;
        if (filePath.getParentFile() != null && filePath.getParentFile().exists()) {
            localFile = filePath;
            localFile.createNewFile();
        } else {
            String userHome = System.getProperty("user.home");
            String embeddedServerName = Util.getCurrentEmbeddedServerName();
            File tempDir = new File(userHome + File.separator + ".glassfish3-" + embeddedServerName + File.separator + "config");
            boolean mkDirSuccess = true;
            if (!tempDir.exists()) {
                mkDirSuccess = tempDir.mkdirs();
            }
            localFile = new File(tempDir.getAbsolutePath() + File.separator + fileName);
            if (mkDirSuccess && !localFile.exists()) {
                localFile.createNewFile();
            }
        }
        FileOutputStream oStream = new FileOutputStream(localFile);
        InputStream iStream = Util.class.getResourceAsStream("/config/" + fileName);
        while (iStream != null && iStream.available() > 0) {
            oStream.write(iStream.read());
        }
        oStream.close();
        if (iStream != null) {
            iStream.close();
        }
        return localFile;
    }

    public static String getCurrentEmbeddedServerName() {
        List embeddedServerNames = Server.getServerNames();
        String embeddedServerName = embeddedServerNames.get(0) == null ? "embedded" : (String)embeddedServerNames.get(0);
        return embeddedServerName;
    }
}

