/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.Extender;
import org.glassfish.osgijavaeebase.OSGiContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class JavaEEExtender
implements Extender,
SynchronousBundleListener {
    private OSGiContainer c;
    private static final Logger logger = Logger.getLogger(JavaEEExtender.class.getPackage().getName());
    private BundleContext context;
    private ServiceRegistration reg;

    public JavaEEExtender(BundleContext context) {
        this.context = context;
    }

    public synchronized void start() {
        this.c = new OSGiContainer(this.context);
        this.c.init();
        this.reg = this.context.registerService(OSGiContainer.class.getName(), (Object)this.c, null);
        this.context.addBundleListener((BundleListener)this);
    }

    public synchronized void stop() {
        if (this.c == null) {
            return;
        }
        this.context.removeBundleListener((BundleListener)this);
        if (this.c != null) {
            this.c.shutdown();
        }
        this.c = null;
        this.reg.unregister();
        this.reg = null;
    }

    public void bundleChanged(final BundleEvent event) {
        new Thread("Java EE Extender Thread"){

            public void run() {
                JavaEEExtender.this.handleEvent(event);
            }
        }.start();
    }

    private void handleEvent(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 2: {
                if (this.c.isDeployed(bundle)) break;
                this.deploy(bundle);
                break;
            }
            case 512: {
                this.deploy(bundle);
                break;
            }
            case 4: {
                this.undeploy(bundle);
            }
        }
    }

    private synchronized void deploy(Bundle b) {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.c.deploy(b);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "JavaEEExtender", "deploy", "Exception deploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "JavaEEExtender", "deploy", "Exception Stack Trace", e);
        }
    }

    private synchronized void undeploy(Bundle b) {
        if (!this.isStarted()) {
            return;
        }
        try {
            if (this.c.isDeployed(b)) {
                this.c.undeploy(b);
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "JavaEEExtender", "undeploy", "Exception undeploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "JavaEEExtender", "undeploy", "Exception Stack Trace", e);
        }
    }

    private synchronized boolean isStarted() {
        return this.c != null;
    }
}

