/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityLifecycle;
import com.sun.enterprise.security.SecuritySniffer;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.auth.realm.file.FileRealmUser;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.common.util.admin.AuthTokenManager;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.LocalPassword;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.security.common.Group;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@ContractProvided(value=JMXAuthenticator.class)
public class GenericAdminAuthenticator
implements AdminAccessController,
JMXAuthenticator,
PostConstruct {
    @Inject
    Habitat habitat;
    @Inject
    SecuritySniffer snif;
    @Inject
    volatile SecurityService ss;
    @Inject
    volatile AdminService as;
    @Inject
    LocalPassword localPassword;
    @Inject
    ServerContext sc;
    @Inject
    Domain domain;
    @Inject
    private AuthTokenManager authTokenManager;
    private SSLUtils sslUtils = null;
    private SecureAdmin secureAdmin;
    @Inject
    ServerEnvironment serverEnv;
    private static LocalStringManagerImpl lsm = new LocalStringManagerImpl(GenericAdminAuthenticator.class);
    private final Logger logger = LogDomains.getLogger(GenericAdminAuthenticator.class, (String)"javax.enterprise.system.tools.admin");
    private KeyStore truststore = null;
    private Map<String, Principal> serverPrincipals = new HashMap<String, Principal>();

    public void postConstruct() {
        this.secureAdmin = this.domain.getSecureAdmin();
    }

    public AdminAccessController.Access loginAsAdmin(String user, String password, String realm, String originHost) throws LoginException {
        return this.loginAsAdmin(user, password, realm, originHost, Collections.EMPTY_MAP, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminAccessController.Access loginAsAdmin(String user, String password, String realm, String originHost, Map<String, String> authRelatedHeaders, Principal requestPrincipal) throws LoginException {
        boolean isLocal = this.isLocalPassword(user, password);
        if (isLocal) {
            this.logger.fine("Accepted locally-provisioned password authentication");
            return AdminAccessController.Access.FULL;
        }
        boolean result = this.authenticateAsTrustedSender(authRelatedHeaders, requestPrincipal);
        if (result) {
            this.logger.log(Level.FINE, "Authenticated as trusted sender");
            return AdminAccessController.Access.FULL;
        }
        if (this.as.usesFileRealm()) {
            AdminAccessController.Access access;
            result = this.handleFileRealm(user, password);
            this.logger.log(Level.FINE, "Not a \"trusted sender\"; file realm user authentication {1} for admin user {0}", new Object[]{user, result ? "passed" : "failed"});
            if (result) {
                access = this.chooseAccess(originHost);
                this.logger.log(Level.FINE, "Authorized {0} access for user {1}", new Object[]{access, user});
            } else {
                access = AdminAccessController.Access.NONE;
            }
            return access;
        }
        ClassLoader pc = null;
        boolean hack = false;
        boolean authenticated = false;
        try {
            pc = Thread.currentThread().getContextClassLoader();
            if (!this.sc.getCommonClassLoader().equals(pc)) {
                Thread.currentThread().setContextClassLoader(this.sc.getCommonClassLoader());
                hack = true;
            }
            Inhabitant sl = this.habitat.getInhabitantByType(SecurityLifecycle.class);
            sl.get();
            this.snif.setup(System.getProperty("com.sun.aas.installRoot") + "/modules/security", Logger.getAnonymousLogger());
            LoginContextDriver.login((String)user, (char[])password.toCharArray(), (String)realm);
            authenticated = true;
            boolean isConsideredInAdminGroup = this.as.getAssociatedAuthRealm().getGroupMapping() == null || this.ensureGroupMembership(user, realm);
            AdminAccessController.Access access = isConsideredInAdminGroup ? this.chooseAccess(originHost) : AdminAccessController.Access.NONE;
            return access;
        }
        catch (Exception e) {
            AdminAccessController.Access access = AdminAccessController.Access.NONE;
            return access;
        }
        finally {
            if (hack) {
                Thread.currentThread().setContextClassLoader(pc);
            }
        }
    }

    private AdminAccessController.Access chooseAccess(String originHost) {
        AdminAccessController.Access grantedAccess = AdminAccessController.Access.MONITORING;
        if (this.serverEnv.isDas() && (NetUtils.isThisHostLocal((String)originHost) || SecureAdmin.Util.isEnabled((SecureAdmin)this.secureAdmin))) {
            grantedAccess = AdminAccessController.Access.FULL;
        }
        return grantedAccess;
    }

    private boolean authenticateAsTrustedSender(Map<String, String> authRelatedHeaders, Principal reqPrincipal) throws LoginException {
        boolean result = this.authenticateUsingCert(reqPrincipal, this.serverEnv.isDas() ? SecureAdmin.Util.instanceAlias((SecureAdmin)this.secureAdmin) : SecureAdmin.Util.DASAlias((SecureAdmin)this.secureAdmin));
        if (result) {
            this.logger.log(Level.FINE, "Authenticated SSL client auth principal {0}", reqPrincipal.getName());
            return result;
        }
        if (!SecureAdmin.Util.isEnabled((SecureAdmin)this.secureAdmin) && (result = this.authenticateUsingSpecialIndicator(authRelatedHeaders.get("X-GlassFish-admin")))) {
            this.logger.log(Level.FINE, "Authenticated server using server admin header indicator");
            return result;
        }
        result = this.authenticateUsingOneTimeToken(authRelatedHeaders.get("X-GlassFish-authToken"));
        if (result) {
            this.logger.log(Level.FINE, "Authenticated using one-time auth token");
        }
        return result;
    }

    private boolean authenticateUsingCert(Principal reqPrincipal, String instanceAlias) throws LoginException {
        if (reqPrincipal == null) {
            return false;
        }
        try {
            Principal expectedPrincipal = this.expectedPrincipal(instanceAlias);
            return expectedPrincipal != null ? ((Object)expectedPrincipal).equals(reqPrincipal) : false;
        }
        catch (Exception ex) {
            LoginException loginEx = new LoginException();
            loginEx.initCause(ex);
            throw loginEx;
        }
    }

    private synchronized KeyStore trustStore() throws IOException {
        if (this.truststore == null) {
            this.truststore = this.sslUtils().getTrustStore();
        }
        return this.truststore;
    }

    private synchronized SSLUtils sslUtils() {
        if (this.sslUtils == null) {
            this.sslUtils = (SSLUtils)this.habitat.getComponent(SSLUtils.class);
        }
        return this.sslUtils;
    }

    private synchronized Principal expectedPrincipal(String instanceAlias) throws IOException, KeyStoreException {
        Principal result = this.serverPrincipals.get(instanceAlias);
        if (result == null) {
            Certificate cert = this.trustStore().getCertificate(instanceAlias);
            if (cert == null || !(cert instanceof X509Certificate)) {
                return null;
            }
            result = ((X509Certificate)cert).getSubjectX500Principal();
            this.serverPrincipals.put(instanceAlias, result);
        }
        return result;
    }

    private boolean authenticateUsingSpecialIndicator(String candidateSpecialAdminIndicator) {
        if (candidateSpecialAdminIndicator == null) {
            return false;
        }
        return candidateSpecialAdminIndicator.equals(SecureAdmin.Util.configuredAdminIndicator((SecureAdmin)this.secureAdmin));
    }

    private boolean authenticateUsingOneTimeToken(String oneTimeAuthToken) {
        return oneTimeAuthToken == null ? false : this.authTokenManager.consumeToken(oneTimeAuthToken);
    }

    private boolean ensureGroupMembership(String user, String realm) {
        try {
            SecurityContext sc = SecurityContext.getCurrent();
            Set ps = sc.getPrincipalSet();
            for (Object principal : ps) {
                Group group;
                if (!(principal instanceof Group) || !(group = (Group)principal).getName().equals("asadmin")) continue;
                return true;
            }
            this.logger.fine("User is not the member of the special admin group");
            return false;
        }
        catch (Exception e) {
            this.logger.fine("User is not the member of the special admin group: " + e.getMessage());
            return false;
        }
    }

    private boolean handleFileRealm(String user, String password) throws LoginException {
        if (user == null || user.length() == 0) {
            String defuser = this.getDefaultAdminUser();
            if (defuser != null) {
                user = defuser;
                this.logger.fine("Using default user: " + defuser);
            } else {
                this.logger.fine("No default user");
            }
        }
        try {
            AuthRealm ar = this.as.getAssociatedAuthRealm();
            if (FileRealm.class.getName().equals(ar.getClassname())) {
                String adminKeyFilePath = ar.getPropertyValue("file");
                FileRealm fr = new FileRealm(adminKeyFilePath);
                FileRealmUser fru = (FileRealmUser)fr.getUser(user);
                for (String group : fru.getGroups()) {
                    if (!group.equals("asadmin")) continue;
                    return fr.authenticate(user, password.toCharArray()) != null;
                }
                return false;
            }
        }
        catch (NoSuchUserException ue) {
            return false;
        }
        catch (Exception e) {
            LoginException le = new LoginException(e.getMessage());
            le.initCause(e);
            throw le;
        }
        return false;
    }

    private String getDefaultAdminUser() {
        AuthRealm realm = this.as.getAssociatedAuthRealm();
        if (realm == null) {
            throw new RuntimeException("Warning: Configuration is bad, realm: " + this.as.getAuthRealmName() + " does not exist!");
        }
        if (!FileRealm.class.getName().equals(realm.getClassname())) {
            this.logger.fine("CAN'T FIND DEFAULT ADMIN USER: IT'S NOT A FILE REALM");
            return null;
        }
        String pv = realm.getPropertyValue("file");
        File rf = null;
        if (pv == null || !(rf = new File(pv)).exists()) {
            this.logger.fine("CAN'T FIND DEFAULT ADMIN USER: THE KEYFILE DOES NOT EXIST");
            return null;
        }
        try {
            FileRealm fr = new FileRealm(rf.getAbsolutePath());
            Enumeration users = fr.getUserNames();
            if (users.hasMoreElements()) {
                FileRealmUser fru;
                String[] arr$;
                int len$;
                int i$;
                String au = (String)users.nextElement();
                if (!users.hasMoreElements() && (i$ = 0) < (len$ = (arr$ = (fru = (FileRealmUser)fr.getUser(au)).getGroups()).length)) {
                    String group = arr$[i$];
                    if (group.equals("asadmin")) {
                        this.logger.fine("Attempting access using default admin user: " + au);
                    }
                    return au;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private boolean isLocalPassword(String user, String password) {
        if (!this.localPassword.isLocalPassword(password)) {
            this.logger.finest("Password is not the local password");
            return false;
        }
        this.logger.fine("Allowing access using local password");
        return true;
    }

    @Override
    public Subject authenticate(Object credentials) {
        String realm;
        String user = "";
        String password = "";
        String host = null;
        if (credentials instanceof String[]) {
            String[] up = (String[])credentials;
            if (up.length == 1) {
                user = up[0];
            } else if (up.length >= 2) {
                user = up[0];
                password = up[1];
                if (password == null) {
                    password = "";
                }
            }
            if (up.length > 2) {
                host = up[2];
            }
        }
        if ((realm = this.as.getSystemJmxConnector().getAuthRealmName()) == null) {
            realm = this.as.getAuthRealmName();
        }
        try {
            AdminAccessController.Access result = this.loginAsAdmin(user, password, realm, host);
            if (result == AdminAccessController.Access.NONE) {
                String msg = lsm.getLocalString("authentication.failed", "User [{0}] does not have administration access", new Object[]{user});
                throw new SecurityException(msg);
            }
            return null;
        }
        catch (LoginException e) {
            throw new SecurityException(e);
        }
    }
}

