/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.Extender;
import org.glassfish.osgijavaeebase.OSGiContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class JavaEEExtender
implements Extender {
    private OSGiContainer c;
    private static final Logger logger = Logger.getLogger(JavaEEExtender.class.getPackage().getName());
    private BundleContext context;
    private ServiceRegistration reg;
    private BundleTracker tracker;
    private ExecutorService executorService;

    public JavaEEExtender(BundleContext context) {
        this.context = context;
    }

    public synchronized void start() {
        this.executorService = Executors.newSingleThreadExecutor();
        this.c = new OSGiContainer(this.context);
        this.c.init();
        this.reg = this.context.registerService(OSGiContainer.class.getName(), (Object)this.c, null);
        this.tracker = new BundleTracker(this.context, 40, (BundleTrackerCustomizer)new HybridBundleTrackerCustomizer());
        this.tracker.open();
    }

    public synchronized void stop() {
        if (this.c == null) {
            return;
        }
        this.c.shutdown();
        this.c = null;
        if (this.tracker != null) {
            this.tracker.close();
        }
        this.tracker = null;
        this.reg.unregister();
        this.reg = null;
        this.executorService.shutdownNow();
    }

    private void handleEvent(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 2: {
                if (this.c.isDeployed(bundle)) break;
                this.deploy(bundle);
                break;
            }
            case 512: {
                this.deploy(bundle);
                break;
            }
            case 4: {
                this.undeploy(bundle);
            }
        }
    }

    private synchronized void deploy(Bundle b) {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.c.deploy(b);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "JavaEEExtender", "deploy", "Exception deploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "JavaEEExtender", "deploy", "Exception Stack Trace", e);
        }
    }

    private synchronized void undeploy(Bundle b) {
        if (!this.isStarted()) {
            return;
        }
        try {
            if (this.c.isDeployed(b)) {
                this.c.undeploy(b);
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "JavaEEExtender", "undeploy", "Exception undeploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "JavaEEExtender", "undeploy", "Exception Stack Trace", e);
        }
    }

    private synchronized boolean isStarted() {
        return this.c != null;
    }

    private class HybridBundleTrackerCustomizer
    implements BundleTrackerCustomizer {
        private HybridBundleTrackerCustomizer() {
        }

        public Object addingBundle(final Bundle bundle, BundleEvent event) {
            int state = bundle.getState();
            if (this.isReady(event, state)) {
                JavaEEExtender.this.executorService.submit(new Runnable(){

                    public void run() {
                        JavaEEExtender.this.deploy(bundle);
                    }
                });
                return bundle;
            }
            return null;
        }

        private boolean isReady(BundleEvent event, int state) {
            return state == 32 || state == 8 && event != null && event.getType() == 512;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        }

        public void removedBundle(final Bundle bundle, BundleEvent event, Object object) {
            JavaEEExtender.this.executorService.submit(new Runnable(){

                public void run() {
                    JavaEEExtender.this.undeploy(bundle);
                }
            });
        }
    }
}

