/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.osgijavaeebase.Extender;
import org.jvnet.hk2.component.Habitat;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class ExtenderManager {
    private static final Logger logger = Logger.getLogger(ExtenderManager.class.getPackage().getName());
    private BundleContext context;
    private Events events;
    private EventListener listener;
    private ServiceTracker extenderTracker;
    private GlassFishServerTracker glassFishServerTracker;

    public ExtenderManager(BundleContext context) {
        this.context = context;
    }

    public synchronized void start() throws Exception {
        logger.logp(Level.FINE, "ExtenderManager", "start", "ExtenderManager starting");
        this.glassFishServerTracker = new GlassFishServerTracker(this.context);
        this.glassFishServerTracker.open();
    }

    public synchronized void stop() throws Exception {
        logger.logp(Level.FINE, "ExtenderManager", "start", "ExtenderManager stopping");
        this.unregisterGlassFishShutdownHook();
        if (this.glassFishServerTracker != null) {
            this.glassFishServerTracker.close();
            this.glassFishServerTracker = null;
        }
        this.stopExtenders();
    }

    private synchronized void startExtenders() {
        logger.entering("ExtenderManager", "startExtenders");
        if (this.extenderTracker != null) {
            return;
        }
        this.extenderTracker = new ExtenderTracker(this.context);
        this.extenderTracker.open();
    }

    private synchronized void stopExtenders() {
        logger.entering("ExtenderManager", "stopExtenders");
        if (this.extenderTracker == null) {
            return;
        }
        this.extenderTracker.close();
        this.extenderTracker = null;
    }

    private void unregisterGlassFishShutdownHook() {
        if (this.listener != null) {
            this.events.unregister(this.listener);
        }
    }

    private class GlassFishServerTracker
    extends ServiceTracker {
        public GlassFishServerTracker(BundleContext context) {
            super(context, Habitat.class.getName(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference reference) {
            try {
                logger.logp(Level.FINE, "ExtenderManager$GlassFishServerTracker", "addingService", "Habitat has been created");
                ServiceReference habitatServiceRef = this.context.getServiceReference(Habitat.class.getName());
                Habitat habitat = (Habitat)Habitat.class.cast(this.context.getService(habitatServiceRef));
                ExtenderManager.this.events = (Events)habitat.getComponent(Events.class);
                ExtenderManager.this.listener = new EventListener(){

                    public void event(EventListener.Event event) {
                        if (EventTypes.SERVER_READY.equals((Object)event.type())) {
                            ExtenderManager.this.startExtenders();
                        } else if (EventTypes.PREPARE_SHUTDOWN.equals((Object)event.type())) {
                            ExtenderManager.this.stopExtenders();
                        }
                    }
                };
                ExtenderManager.this.events.register(ExtenderManager.this.listener);
                if (((ServerEnvironment)habitat.getComponent(ServerEnvironment.class)).getStatus() == ServerEnvironment.Status.started) {
                    ExtenderManager.this.startExtenders();
                }
                Object object = super.addingService(reference);
                return object;
            }
            finally {
                this.close();
            }
        }
    }

    private class ExtenderTracker
    extends ServiceTracker {
        ExtenderTracker(BundleContext context) {
            super(context, Extender.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            Extender e = (Extender)Extender.class.cast(this.context.getService(reference));
            logger.logp(Level.FINE, "ExtenderManager$ExtenderTracker", "addingService", "Starting extender called {0}", new Object[]{e});
            e.start();
            return e;
        }

        public void removedService(ServiceReference reference, Object service) {
            Extender e = (Extender)Extender.class.cast(this.context.getService(reference));
            logger.logp(Level.FINE, "ExtenderManager$ExtenderTracker", "removedService", "Stopping extender called {0}", new Object[]{e});
            e.stop();
        }
    }
}

