/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.osgicontainer;

import java.io.File;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.extras.osgicontainer.OSGiContainer;
import org.glassfish.extras.osgicontainer.OSGiDeployedBundle;
import org.jvnet.hk2.annotations.Service;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class OSGiDeployer
implements Deployer<OSGiContainer, OSGiDeployedBundle> {
    private Bundle bundle;

    public OSGiDeployedBundle load(OSGiContainer container, DeploymentContext context) {
        return new OSGiDeployedBundle(this.bundle);
    }

    public void unload(OSGiDeployedBundle appContainer, DeploymentContext context) {
    }

    public void clean(DeploymentContext context) {
        try {
            this.bundle.uninstall();
            this.getPA().refreshPackages(new Bundle[]{this.bundle});
            System.out.println("Uninstalled " + this.bundle);
            this.bundle = null;
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    private PackageAdmin getPA() {
        BundleContext context = this.getBundleContext();
        return (PackageAdmin)context.getService(context.getServiceReference(PackageAdmin.class.getName()));
    }

    public MetaData getMetaData() {
        return null;
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public boolean prepare(DeploymentContext context) {
        File file = context.getSourceDir();
        try {
            assert (file.isDirectory());
            this.bundle = this.getBundleContext().installBundle("reference:" + file.toURI().toString());
            System.out.println("Installed " + this.bundle + " from " + this.bundle.getLocation());
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private BundleContext getBundleContext() {
        return ((BundleReference)BundleReference.class.cast(this.getClass().getClassLoader())).getBundle().getBundleContext();
    }
}

