/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.services;

import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.Constants;
import com.sun.enterprise.admin.servermgmt.services.NonSMFServiceAdapter;
import com.sun.enterprise.admin.servermgmt.services.ServicesUtils;
import com.sun.enterprise.admin.servermgmt.services.Strings;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinuxService
extends NonSMFServiceAdapter {
    private String targetName;
    File target;
    private static final String TEMPLATE_FILE_NAME = "linux-service.template";
    private List<File> killDirs = new ArrayList<File>();
    private List<File> startDirs = new ArrayList<File>();
    private String sFile;
    private String kFile;
    private boolean hasStartStopTokens = false;

    static boolean apropos() {
        if (Constants.LINUX_HACK) {
            return true;
        }
        return OS.isLinux();
    }

    LinuxService(ServerDirs dirs, AppserverServiceType type) {
        super(dirs, type);
        if (!LinuxService.apropos()) {
            throw new IllegalArgumentException(Strings.get("internal.error", "Constructor called but Linux Services are not available."));
        }
        this.setRcDirs();
    }

    @Override
    public void initializeInternal() {
        try {
            this.getTokenMap().put("SERVICEUSER_START", this.getServiceUserStart());
            this.getTokenMap().put("SERVICEUSER_STOP", this.getServiceUserStop());
            this.setTemplateFile(TEMPLATE_FILE_NAME);
            this.checkFileSystem();
            this.setTarget();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final void createServiceInternal() {
        try {
            this.handlePreExisting(this.info.force);
            ServicesUtils.tokenReplaceTemplateAtDestination(this.getTokenMap(), this.getTemplateFile().getPath(), this.target.getPath());
            this.trace("Target file written: " + this.target);
            this.trace("**********   Object Dump  **********\n" + this.toString());
            if (this.deleteLinks() == 0 && !this.info.dryRun) {
                System.out.println(Strings.get("linux.services.uninstall.good"));
            } else {
                this.trace("No preexisting Service with that name was found");
            }
            this.install();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final void deleteServiceInternal() {
        try {
            this.uninstall();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final String getSuccessMessage() {
        if (this.info.dryRun) {
            return Strings.get("dryrun");
        }
        return Strings.get("LinuxServiceCreated", this.info.serviceName, this.info.type.toString(), this.target, this.getFinalUser(), this.target.getName());
    }

    @Override
    public final void writeReadmeFile(String msg) {
        File f = new File(this.getServerDirs().getServerDir(), "PlatformServices.log");
        ServicesUtils.appendTextToFile(f, msg);
    }

    public final String toString() {
        return ObjectAnalyzer.toStringWithSuper((Object)this);
    }

    @Override
    public final String getLocationArgsStart() {
        if (this.isDomain()) {
            return " --domaindir " + this.getServerDirs().getServerParentDir().getPath() + " ";
        }
        return " --nodedir " + this.getServerDirs().getServerGrandParentDir().getPath() + " --node " + this.getServerDirs().getServerParentDir().getName() + " ";
    }

    @Override
    public final String getLocationArgsStop() {
        return this.getLocationArgsStart();
    }

    private void setRcDirs() {
        File[] rcDirs = new File[8];
        if (!this.setRcDirs(new File("/etc"), rcDirs) && !this.setRcDirs(new File("/etc/init.d"), rcDirs)) {
            throw new RuntimeException(Strings.get("no_rc2"));
        }
        this.addKills(rcDirs);
        this.addStarts(rcDirs);
    }

    private boolean setRcDirs(File dir, File[] rcDirs) {
        int i;
        if (!new File(dir, "rc5.d").isDirectory()) {
            return false;
        }
        for (i = 0; i < 7; ++i) {
            rcDirs[i] = new File(dir, "rc" + i + ".d");
        }
        rcDirs[7] = new File(dir, "rcS.d");
        for (i = 0; i < 8; ++i) {
            rcDirs[i] = this.validate(rcDirs[i]);
        }
        return true;
    }

    private void addKills(File[] rcDirs) {
        if (rcDirs[0] != null) {
            this.killDirs.add(rcDirs[0]);
        }
        if (rcDirs[1] != null) {
            this.killDirs.add(rcDirs[1]);
        }
        if (rcDirs[6] != null) {
            this.killDirs.add(rcDirs[6]);
        }
        if (rcDirs[7] != null) {
            this.killDirs.add(rcDirs[7]);
        }
    }

    private void addStarts(File[] rcDirs) {
        if (rcDirs[2] != null) {
            this.startDirs.add(rcDirs[2]);
        }
        if (rcDirs[3] != null) {
            this.startDirs.add(rcDirs[3]);
        }
        if (rcDirs[4] != null) {
            this.startDirs.add(rcDirs[4]);
        }
        if (rcDirs[5] != null) {
            this.startDirs.add(rcDirs[5]);
        }
    }

    private File validate(File rcdir) {
        if (rcdir == null) {
            return null;
        }
        if (!(rcdir = FileUtils.safeGetCanonicalFile((File)rcdir)).isDirectory()) {
            return null;
        }
        return rcdir;
    }

    private void checkFileSystem() {
        File initd = new File("/etc/init.d");
        this.checkDir(initd, "no_initd");
    }

    private void checkDir(File dir, String notDirMsg) {
        if (!dir.isDirectory()) {
            throw new RuntimeException(Strings.get(notDirMsg, dir));
        }
        if (!dir.canWrite()) {
            throw new RuntimeException(Strings.get("no_write_dir", dir));
        }
    }

    private void handlePreExisting(boolean force) {
        if (this.isPreExisting()) {
            if (force) {
                this.target.delete();
                this.handlePreExisting(false);
            } else {
                throw new RuntimeException(Strings.get("services.alreadyCreated", this.target, "rm"));
            }
        }
    }

    private boolean isPreExisting() {
        return this.target.isFile();
    }

    private void install() throws ProcessManagerException {
        this.createLinks();
    }

    int uninstall() {
        if (this.target.delete()) {
            this.trace("Deleted " + this.target);
        }
        return this.deleteLinks();
    }

    private int deleteLinks() {
        this.trace("Deleting link files...");
        LinkedList<File> deathRow = new LinkedList<File>();
        if (!StringUtils.ok((String)this.targetName)) {
            throw new RuntimeException("Programmer Internal Error");
        }
        String regexp = "[KS][0-9][0-9]?" + this.targetName;
        ArrayList<File> allDirs = new ArrayList<File>(this.killDirs);
        allDirs.addAll(this.startDirs);
        for (File dir : allDirs) {
            File[] matches = FileUtils.findFilesInDir((File)dir, (String)regexp);
            if (matches.length < 1) continue;
            if (matches.length == 1) {
                deathRow.add(matches[0]);
                continue;
            }
            this.tooManyLinks(matches);
        }
        for (File f : deathRow) {
            if (f.canWrite()) continue;
            throw new RuntimeException(Strings.get("cant_delete", f));
        }
        for (File f : deathRow) {
            if (this.info.dryRun) {
                this.dryRun("Would have deleted: " + f);
                continue;
            }
            if (!f.delete()) {
                throw new RuntimeException(Strings.get("cant_delete", f));
            }
            this.trace("Deleted " + f);
        }
        return deathRow.size();
    }

    private void createLinks() {
        String[] cmds = new String[4];
        cmds[0] = "ln";
        cmds[1] = "-s";
        cmds[2] = this.target.getAbsolutePath();
        this.createLinks(cmds, this.kFile, this.killDirs);
        this.createLinks(cmds, this.sFile, this.startDirs);
    }

    private void createLinks(String[] cmds, String linkname, List<File> dirs) {
        String path = this.target.getAbsolutePath();
        for (File dir : dirs) {
            File link = new File(dir, linkname);
            cmds[3] = link.getAbsolutePath();
            String cmd = this.toString(cmds);
            if (Constants.LINUX_HACK) {
                this.trace(cmd);
                continue;
            }
            if (this.info.dryRun) {
                this.dryRun(cmd);
                continue;
            }
            this.createLink(link, cmds);
        }
    }

    private void createLink(File link, String[] cmds) {
        try {
            ProcessManager mgr = new ProcessManager(cmds);
            mgr.setEcho(false);
            mgr.execute();
            this.trace("Create Link Output: " + mgr.getStdout() + mgr.getStderr());
            link.setExecutable(true, false);
            this.trace("Created link file: " + link);
        }
        catch (ProcessManagerException e) {
            throw new RuntimeException(Strings.get("ln_error", new Object[]{this.toString(cmds), e}));
        }
    }

    private void tooManyLinks(File[] matches) {
        String theMatches = "";
        boolean first = true;
        for (File f : matches) {
            if (first) {
                first = false;
            } else {
                theMatches = theMatches + "\n";
            }
            theMatches = theMatches + f.getAbsolutePath();
        }
        throw new RuntimeException(Strings.get("too_many_links", theMatches));
    }

    private void setTarget() {
        this.targetName = "GlassFish_" + this.info.serverDirs.getServerName();
        this.target = new File("/etc/init.d/" + this.targetName);
        this.kFile = "K" + this.info.kPriority + this.targetName;
        this.sFile = "S" + this.info.sPriority + this.targetName;
    }

    private String getServiceUserStart() {
        String u = this.getFinalUserButNotRoot();
        boolean bl = this.hasStartStopTokens = u != null;
        if (this.hasStartStopTokens) {
            return "su --login " + u + " --command \"";
        }
        return "";
    }

    private String getServiceUserStop() {
        if (this.hasStartStopTokens) {
            return "\"";
        }
        return "";
    }

    private String getFinalUser() {
        if (StringUtils.ok((String)this.info.serviceUser)) {
            return this.info.serviceUser;
        }
        return this.info.osUser;
    }

    private String getFinalUserButNotRoot() {
        String u = this.getFinalUser();
        if ("root".equals(u)) {
            return null;
        }
        return u;
    }

    private String toString(String[] arr) {
        StringBuilder sb = new StringBuilder();
        for (String s : arr) {
            sb.append(s).append(" ");
        }
        return sb.toString();
    }
}

