/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.admin.cli;

import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.security.admin.cli.SecureAdminCommand;
import com.sun.enterprise.security.admin.cli.Strings;
import com.sun.enterprise.security.ssl.SSLUtils;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Iterator;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="enable-secure-admin")
@Scoped(value=PerLookup.class)
@I18n(value="enable.secure.admin.command")
@ExecuteOn(value={RuntimeType.ALL})
public class EnableSecureAdminCommand
extends SecureAdminCommand {
    @Param(optional=true)
    public String adminalias;
    @Param(optional=true)
    public String instancealias;
    @Inject
    private SSLUtils sslUtils;
    private KeyStore keystore = null;

    @Override
    Iterator<SecureAdminCommand.Work<SecureAdminCommand.TopLevelContext>> secureAdminSteps() {
        return this.stepsIterator(this.secureAdminSteps);
    }

    @Override
    Iterator<SecureAdminCommand.Work<SecureAdminCommand.ConfigLevelContext>> perConfigSteps() {
        return this.stepsIterator(this.perConfigSteps);
    }

    private <T extends SecureAdminCommand.Context> Iterator<SecureAdminCommand.Work<T>> stepsIterator(SecureAdminCommand.Step<T>[] steps) {
        return new Iterator<SecureAdminCommand.Work<T>>(){
            private SecureAdminCommand.Step<T>[] steps;
            private int nextSlot;

            @Override
            public boolean hasNext() {
                return this.nextSlot < this.steps.length;
            }

            @Override
            public SecureAdminCommand.Work<T> next() {
                return this.steps[this.nextSlot++].enableWork();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            Iterator<SecureAdminCommand.Work<T>> init(SecureAdminCommand.Step<T>[] values) {
                this.steps = values;
                this.nextSlot = 0;
                return this;
            }
        }.init(steps);
    }

    @Override
    protected boolean updateSecureAdminSettings(SecureAdmin secureAdmin_w) {
        try {
            ArrayList<String> badAliases = new ArrayList<String>();
            if (this.adminalias != null) {
                if (!this.validateAlias(this.adminalias)) {
                    badAliases.add(this.adminalias);
                } else {
                    secureAdmin_w.setDasAlias(this.adminalias);
                }
            }
            if (this.instancealias != null) {
                if (!this.validateAlias(this.instancealias)) {
                    badAliases.add(this.instancealias);
                } else {
                    secureAdmin_w.setInstanceAlias(this.instancealias);
                }
            }
            if (badAliases.size() > 0) {
                throw new SecureAdminCommand.SecureAdminCommandException(this, Strings.get("enable.secure.admin.badAlias", badAliases.size(), ((Object)badAliases).toString()));
            }
            return true;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected String transactionErrorMessageKey() {
        return "enable.secure.admin.errenable";
    }

    private synchronized KeyStore keyStore() throws IOException {
        if (this.keystore == null) {
            this.keystore = this.sslUtils.getKeyStore();
        }
        return this.keystore;
    }

    private boolean validateAlias(String alias) throws IOException, KeyStoreException {
        return this.keyStore().containsAlias(alias);
    }
}

