/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.SecurityConfigListener;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-auth-realm")
@Scoped(value=PerLookup.class)
@I18n(value="delete.auth.realm")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteAuthRealm
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteAuthRealm.class);
    @Param(name="authrealmname", primary=true)
    private String authRealmName;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject(name="default-instance-name")
    private Config config;
    @Inject
    private Configs configs;
    @Inject
    private Domain domain;
    AuthRealm authRealm = null;

    public void execute(AdminCommandContext context) {
        Cluster cluster;
        Server targetServer;
        ActionReport report = context.getActionReport();
        Config tmp = null;
        try {
            tmp = this.configs.getConfigByName(this.target);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tmp != null) {
            this.config = tmp;
        }
        if ((targetServer = this.domain.getServerNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
        }
        if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        }
        SecurityService securityService = this.config.getSecurityService();
        try {
            for (AuthRealm realm : securityService.getAuthRealm()) {
                if (!realm.getName().equals(this.authRealmName)) continue;
                this.authRealm = realm;
            }
            if (this.authRealm == null) {
                report.setMessage(localStrings.getLocalString("delete.auth.realm.notfound", "Authrealm named {0} not found", new Object[]{this.authRealmName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    param.getAuthRealm().remove(DeleteAuthRealm.this.authRealm);
                    SecurityConfigListener.authRealmDeleted(DeleteAuthRealm.this.authRealm);
                    return null;
                }
            }, (ConfigBeanProxy)securityService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.auth.realm.fail", "Deletion of Authrealm {0} failed", new Object[]{this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

