/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.osgicontainer;

import java.io.File;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.extras.osgicontainer.OSGiContainer;
import org.glassfish.extras.osgicontainer.OSGiDeployedBundle;
import org.jvnet.hk2.annotations.Service;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class OSGiDeployer
implements Deployer<OSGiContainer, OSGiDeployedBundle> {
    private static final String BUNDLE_ID = "bundle.id";

    public OSGiDeployedBundle load(OSGiContainer container, DeploymentContext context) {
        return new OSGiDeployedBundle(this.getApplicationBundle(context));
    }

    public void unload(OSGiDeployedBundle appContainer, DeploymentContext context) {
    }

    public void clean(DeploymentContext context) {
        try {
            OpsParams params = context.getCommandParameters(OpsParams.class);
            if (params.origin.isUndeploy()) {
                Bundle bundle = this.getApplicationBundle(context);
                bundle.uninstall();
                this.getPA().refreshPackages(new Bundle[]{bundle});
                System.out.println("Uninstalled " + bundle);
            }
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    private PackageAdmin getPA() {
        BundleContext context = this.getBundleContext();
        return (PackageAdmin)context.getService(context.getServiceReference(PackageAdmin.class.getName()));
    }

    public MetaData getMetaData() {
        return null;
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public boolean prepare(DeploymentContext context) {
        File file = context.getSourceDir();
        try {
            OpsParams params = context.getCommandParameters(OpsParams.class);
            if (params.origin.isDeploy()) {
                assert (file.isDirectory());
                Bundle bundle = this.getBundleContext().installBundle(this.makeBundleLocation(file));
                System.out.println("Installed " + bundle + " from " + bundle.getLocation());
            }
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private BundleContext getBundleContext() {
        return ((BundleReference)BundleReference.class.cast(this.getClass().getClassLoader())).getBundle().getBundleContext();
    }

    private Bundle getApplicationBundle(DeploymentContext context) {
        String location = this.makeBundleLocation(context.getSourceDir());
        for (Bundle b : this.getBundleContext().getBundles()) {
            if (!location.equals(b.getLocation())) continue;
            return b;
        }
        throw new RuntimeException("Unable to determine bundle corresponding to application location " + context.getSourceDir());
    }

    private String makeBundleLocation(File file) {
        return "reference:" + file.toURI();
    }
}

