/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EjbIORConfigurationDescriptor
implements Serializable {
    public static final String NONE = "NONE";
    public static final String SUPPORTED = "SUPPORTED";
    public static final String REQUIRED = "REQUIRED";
    public static final String USERNAME_PASSWORD = "username_password";
    public static final String DEFAULT_REALM = "default";
    private String integrity = "SUPPORTED";
    private String confidentiality = "SUPPORTED";
    private String establishTrustInTarget = "SUPPORTED";
    private String establishTrustInClient = "SUPPORTED";
    private String authenticationMethod = "username_password";
    private String realmName = "default";
    private String callerPropagation = "SUPPORTED";
    private boolean required = false;
    static Logger _logger = DOLUtils.getDefaultLogger();

    public EjbIORConfigurationDescriptor() {
        try {
            if (Boolean.getBoolean("interop.ssl.required")) {
                this.integrity = REQUIRED;
                this.confidentiality = REQUIRED;
                this.establishTrustInClient = REQUIRED;
                this.establishTrustInTarget = SUPPORTED;
            }
            if (Boolean.getBoolean("interop.authRequired.enabled")) {
                this.required = true;
                this.authenticationMethod = USERNAME_PASSWORD;
            }
        }
        catch (Throwable ioe) {
            _logger.log(Level.WARNING, "enterprise.deployment_ioexcp", ioe);
        }
    }

    public EjbIORConfigurationDescriptor(boolean enableUsernamePassword) {
        if (enableUsernamePassword) {
            this.required = true;
            this.authenticationMethod = USERNAME_PASSWORD;
        }
    }

    public String getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(String val) {
        if (!(val.equalsIgnoreCase(NONE) || val.equalsIgnoreCase(SUPPORTED) || val.equalsIgnoreCase(REQUIRED))) {
            throw new RuntimeException("Incorrect value for integrity:" + val);
        }
        this.integrity = val;
    }

    public String getConfidentiality() {
        return this.confidentiality;
    }

    public void setConfidentiality(String val) {
        if (!(val.equalsIgnoreCase(NONE) || val.equalsIgnoreCase(SUPPORTED) || val.equalsIgnoreCase(REQUIRED))) {
            throw new RuntimeException("Incorrect value for confidentiality:" + val);
        }
        this.confidentiality = val;
    }

    public String getEstablishTrustInTarget() {
        return this.establishTrustInTarget;
    }

    public void setEstablishTrustInTarget(String val) {
        if (!val.equalsIgnoreCase(NONE) && !val.equalsIgnoreCase(SUPPORTED)) {
            throw new RuntimeException("Incorrect value for establishTrustInTarget:" + val);
        }
        this.establishTrustInTarget = val;
    }

    public String getEstablishTrustInClient() {
        return this.establishTrustInClient;
    }

    public void setEstablishTrustInClient(String val) {
        if (!(val.equalsIgnoreCase(NONE) || val.equalsIgnoreCase(SUPPORTED) || val.equalsIgnoreCase(REQUIRED))) {
            throw new RuntimeException("Incorrect value for establishTrustInClient:" + val);
        }
        this.establishTrustInClient = val;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String val) {
        if (!val.equalsIgnoreCase(USERNAME_PASSWORD) && !val.equalsIgnoreCase(NONE)) {
            throw new RuntimeException("Incorrect value for authentication method:" + val);
        }
        this.authenticationMethod = val;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String val) {
        this.realmName = val;
    }

    public String getCallerPropagation() {
        return this.callerPropagation;
    }

    public void setCallerPropagation(String val) {
        if (!(val.equalsIgnoreCase(NONE) || val.equalsIgnoreCase(SUPPORTED) || val.equalsIgnoreCase(REQUIRED))) {
            throw new RuntimeException("Incorrect value for callerPropagation:" + val);
        }
        this.callerPropagation = val;
    }

    public boolean isAuthMethodRequired() {
        return this.required;
    }

    public void setAuthMethodRequired(boolean val) {
        this.required = val;
    }

    public void setAuthMethodRequired(String val) {
        this.required = Boolean.valueOf(val);
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("\n integrity ").append(this.integrity);
        toStringBuffer.append("\n confidentiality ").append(this.confidentiality);
        toStringBuffer.append("\n establishTrustInTarget ").append(this.establishTrustInTarget);
        toStringBuffer.append("\n establishTrustInClient ").append(this.establishTrustInClient);
        toStringBuffer.append("\n callerPropagation ").append(this.callerPropagation);
        toStringBuffer.append("\n realm ").append(this.realmName);
        toStringBuffer.append("\n authenticationMethod ").append(this.authenticationMethod).append("\n");
    }
}

