/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-message-security-provider")
@Scoped(value=PerLookup.class)
@I18n(value="delete.message.security.provider")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteMessageSecurityProvider
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteMessageSecurityProvider.class);
    @Param(name="providername", primary=true)
    String providerId;
    @Param(name="layer", defaultValue="SOAP")
    String authLayer;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject(name="default-instance-name")
    private Config config;
    @Inject
    private Configs configs;
    @Inject
    private Domain domain;
    ProviderConfig thePC = null;
    @Inject(name="MessageSecurityConfigListener")
    private ConfigListener msgSecurityConfigListener;
    MessageSecurityConfig msgSecCfg = null;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Config tmp = null;
        try {
            tmp = this.configs.getConfigByName(this.target);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tmp != null) {
            this.config = tmp;
        }
        if (tmp == null) {
            Cluster cluster;
            Server targetServer = this.domain.getServerNamed(this.target);
            if (targetServer != null) {
                this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
            }
            if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
                this.config = this.domain.getConfigNamed(cluster.getConfigRef());
            }
        }
        SecurityService securityService = this.config.getSecurityService();
        List mscs = securityService.getMessageSecurityConfig();
        for (MessageSecurityConfig msc : mscs) {
            if (!msc.getAuthLayer().equals(this.authLayer)) continue;
            this.msgSecCfg = msc;
        }
        if (this.msgSecCfg == null) {
            report.setMessage(localStrings.getLocalString("delete.message.security.provider.confignotfound", "A Message security config does not exist for the layer {0}", new Object[]{this.authLayer}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        List pcs = this.msgSecCfg.getProviderConfig();
        for (ProviderConfig pc : pcs) {
            if (!pc.getProviderId().equals(this.providerId)) continue;
            this.thePC = pc;
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MessageSecurityConfig>(){

                    public Object run(MessageSecurityConfig param) throws PropertyVetoException, TransactionFailure {
                        if (param.getDefaultProvider() != null && param.getDefaultProvider().equals(DeleteMessageSecurityProvider.this.thePC.getProviderId())) {
                            param.setDefaultProvider(null);
                        }
                        if (param.getDefaultClientProvider() != null && param.getDefaultClientProvider().equals(DeleteMessageSecurityProvider.this.thePC.getProviderId())) {
                            param.setDefaultClientProvider(null);
                        }
                        param.getProviderConfig().remove(DeleteMessageSecurityProvider.this.thePC);
                        return null;
                    }
                }, (ConfigBeanProxy)this.msgSecCfg);
            }
            catch (TransactionFailure e) {
                e.printStackTrace();
                report.setMessage(localStrings.getLocalString("delete.message.security.provider.fail", "Deletion of message security provider named {0} failed", new Object[]{this.providerId}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
                return;
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
    }
}

