/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import com.sun.enterprise.deploy.shared.AbstractReadableArchive;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.osgijavaeebase.OSGiBundleArchive;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OSGiJavaEEArchive
extends AbstractReadableArchive
implements ReadableArchive {
    protected Bundle host;
    protected Bundle[] fragments;
    private Map<String, ArchiveEntry> entries = new HashMap<String, ArchiveEntry>();
    protected static final String JAR_EXT = ".jar";
    protected static final String DOT = ".";
    protected final Map<Bundle, OSGiBundleArchive> archives;

    public OSGiJavaEEArchive(Bundle[] fragments, Bundle host) {
        this.fragments = fragments != null ? fragments : new Bundle[]{};
        this.archives = new HashMap<Bundle, OSGiBundleArchive>(this.fragments.length + 1);
        this.host = host;
        this.init();
        final URI hostManifestURI = this.getArchive(host).getEntryURI("META-INF/MANIFEST.MF");
        if (hostManifestURI == null) {
            this.getEntries().remove("META-INF/MANIFEST.MF");
        } else {
            this.getEntries().put("META-INF/MANIFEST.MF", new ArchiveEntry(){

                public String getName() {
                    return "META-INF/MANIFEST.MF";
                }

                public URI getURI() {
                    return hostManifestURI;
                }

                public InputStream getInputStream() throws IOException {
                    return this.getURI().toURL().openStream();
                }
            });
        }
    }

    protected synchronized OSGiBundleArchive getArchive(Bundle b) {
        OSGiBundleArchive archive = this.archives.get(b);
        if (archive == null) {
            archive = new OSGiBundleArchive(b);
            this.archives.put(b, archive);
        }
        return archive;
    }

    protected Map<String, ArchiveEntry> getEntries() {
        return this.entries;
    }

    protected abstract void init();

    protected EffectiveBCP getEffectiveBCP() {
        EffectiveBCPBuilder builder = new EffectiveBCPBuilder();
        builder.createForHost();
        for (Bundle f : this.fragments) {
            builder.createForFragment(f);
        }
        return builder.build();
    }

    public InputStream getEntry(String name) throws IOException {
        ArchiveEntry archiveEntry = this.entries.get(name);
        return archiveEntry != null ? archiveEntry.getInputStream() : null;
    }

    public boolean exists(String name) throws IOException {
        return this.entries.containsKey(name);
    }

    public long getEntrySize(String name) {
        return 0L;
    }

    public void open(URI uri) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        return null;
    }

    public boolean exists() {
        return true;
    }

    public boolean delete() {
        return false;
    }

    public boolean renameTo(String name) {
        return false;
    }

    public void setParentArchive(ReadableArchive parentArchive) {
        throw new UnsupportedOperationException();
    }

    public ReadableArchive getParentArchive() {
        return null;
    }

    public void close() throws IOException {
    }

    public Enumeration<String> entries() {
        final Enumeration<String> all = Collections.enumeration(this.entries.keySet());
        return new Enumeration<String>(){
            String next = this.getNext();

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String result = this.next;
                    this.next = this.getNext();
                    return result;
                }
                throw new NoSuchElementException();
            }

            private String getNext() {
                while (all.hasMoreElements()) {
                    String s = (String)all.nextElement();
                    if (s.endsWith("/")) continue;
                    return s;
                }
                return null;
            }
        };
    }

    public Enumeration<String> entries(final String prefix) {
        final Enumeration<String> all = this.entries();
        return new Enumeration<String>(){
            String next = this.getNext();

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String result = this.next;
                    this.next = this.getNext();
                    return result;
                }
                throw new NoSuchElementException();
            }

            private String getNext() {
                while (all.hasMoreElements()) {
                    String s = (String)all.nextElement();
                    if (!s.startsWith(prefix)) continue;
                    return s;
                }
                return null;
            }
        };
    }

    public Collection<String> getDirectories() throws IOException {
        ArrayList<String> dirEntries = new ArrayList<String>();
        Enumeration<String> all = this.entries();
        while (all.hasMoreElements()) {
            String s = all.nextElement();
            if (!s.endsWith("/")) continue;
            dirEntries.add(s);
        }
        return dirEntries;
    }

    public boolean isDirectory(String name) {
        return name.endsWith("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        InputStream is = this.getEntry("META-INF/MANIFEST.MF");
        if (is != null) {
            try {
                Manifest manifest = new Manifest(is);
                return manifest;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public URI getURI() {
        return null;
    }

    public long getArchiveSize() throws SecurityException {
        return 0L;
    }

    public String getName() {
        return this.getArchive(this.host).getName();
    }

    class EffectiveBCPBuilder {
        private EffectiveBCP result;

        EffectiveBCPBuilder() {
            this.result = new EffectiveBCP();
        }

        public EffectiveBCP build() {
            return this.result;
        }

        void createForHost() {
            ArrayList<Bundle> bundles = new ArrayList<Bundle>(Arrays.asList(OSGiJavaEEArchive.this.fragments));
            bundles.add(0, OSGiJavaEEArchive.this.host);
            for (String s : this.tokenizeBCP(OSGiJavaEEArchive.this.host)) {
                s = s.trim();
                for (Bundle b : bundles) {
                    OSGiBundleArchive archive = OSGiJavaEEArchive.this.getArchive(b);
                    if (OSGiJavaEEArchive.DOT.equals(s)) {
                        this.result.add(this.createJarBCPEntry(OSGiJavaEEArchive.DOT, b));
                        continue;
                    }
                    if (!archive.exists(s)) continue;
                    if (archive.isDirectory(s)) {
                        if (!s.endsWith("/")) {
                            s = s.concat("/");
                        }
                        this.result.add(this.createDirBCPEntry(s, b));
                        continue;
                    }
                    this.result.add(this.createJarBCPEntry(s, b));
                }
            }
        }

        void createForFragment(Bundle bundle) {
            for (String s : this.tokenizeBCP(bundle)) {
                s = s.trim();
                OSGiBundleArchive archive = OSGiJavaEEArchive.this.getArchive(bundle);
                if (OSGiJavaEEArchive.DOT.equals(s)) {
                    this.result.add(this.createJarBCPEntry(OSGiJavaEEArchive.DOT, bundle));
                    continue;
                }
                if (!archive.exists(s)) continue;
                if (archive.isDirectory(s)) {
                    if (!s.endsWith("/")) {
                        s = s.concat("/");
                    }
                    this.result.add(this.createDirBCPEntry(s, bundle));
                    continue;
                }
                this.result.add(this.createJarBCPEntry(s, bundle));
            }
        }

        private JarBCPEntry createJarBCPEntry(String entryPath, Bundle bundle) {
            return new JarBCPEntry(entryPath, bundle);
        }

        private DirBCPEntry createDirBCPEntry(String entryPath, Bundle bundle) {
            return new DirBCPEntry(entryPath, bundle);
        }

        private String[] tokenizeBCP(Bundle b) {
            String bcp = (String)b.getHeaders().get("Bundle-ClassPath");
            if (bcp == null || bcp.isEmpty()) {
                bcp = OSGiJavaEEArchive.DOT;
            }
            return bcp.split(";|,");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EffectiveBCP {
        private List<BCPEntry> bcpEntries = new ArrayList<BCPEntry>();

        protected EffectiveBCP() {
        }

        public List<BCPEntry> getBCPEntries() {
            return this.bcpEntries;
        }

        public void accept(BCPEntry.BCPEntryVisitor visitor) {
            for (BCPEntry bcpEntry : this.getBCPEntries()) {
                bcpEntry.accept(visitor);
            }
        }

        public void add(BCPEntry bcpEntry) {
            this.bcpEntries.add(bcpEntry);
        }
    }

    protected class JarBCPEntry
    implements BCPEntry {
        private String name;
        private Bundle bundle;

        public JarBCPEntry(String name, Bundle bundle) {
            this.name = name;
            this.bundle = bundle;
        }

        public String getName() {
            return this.name;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public void accept(BCPEntry.BCPEntryVisitor visitor) {
            visitor.visitJar(this);
        }
    }

    protected class DirBCPEntry
    implements BCPEntry {
        private String name;
        private Bundle bundle;

        public DirBCPEntry(String name, Bundle bundle) {
            this.name = name;
            this.bundle = bundle;
        }

        public String getName() {
            return this.name;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public void accept(BCPEntry.BCPEntryVisitor visitor) {
            visitor.visitDir(this);
        }
    }

    protected static interface BCPEntry {
        public String getName();

        public Bundle getBundle();

        public void accept(BCPEntryVisitor var1);

        public static interface BCPEntryVisitor {
            public void visitDir(DirBCPEntry var1);

            public void visitJar(JarBCPEntry var1);
        }
    }

    protected static interface ArchiveEntry {
        public String getName();

        public URI getURI() throws URISyntaxException;

        public InputStream getInputStream() throws IOException;
    }
}

