/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployapi;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import org.glassfish.deployapi.DeploymentStatusImpl;
import org.glassfish.deployapi.TargetImpl;
import org.glassfish.deployapi.TargetModuleIDImpl;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;

public class ProgressObjectImpl
extends DFProgressObject {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ProgressObjectImpl.class);
    protected CommandType commandType;
    protected Object[] args;
    private Vector listeners = new Vector();
    protected TargetImpl target;
    protected TargetImpl[] targetsList;
    protected String moduleID;
    protected ModuleType moduleType;
    protected DeploymentStatusImpl deploymentStatus = null;
    protected TargetModuleID[] targetModuleIDs = null;
    protected Vector deliveredEvents = new Vector();
    protected DFDeploymentStatus finalDeploymentStatus = null;
    protected boolean deployActionCompleted;
    protected String warningMessages;
    private static final String MODULE_ID = "moduleid";
    private static final String MODULE_TYPE = "ModuleType";
    private static final String KEY_SEPARATOR = "_";
    private static final String SUBMODULE_COUNT = "NumberOfSubModules";
    private static final String CONTEXT_ROOT = "ContextRoot";
    private static final String WARNING_PREFIX = "WARNING: ";

    public ProgressObjectImpl(TargetImpl target) {
        this.target = target;
        this.deploymentStatus = new DeploymentStatusImpl(this);
        this.deploymentStatus.setState(StateType.RELEASED);
        this.finalDeploymentStatus = new DFDeploymentStatus();
        this.deployActionCompleted = false;
    }

    public ProgressObjectImpl(TargetImpl[] targets) {
        this.targetsList = targets;
        this.target = targets[0];
        this.deploymentStatus = new DeploymentStatusImpl(this);
        this.deploymentStatus.setState(StateType.RELEASED);
        this.finalDeploymentStatus = new DFDeploymentStatus();
        this.deployActionCompleted = false;
    }

    public ProgressObjectImpl(Target[] targets) {
        this(ProgressObjectImpl.toTargetImpl(targets));
    }

    public ProgressObjectImpl(Target target) {
        this(ProgressObjectImpl.toTargetImpl(target));
    }

    public static TargetImpl toTargetImpl(Target target) {
        if (target instanceof TargetImpl) {
            return (TargetImpl)target;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployapi.spi.wrongImpl", "Expected Target implementation class of {0} but found instance of {1} instead", new Object[]{TargetImpl.class.getName(), target.getClass().getName()}));
    }

    public static TargetImpl[] toTargetImpl(Target[] targets) {
        TargetImpl[] result = new TargetImpl[targets.length];
        int i = 0;
        for (Target t : targets) {
            result[i++] = ProgressObjectImpl.toTargetImpl(t);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener pol) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(pol);
            if (this.deliveredEvents.size() > 0) {
                Print.dprintln((String)"Delivering undelivered messages...");
                Iterator i = this.deliveredEvents.iterator();
                while (i.hasNext()) {
                    pol.handleProgressEvent((ProgressEvent)i.next());
                }
            }
        }
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("cancel not supported");
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID id) {
        return null;
    }

    public DeploymentStatus getDeploymentStatus() {
        DeploymentStatusImpl result = new DeploymentStatusImpl(this);
        result.setState(this.deploymentStatus.getState());
        result.setMessage(this.deploymentStatus.getMessage());
        return result;
    }

    public DFDeploymentStatus getCompletedStatus() {
        if (this.deployActionCompleted) {
            return this.finalDeploymentStatus;
        }
        return null;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        if (this.targetModuleIDs == null && this.target != null) {
            this.initializeTargetModuleIDs(this.moduleID);
        }
        return this.targetModuleIDs;
    }

    public void setModuleID(String id) {
        this.moduleID = id;
    }

    protected void initializeTargetModuleIDs(String moduleID) {
        TargetModuleIDImpl parentTargetModuleID = new TargetModuleIDImpl(this.target, moduleID);
        this.targetModuleIDs = new TargetModuleIDImpl[1];
        this.targetModuleIDs[0] = parentTargetModuleID;
    }

    public boolean isCancelSupported() {
        return false;
    }

    public boolean isStopSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ProgressListener pol) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(pol);
        }
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("stop not supported");
    }

    public void setCommand(CommandType commandType, Object[] args) {
        this.commandType = commandType;
        this.args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProgressEvent(ProgressEvent progressEvent) {
        Vector currentListeners = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            currentListeners = (Vector)this.listeners.clone();
            this.deliveredEvents.add(progressEvent);
        }
        Iterator listenersItr = currentListeners.iterator();
        while (listenersItr.hasNext()) {
            ((ProgressListener)listenersItr.next()).handleProgressEvent(progressEvent);
        }
    }

    protected void fireProgressEvent(StateType state, String message) {
        this.fireProgressEvent(state, message, this.target);
    }

    protected void fireProgressEvent(StateType state, String message, TargetImpl aTarget) {
        StateType stateToBroadcast = state != null ? state : this.deploymentStatus.getState();
        DeploymentStatusImpl depStatus = new DeploymentStatusImpl(this);
        depStatus.setState(stateToBroadcast);
        depStatus.setMessage(message);
        if (state != null) {
            this.deploymentStatus.setMessage(message);
            this.deploymentStatus.setState(state);
        }
        TargetModuleIDImpl tmi = new TargetModuleIDImpl(aTarget, this.moduleID);
        this.fireProgressEvent(new ProgressEvent((Object)this, (TargetModuleID)tmi, (DeploymentStatus)depStatus));
    }

    CommandType getCommandType() {
        return this.commandType;
    }

    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    protected String getThrowableString(Throwable t) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        t.printStackTrace(ps);
        ps.close();
        return bos.toString();
    }

    private String getDeploymentStatusMessage(DFDeploymentStatus status) {
        if (status == null) {
            return null;
        }
        if (DFDeploymentStatus.Status.SUCCESS.isWorseThanOrEqual(status.getStatus())) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        DFDeploymentStatus.parseDeploymentStatus(status, pw);
        byte[] statusBytes = bos.toByteArray();
        String statusString = new String(statusBytes);
        if (status.getStatus() == DFDeploymentStatus.Status.WARNING) {
            this.warningMessages = this.warningMessages == null ? WARNING_PREFIX + statusString : this.warningMessages + statusString;
            return null;
        }
        return statusString;
    }

    public void setupForNormalExit(String message, TargetImpl aTarget, TargetModuleIDImpl[] tmids) {
        String i18nmsg;
        if (this.warningMessages == null) {
            i18nmsg = localStrings.getLocalString("enterprise.deployment.client.action_completed", "{0} completed successfully", new Object[]{message});
            this.finalDeploymentStatus.setStageStatus(DFDeploymentStatus.Status.SUCCESS);
        } else {
            i18nmsg = localStrings.getLocalString("enterprise.deployment.client.action_completed_with_warning", "Action completed with warning message: {0}", new Object[]{this.warningMessages});
            this.finalDeploymentStatus.setStageStatus(DFDeploymentStatus.Status.WARNING);
        }
        this.finalDeploymentStatus.setStageStatusMessage(i18nmsg);
        this.deployActionCompleted = true;
        this.targetModuleIDs = tmids;
        this.fireProgressEvent(StateType.COMPLETED, i18nmsg, aTarget);
        for (TargetModuleIDImpl tmid : tmids) {
            this.moduleID = tmid.getModuleID();
            this.fireProgressEvent(StateType.COMPLETED, message, tmid.getTargetImpl());
        }
    }

    public void setupForAbnormalExit(String errorMsg, TargetImpl aTarget) {
        String i18nmsg = localStrings.getLocalString("enterprise.deployment.client.action_failed", "Action failed {0}", new Object[]{errorMsg});
        this.finalDeploymentStatus.setStageStatus(DFDeploymentStatus.Status.FAILURE);
        this.finalDeploymentStatus.setStageStatusMessage(i18nmsg);
        this.deployActionCompleted = true;
        this.fireProgressEvent(StateType.FAILED, i18nmsg, aTarget);
    }

    public boolean checkStatusAndAddStage(TargetImpl aTarget, String action, DFDeploymentStatus currentStatus) {
        String statusMsg = this.getDeploymentStatusMessage(currentStatus);
        this.finalDeploymentStatus.addSubStage(currentStatus);
        if (statusMsg == null) {
            this.fireProgressEvent(StateType.RUNNING, localStrings.getLocalString("enterprise.deployment.client.action_completed", "Action {0} completed", new Object[]{action}), aTarget);
            return true;
        }
        this.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.action_failed_with_message", "Action {0} failed - {1}", new Object[]{action, statusMsg}), aTarget);
        return false;
    }
}

