/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.application;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.EjbRefNode;
import com.sun.enterprise.deployment.node.runtime.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.runtime.MessageDestinationRuntimeNode;
import com.sun.enterprise.deployment.node.runtime.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.runtime.ResourceRefNode;
import com.sun.enterprise.deployment.node.runtime.RuntimeBundleNode;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.node.runtime.ServiceRefNode;
import com.sun.enterprise.deployment.node.runtime.common.SecurityRoleMappingNode;
import com.sun.enterprise.deployment.runtime.common.PrincipalNameDescriptor;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.glassfish.security.common.Group;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationRuntimeNode
extends RuntimeBundleNode<Application> {
    private String currentWebUri = null;

    public ApplicationRuntimeNode(Application descriptor) {
        super(descriptor);
    }

    @Override
    protected void init() {
        super.init();
        this.registerElementHandler(new XMLElement("security-role-mapping"), SecurityRoleMappingNode.class);
        this.registerElementHandler(new XMLElement("resource-ref"), ResourceRefNode.class);
        this.registerElementHandler(new XMLElement("ejb-ref"), EjbRefNode.class);
        this.registerElementHandler(new XMLElement("resource-env-ref"), ResourceEnvRefNode.class);
        this.registerElementHandler(new XMLElement("message-destination-ref"), MessageDestinationRefNode.class);
        this.registerElementHandler(new XMLElement("message-destination"), MessageDestinationRuntimeNode.class);
        this.registerElementHandler(new XMLElement("service-ref"), ServiceRefNode.class);
    }

    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 J2EE Application 1.3//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-application_1_3-0.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 J2EE Application 1.4//EN", "http://www.sun.com/software/appserver/dtds/sun-application_1_4-0.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 J2EE Application 1.4//EN", "http://www.sun.com/software/appserver/dtds/sun-application_1_4-0.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 Java EE Application 5.0//EN", "http://www.sun.com/software/appserver/dtds/sun-application_5_0-0.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Java EE Application 6.0//EN", "http://www.sun.com/software/appserver/dtds/sun-application_6_0-0.dtd");
        if (!ApplicationRuntimeNode.restrictDTDDeclarations()) {
            publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 J2EE Application 1.4//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-application_1_4-0.dtd");
        }
        return "sun-application";
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return new XMLElement("sun-application");
    }

    @Override
    public String getDocType() {
        return "-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Java EE Application 6.0//EN";
    }

    @Override
    public String getSystemID() {
        return "http://www.sun.com/software/appserver/dtds/sun-application_6_0-0.dtd";
    }

    @Override
    public List<String> getSystemIDs() {
        return null;
    }

    @Override
    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("realm", "setRealm");
        return table;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setElementValue(XMLElement element, String value) {
        if (element.getQName().equals("pass-by-reference")) {
            ((Application)this.descriptor).setPassByReference("true".equalsIgnoreCase(value));
            return;
        } else {
            if (element.getQName().equals("unique-id")) {
                DOLUtils.getDefaultLogger().finer("Ignoring unique id");
                return;
            }
            if (element.getQName().equals("archive-name")) {
                ((Application)this.descriptor).setArchiveName(value);
                return;
            } else if (element.getQName().equals("compatibility")) {
                ((Application)this.descriptor).setCompatibility(value);
                return;
            } else if (element.getQName().equals("web-uri")) {
                this.currentWebUri = value;
                return;
            } else if (element.getQName().equals("context-root")) {
                if (this.currentWebUri == null) throw new RuntimeException("No uri provided for this context-root " + value);
                ModuleDescriptor<BundleDescriptor> md = ((Application)this.descriptor).getModuleDescriptorByUri(this.currentWebUri);
                if (md == null) {
                    throw new RuntimeException("No bundle in application with uri " + this.currentWebUri);
                }
                this.currentWebUri = null;
                if (!md.getModuleType().equals(XModuleType.WAR)) throw new RuntimeException(this.currentWebUri + " uri does not point to a web bundle");
                md.setContextRoot(value);
                return;
            } else if (element.getQName().equals("keep-state")) {
                ((Application)this.descriptor).setKeepState(value);
                return;
            } else {
                if (element.getQName().equals("version-identifier")) return;
                super.setElementValue(element, value);
            }
        }
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof SecurityRoleMapping) {
            SecurityRoleMapping roleMap = (SecurityRoleMapping)newDescriptor;
            if (this.descriptor != null && !((Application)this.descriptor).isVirtual()) {
                ((Application)this.descriptor).addSecurityRoleMapping(roleMap);
                Role role = new Role(roleMap.getRoleName());
                SecurityRoleMapper rm = ((Application)this.descriptor).getRoleMapper();
                if (rm != null) {
                    List<PrincipalNameDescriptor> principals = roleMap.getPrincipalNames();
                    for (int i = 0; i < principals.size(); ++i) {
                        rm.assignRole(principals.get(i).getPrincipal(), role, this.descriptor);
                    }
                    List<String> groups = roleMap.getGroupNames();
                    for (int i = 0; i < groups.size(); ++i) {
                        rm.assignRole((Principal)new Group(groups.get(i)), role, this.descriptor);
                    }
                }
            }
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, Application application) {
        Node appNode = super.writeDescriptor(parent, nodeName, application);
        for (ModuleDescriptor<BundleDescriptor> module : application.getModules()) {
            if (!module.getModuleType().equals(XModuleType.WAR)) continue;
            Element web = ApplicationRuntimeNode.appendChild(appNode, "web");
            ApplicationRuntimeNode.appendTextChild((Node)web, "web-uri", module.getArchiveUri());
            ApplicationRuntimeNode.appendTextChild((Node)web, "context-root", module.getContextRoot());
        }
        if (application.isPassByReferenceDefined()) {
            ApplicationRuntimeNode.appendTextChild(appNode, "pass-by-reference", String.valueOf(application.getPassByReference()));
        }
        List<SecurityRoleMapping> roleMappings = application.getSecurityRoleMappings();
        for (int i = 0; i < roleMappings.size(); ++i) {
            SecurityRoleMappingNode srmn = new SecurityRoleMappingNode();
            srmn.writeDescriptor(appNode, "security-role-mapping", roleMappings.get(i));
        }
        ApplicationRuntimeNode.appendTextChild(appNode, "realm", application.getRealm());
        RuntimeDescriptorNode.writeCommonComponentInfo(appNode, application);
        RuntimeDescriptorNode.writeMessageDestinationInfo(appNode, application);
        ApplicationRuntimeNode.appendTextChild(appNode, "archive-name", application.getArchiveName());
        ApplicationRuntimeNode.appendTextChild(appNode, "compatibility", application.getCompatibility());
        ApplicationRuntimeNode.appendTextChild(appNode, "keep-state", String.valueOf(application.getKeepState()));
        return appNode;
    }
}

