/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealmConfig {
    private static Logger logger = LogDomains.getLogger(RealmConfig.class, (String)"javax.enterprise.system.core.security");

    public static void createRealms(String defaultRealm, List<AuthRealm> realms) {
        RealmConfig.createRealms(defaultRealm, realms, null);
    }

    public static void createRealms(String defaultRealm, List<AuthRealm> realms, String configName) {
        assert (realms != null);
        String goodRealm = null;
        for (AuthRealm aRealm : realms) {
            String realmName = aRealm.getName();
            String realmClass = aRealm.getClassname();
            assert (realmName != null);
            assert (realmClass != null);
            try {
                List realmProps = aRealm.getProperty();
                Properties props = new Properties();
                for (Property realmProp : realmProps) {
                    props.setProperty(realmProp.getName(), realmProp.getValue());
                }
                Realm.instantiate(realmName, realmClass, props, configName);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Configured realm: " + realmName);
                }
                if (goodRealm != null) continue;
                goodRealm = realmName;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "realmconfig.disable", realmName);
                logger.log(Level.WARNING, "security.exception", e);
            }
        }
        if (goodRealm == null) {
            logger.severe("realmconfig.nogood");
        } else {
            try {
                Realm def = Realm.getInstance(defaultRealm);
                if (def == null) {
                    defaultRealm = goodRealm;
                }
            }
            catch (Exception e) {
                defaultRealm = goodRealm;
            }
            Realm.setDefaultRealm(defaultRealm);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Default realm is set to: " + defaultRealm);
            }
        }
    }
}

