/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.web.integration.MethodValue;
import com.sun.enterprise.security.web.integration.WebPermissionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

class MapValue {
    int patternType;
    int patternLength;
    boolean irrelevantByQualifier;
    StringBuffer urlPatternSpec;
    HashMap<String, MethodValue> methodValues = new HashMap();

    static String getActions(BitSet methodSet) {
        if (methodSet == null || methodSet.isEmpty()) {
            throw new IllegalArgumentException("internal constraint tranlation error - empty methodSet");
        }
        if (methodSet.get(0)) {
            return null;
        }
        StringBuffer actions = null;
        int i = methodSet.nextSetBit(0);
        while (i >= 0) {
            if (actions == null) {
                actions = new StringBuffer();
            } else {
                actions.append(",");
            }
            actions.append(MethodValue.getMethodName(i));
            i = methodSet.nextSetBit(i + 1);
        }
        return actions == null ? null : actions.toString();
    }

    static String[] getMethodArray(BitSet methodSet) {
        if (methodSet == null || methodSet.isEmpty()) {
            throw new IllegalArgumentException("internal constraint tranlation error - empty methodSet");
        }
        if (methodSet.get(0)) {
            return null;
        }
        int size = 0;
        ArrayList<String> methods = new ArrayList<String>();
        int i = methodSet.nextSetBit(0);
        while (i >= 0) {
            methods.add(MethodValue.getMethodName(i));
            ++size;
            i = methodSet.nextSetBit(i + 1);
        }
        return methods.toArray(new String[size]);
    }

    static BitSet methodArrayToSet(String[] methods, String[] methodOmissions) {
        BitSet methodSet = new BitSet();
        if (methodOmissions == null || methodOmissions.length == 0) {
            if (methods == null || methods.length == 0) {
                methodSet.set(0);
            } else {
                for (int i = 0; i < methods.length; ++i) {
                    int bit = MethodValue.getMethodIndex(methods[i]);
                    methodSet.set(bit);
                }
            }
        } else {
            ArrayList<String> methodOmissionsList = new ArrayList<String>(Arrays.asList(methodOmissions));
            for (String methodOmission : methodOmissionsList) {
                methodSet.clear(MethodValue.getMethodIndex(methodOmission));
            }
            for (String methodName : MethodValue.getMethodNames()) {
                if (methodName == null || methodOmissionsList.contains(methodName)) continue;
                methodSet.set(MethodValue.getMethodIndex(methodName));
            }
        }
        return methodSet;
    }

    MapValue(String urlPattern) {
        this.patternType = WebPermissionUtil.patternType(urlPattern);
        this.patternLength = urlPattern.length();
        this.irrelevantByQualifier = false;
        this.urlPatternSpec = new StringBuffer(urlPattern);
        this.methodValues = new HashMap();
    }

    void addQualifier(String urlPattern) {
        if (WebPermissionUtil.implies(urlPattern, this.urlPatternSpec.substring(0, this.patternLength))) {
            this.irrelevantByQualifier = true;
        }
        this.urlPatternSpec.append(":" + urlPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodValue getMethodValue(int methodIndex) {
        String methodName = MethodValue.getMethodName(methodIndex);
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            MethodValue methodValue = this.methodValues.get(methodName);
            if (methodValue == null) {
                methodValue = new MethodValue(methodName);
                this.methodValues.put(methodName, methodValue);
            }
            return methodValue;
        }
    }

    void setRoleOnMethods(String role, BitSet methodSet, WebBundleDescriptor wbd) {
        if (role.equals("*")) {
            Iterator it = wbd.getRoles().iterator();
            while (it.hasNext()) {
                this.setRoleOnMethods(((Role)it.next()).getName(), methodSet, wbd);
            }
        } else {
            int i = methodSet.nextSetBit(0);
            while (i >= 0) {
                MethodValue methodValue = this.getMethodValue(i);
                if (!methodValue.roleList.contains(role)) {
                    methodValue.roleList.add(role);
                }
                i = methodSet.nextSetBit(i + 1);
            }
        }
    }

    void setPredefinedOutcomeOnMethods(BitSet methodSet, boolean outcome) {
        int i = methodSet.nextSetBit(0);
        while (i >= 0) {
            MethodValue methodValue = this.getMethodValue(i);
            if (!outcome) {
                methodValue.excluded = true;
            } else {
                methodValue.authConstrained = false;
            }
            i = methodSet.nextSetBit(i + 1);
        }
    }

    void setConnectOnMethods(String guarantee, BitSet methodSet) {
        int b = MethodValue.connectTypeNone;
        if (guarantee != null) {
            Integer bit = (Integer)MethodValue.connectHash.get(guarantee);
            if (bit == null) {
                throw new IllegalArgumentException("constraint translation error-illegal trx guarantee");
            }
            b = bit;
        }
        int i = methodSet.nextSetBit(0);
        while (i >= 0) {
            MethodValue methodValue = this.getMethodValue(i);
            methodValue.connectSet |= b;
            i = methodSet.nextSetBit(i + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getExcludedMethods() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (!v.excluded) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getAuthConstrainedMethods() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (!v.excluded && !v.authConstrained && v.roleList.isEmpty()) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    static boolean bitIsSet(int map, int bit) {
        return (map & bit) == bit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getTransportConstrainedMethods() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (!v.excluded && MapValue.bitIsSet(v.connectSet, MethodValue.connectTypeNone)) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap getRoleMap() {
        HashMap<String, BitSet> roleMap = new HashMap<String, BitSet>();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (v.excluded || !v.authConstrained) continue;
                for (String role : v.roleList) {
                    BitSet methodSet = (BitSet)roleMap.get(role);
                    if (methodSet == null) {
                        methodSet = new BitSet();
                        roleMap.put(role, methodSet);
                    }
                    methodSet.set(v.index);
                }
            }
        }
        return roleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getConnectMap(int cType) {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (v.excluded) continue;
                if (v.connectSet == 0) {
                    v.connectSet = MethodValue.connectTypeNone;
                }
                if (!MapValue.bitIsSet(v.connectSet, cType)) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }
}

