/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc.provider;

import com.sun.enterprise.security.jacc.provider.SimplePolicyConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;

public class SharedState {
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private static Lock rLock = rwLock.readLock();
    private static Lock wLock = rwLock.writeLock();
    private static HashMap<String, SimplePolicyConfiguration> configTable = new HashMap();
    private static HashMap<String, HashSet<String>> linkTable = new HashMap();
    private static final Logger logger = Logger.getLogger(SharedState.class.getPackage().getName());

    private SharedState() {
    }

    static Logger getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SimplePolicyConfiguration lookupConfig(String pcid) {
        SimplePolicyConfiguration pc = null;
        wLock.lock();
        try {
            pc = configTable.get(pcid);
        }
        finally {
            wLock.unlock();
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SimplePolicyConfiguration getConfig(String pcid, boolean remove) {
        SimplePolicyConfiguration pc = null;
        wLock.lock();
        try {
            pc = configTable.get(pcid);
            if (pc == null) {
                pc = new SimplePolicyConfiguration(pcid);
                SharedState.initLinks(pcid);
                configTable.put(pcid, pc);
            } else if (remove) {
                SharedState.removeLinks(pcid);
            }
        }
        finally {
            wLock.unlock();
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SimplePolicyConfiguration getActiveConfig() throws PolicyContextException {
        String pcid = PolicyContext.getContextID();
        SimplePolicyConfiguration pc = null;
        if (pcid != null) {
            rLock.lock();
            try {
                pc = configTable.get(pcid);
                if (pc == null) {
                    SimplePolicyConfiguration.logException(Level.WARNING, "invalid policy context id", new PolicyContextException());
                }
            }
            finally {
                rLock.unlock();
            }
            if (pc != null && !pc.inService()) {
                SimplePolicyConfiguration.logException(Level.FINEST, "invalid policy context state", new PolicyContextException());
                pc = null;
            }
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void link(String id, String otherId) throws PolicyContextException {
        wLock.lock();
        try {
            if (otherId.equals(id)) {
                String msg = "Operation attempted to link PolicyConfiguration to itself.";
                throw new IllegalArgumentException(msg);
            }
            HashSet<String> linkSet = linkTable.get(id);
            HashSet<String> otherLinkSet = linkTable.get(otherId);
            if (otherLinkSet == null) {
                String msg = "Linked policy configuration (" + otherId + ") does not exist";
                throw new RuntimeException(msg);
            }
            for (String nextid : otherLinkSet) {
                linkSet.add(nextid);
                linkTable.put(nextid, linkSet);
            }
        }
        finally {
            wLock.unlock();
        }
    }

    static void initLinks(String id) {
        HashSet<String> linkSet = new HashSet<String>();
        linkSet.add(id);
        linkTable.put(id, linkSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeLinks(String id) {
        wLock.lock();
        try {
            HashSet<String> linkSet = linkTable.get(id);
            if (linkSet != null) {
                linkSet.remove(id);
                linkTable.remove(id);
            }
            SharedState.initLinks(id);
        }
        finally {
            wLock.unlock();
        }
    }
}

