/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.probe.provider.PluginPoint;
import org.glassfish.probe.provider.StatsProviderManagerDelegate;
import org.jvnet.hk2.component.PostConstruct;

public class StatsProviderManagerDelegateImpl
implements StatsProviderManagerDelegate,
PostConstruct {
    private MonitoringRuntimeDataRegistry mrdr;
    private Domain domain;
    private TreeNode serverNode;
    private HashMap momMap;
    private static final String MONITORING_ROOT = "v3:pp=/,type=mon";
    private static final String MONITORING_SERVER = "v3:pp=/mon,type=server-mon,name=server";

    StatsProviderManagerDelegateImpl(MonitoringRuntimeDataRegistry mrdr, Domain domain) {
        this.mrdr = mrdr;
        this.domain = domain;
        this.serverNode = this.constructServerPP();
    }

    public void postConstruct() {
    }

    public void register(String configElement, PluginPoint pp, String subTreePath, Object statsProvider) {
        TreeNode ppNode = this.getPluginPointNode(pp, this.serverNode);
        TreeNode parentNode = this.createSubTree(ppNode, subTreePath);
        for (Method m : statsProvider.getClass().getDeclaredMethods()) {
            String methodNameLower;
            ManagedAttribute ma = m.getAnnotation(ManagedAttribute.class);
            if (ma == null) continue;
            String methodName = m.getName();
            String id = ma.id();
            if ((id == null || id.isEmpty()) && (methodNameLower = methodName.toLowerCase()).startsWith("get") && methodNameLower.length() > 3) {
                id = methodNameLower.substring(3);
            }
            TreeNode attrNode = TreeNodeFactory.createMethodInvoker(id, statsProvider, id, m);
            parentNode.addChild(attrNode);
            System.out.println("xxxxxxAttribute ID = " + id);
            System.out.println("xxxxxxMethod Name = " + methodName);
        }
    }

    public void unregister(Object statsProvider) {
        ((ManagedObjectManager)this.momMap.get(statsProvider)).unregister(statsProvider);
    }

    public void unregisterAll() {
    }

    private TreeNode createSubTreeNode(TreeNode parent, String child) {
        TreeNode childNode = parent.getNode(child);
        if (childNode == null) {
            childNode = TreeNodeFactory.createTreeNode(child, null, child);
            parent.addChild(childNode);
        }
        return childNode;
    }

    private TreeNode getPluginPointNode(PluginPoint pp, TreeNode serverNode) {
        if (pp.getName().equals(serverNode.getName())) {
            return serverNode;
        }
        return this.createSubTree(serverNode, pp.getPath());
    }

    private TreeNode createSubTree(TreeNode parent, String subTreePath) {
        StringTokenizer st = new StringTokenizer(subTreePath, "/");
        TreeNode parentNode = parent;
        while (st.hasMoreTokens()) {
            TreeNode subTreeNode;
            parentNode = subTreeNode = this.createSubTreeNode(parentNode, st.nextToken());
        }
        return parentNode;
    }

    private TreeNode constructServerPP() {
        TreeNode serverNode = this.mrdr.get("server");
        if (serverNode != null) {
            return serverNode;
        }
        Server srvr = null;
        List ls = this.domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            srvr = sr;
            break;
        }
        serverNode = TreeNodeFactory.createTreeNode("server", null, "server");
        this.mrdr.add("server", serverNode);
        return serverNode;
    }
}

