/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.generic.FacetAccessor;
import org.glassfish.gmbal.generic.FacetAccessorImpl;
import org.glassfish.gmbal.impl.AMXImpl;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.MBeanSkeleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanImpl
extends NotificationBroadcasterSupport
implements FacetAccessor,
GmbalMBean {
    private boolean registered = false;
    private final MBeanSkeleton skel;
    private final String type;
    private String name;
    private ObjectName oname;
    private MBeanImpl parent;
    private Map<String, Map<String, MBeanImpl>> children;
    private Object target;
    private MBeanServer server;
    private static final MBeanNotificationInfo[] ATTRIBUTE_CHANGE_NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "An Attribute of this MBean has changed")};
    private FacetAccessor facetAccessorDelegate = new FacetAccessorImpl(this);

    public MBeanImpl(MBeanSkeleton skel, Object obj, MBeanServer server, String type) {
        this.skel = skel;
        this.type = type;
        this.name = "";
        this.oname = null;
        this.parent = null;
        this.children = new HashMap<String, Map<String, MBeanImpl>>();
        this.target = obj;
        this.addFacet(obj);
        this.addFacet(new AMXImpl(this));
        this.server = server;
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MBeanImpl)) {
            return false;
        }
        MBeanImpl other = (MBeanImpl)obj;
        return this.parent == other.parent() && this.name.equals(other.name()) && this.type.equals(other.type());
    }

    public synchronized int hashCode() {
        if (this.parent == null) {
            return this.name.hashCode() ^ this.type.hashCode();
        }
        return this.name.hashCode() ^ this.type.hashCode() ^ this.parent.hashCode();
    }

    public String toString() {
        return "MBeanImpl[skel=" + this.skel + ",type=" + this.type + ",name=" + this.name + ",oname=" + this.oname + "]";
    }

    public MBeanSkeleton skeleton() {
        return this.skel;
    }

    public String type() {
        return this.type;
    }

    public Object target() {
        return this.target;
    }

    public synchronized String name() {
        return this.name;
    }

    public synchronized void name(String str) {
        this.name = str;
    }

    public synchronized ObjectName objectName() {
        return this.oname;
    }

    public synchronized void objectName(ObjectName oname) {
        this.oname = oname;
    }

    public synchronized MBeanImpl parent() {
        return this.parent;
    }

    public synchronized void parent(MBeanImpl entity) {
        if (this.parent != null) {
            throw Exceptions.self.nodeAlreadyHasParent(entity);
        }
        this.parent = entity;
    }

    public synchronized Map<String, Map<String, MBeanImpl>> children() {
        HashMap<String, Map<String, MBeanImpl>> result = new HashMap<String, Map<String, MBeanImpl>>();
        for (Map.Entry<String, Map<String, MBeanImpl>> entry : this.children.entrySet()) {
            result.put(entry.getKey(), Collections.unmodifiableMap(new HashMap<String, MBeanImpl>(entry.getValue())));
        }
        return Collections.unmodifiableMap(result);
    }

    public synchronized void addChild(MBeanImpl child) {
        child.parent(this);
        Map<String, MBeanImpl> map = this.children.get(child.type());
        if (map == null) {
            map = new HashMap<String, MBeanImpl>();
            this.children.put(child.type(), map);
        }
        map.put(child.name(), child);
    }

    public synchronized void removeChild(MBeanImpl child) {
        Map<String, MBeanImpl> map = this.children.get(child.type());
        if (map != null) {
            map.remove(child.name());
            if (map.size() == 0) {
                this.children.remove(child.type());
            }
        }
    }

    private void restNameHelper(StringBuilder sb, MBeanImpl mb) {
        if (mb.parent() != null) {
            this.restNameHelper(sb, mb.parent());
            sb.append('/');
        }
        sb.append(mb.type());
        if (!mb.name.equals("")) {
            sb.append('[');
            sb.append(mb.name);
            sb.append(']');
        }
    }

    public synchronized String restName() {
        StringBuilder sb = new StringBuilder(60);
        this.restNameHelper(sb, this);
        return sb.toString();
    }

    public synchronized void register() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (!this.registered) {
            this.server.registerMBean(this, this.oname);
            this.registered = true;
        }
    }

    public synchronized void unregister() throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.registered) {
            this.server.unregisterMBean(this.oname);
            this.registered = false;
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.skel.getAttribute(this, attribute);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.skel.setAttribute(this, this, attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return this.skel.getAttributes(this, attributes);
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return this.skel.setAttributes(this, this, attributes);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return this.skel.invoke(this, actionName, params, signature);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return (MBeanNotificationInfo[])ATTRIBUTE_CHANGE_NOTIFICATION_INFO.clone();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.skel.getMBeanInfo();
    }

    @Override
    public <T> T facet(Class<T> cls, boolean debug) {
        return this.facetAccessorDelegate.facet(cls, debug);
    }

    @Override
    public <T> void addFacet(T obj) {
        this.facetAccessorDelegate.addFacet(obj);
    }

    @Override
    public void removeFacet(Class<?> cls) {
        this.facetAccessorDelegate.removeFacet(cls);
    }

    @Override
    public Object invoke(Method method, boolean debug, Object ... args) {
        return this.facetAccessorDelegate.invoke(method, debug, args);
    }

    @Override
    public Collection<Object> facets() {
        return this.facetAccessorDelegate.facets();
    }

    @Override
    public Object get(Field field, boolean debug) {
        return this.facetAccessorDelegate.get(field, debug);
    }

    @Override
    public void set(Field field, Object value, boolean debug) {
        this.facetAccessorDelegate.set(field, value, debug);
    }
}

