/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.generic.DprintUtil;
import org.glassfish.gmbal.generic.FacetAccessor;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.JMXRegistrationManager;
import org.glassfish.gmbal.impl.MBeanImpl;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;

public class MBeanTree {
    private boolean rootIsSet = false;
    private Object root = null;
    private MBeanImpl rootEntity = null;
    private Map<Object, MBeanImpl> objectMap;
    private Map<ObjectName, Object> objectNameMap;
    private String domain;
    private ObjectName rootParentName;
    private String rootParentPrefix;
    private String typeString;
    private ManagedObjectManagerInternal mom;
    private DprintUtil dputil;
    private JMXRegistrationManager jrm;

    private void addToObjectMaps(MBeanImpl mbean) {
        ObjectName oname = mbean.objectName();
        for (Object obj : mbean.facets()) {
            this.objectMap.put(obj, mbean);
        }
        this.objectNameMap.put(oname, mbean.target());
    }

    private void removeFromObjectMaps(MBeanImpl mbean) {
        ObjectName oname = mbean.objectName();
        for (Object obj : mbean.facets()) {
            this.objectMap.remove(obj);
        }
        this.objectNameMap.remove(oname);
    }

    public synchronized GmbalMBean setRoot(Object root, String rootName) {
        ObjectName oname;
        if (this.rootIsSet) {
            throw Exceptions.self.rootAlreadySet();
        }
        this.rootIsSet = true;
        MBeanImpl rootMB = this.mom.constructMBean(root, rootName);
        try {
            oname = this.objectName(null, rootMB.type(), rootMB.name());
        }
        catch (MalformedObjectNameException ex) {
            throw Exceptions.self.noRootObjectName(ex);
        }
        rootMB.objectName(oname);
        this.addToObjectMaps(rootMB);
        try {
            rootMB.register();
        }
        catch (JMException ex) {
            throw Exceptions.self.rootRegisterFail(ex);
        }
        this.root = root;
        this.rootEntity = rootMB;
        return rootMB;
    }

    public synchronized Object getRoot() {
        return this.root;
    }

    private String parentPath(ObjectName rootParentName) {
        String pp = rootParentName.getKeyProperty("pp");
        String type = rootParentName.getKeyProperty("type");
        String name = rootParentName.getKeyProperty("name");
        if (pp == null) {
            Exceptions.self.ppNullInRootParent();
        }
        if (type == null) {
            Exceptions.self.typeNullInRootParent();
        }
        if (name == null) {
            return pp + '/' + type;
        }
        return pp + '/' + type + '[' + name + ']';
    }

    public MBeanTree(ManagedObjectManagerInternal mom, String domain, ObjectName rootParentName, String typeString) {
        this.mom = mom;
        this.domain = domain;
        this.rootParentName = rootParentName;
        this.rootParentPrefix = rootParentName == null ? null : this.parentPath(rootParentName);
        this.typeString = typeString;
        this.objectMap = new HashMap<Object, MBeanImpl>();
        this.objectNameMap = new HashMap<ObjectName, Object>();
        this.dputil = new DprintUtil(this.getClass());
        this.jrm = new JMXRegistrationManager();
    }

    synchronized void suspendRegistration() {
        this.jrm.suspendRegistration();
    }

    synchronized void resumeRegistration() {
        this.jrm.resumeRegistration();
    }

    public synchronized FacetAccessor getFacetAccessor(Object obj) {
        return this.objectMap.get(obj);
    }

    private void checkCorrectRoot(MBeanImpl entity) {
        MBeanImpl current = entity;
        do {
            if (current != this.rootEntity) continue;
            return;
        } while ((current = current.parent()) != null);
        throw Exceptions.self.notPartOfThisTree(entity);
    }

    private String getQuotedName(String name) {
        StringBuilder buf = new StringBuilder(name.length() + 10);
        buf.append('\"');
        int len = name.length();
        boolean needsQuotes = false;
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '\n': {
                    c = 'n';
                    buf.append('\\');
                    needsQuotes = true;
                    break;
                }
                case '\"': 
                case '*': 
                case '?': 
                case '\\': {
                    buf.append('\\');
                    needsQuotes = true;
                    break;
                }
                case ',': 
                case ':': 
                case '=': {
                    needsQuotes = true;
                }
            }
            buf.append(c);
        }
        if (needsQuotes) {
            buf.append('\"');
            return buf.toString();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectName objectName(MBeanImpl parent, String type, String name) throws MalformedObjectNameException {
        if (this.mom.registrationDebug()) {
            this.dputil.enter("objectName", "parent", parent, "type", type, "name", name);
        }
        ObjectName oname = null;
        try {
            if (parent != null) {
                this.checkCorrectRoot(parent);
            }
            StringBuilder result = new StringBuilder();
            result.append(this.domain);
            result.append(":");
            if (this.mom.registrationDebug()) {
                this.dputil.info("rootParentPrefix=", this.rootParentPrefix);
                if (parent != null) {
                    this.dputil.info("parent.restName()=", parent.restName());
                } else {
                    this.dputil.info("parent is null");
                }
            }
            result.append("pp");
            result.append("=");
            if (this.rootParentPrefix == null && parent == null) {
                result.append('/');
            } else {
                if (this.rootParentPrefix != null) {
                    result.append(this.rootParentPrefix);
                }
                if (parent != null) {
                    result.append(this.getQuotedName('/' + parent.restName()));
                }
            }
            result.append(',');
            result.append(this.typeString);
            result.append("=");
            result.append(this.getQuotedName(type));
            if (name.length() > 0) {
                result.append(',');
                result.append("name");
                result.append("=");
                result.append(this.getQuotedName(name));
            }
            String on = result.toString();
            try {
                oname = new ObjectName(on);
            }
            catch (MalformedObjectNameException exc) {
                throw Exceptions.self.malformedObjectName(exc, on);
            }
            if (this.mom.registrationDebug()) {
                this.dputil.exit(oname);
            }
        }
        catch (Throwable throwable) {
            if (this.mom.registrationDebug()) {
                this.dputil.exit(oname);
            }
            throw throwable;
        }
        return oname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized GmbalMBean register(Object parent, Object obj, MBeanImpl mb) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        if (this.mom.registrationDebug()) {
            this.dputil.enter("register", "parent=", parent, "obj=", obj, "mb=", mb);
        }
        try {
            if (parent == null) {
                throw Exceptions.self.parentCannotBeNull();
            }
            MBeanImpl oldMB = this.objectMap.get(obj);
            if (oldMB != null) {
                String msg = Exceptions.self.objectAlreadyRegistered(obj, oldMB);
                if (this.mom.registrationDebug()) {
                    this.dputil.info(msg);
                }
                throw new IllegalArgumentException(msg);
            }
            MBeanImpl parentEntity = this.objectMap.get(parent);
            if (parentEntity == null) {
                String msg = Exceptions.self.parentNotFound(parent);
                if (this.mom.registrationDebug()) {
                    this.dputil.info(msg);
                }
                throw new IllegalArgumentException(msg);
            }
            ObjectName oname = this.objectName(parentEntity, mb.type(), mb.name());
            mb.objectName(oname);
            this.addToObjectMaps(mb);
            parentEntity.addChild(mb);
            this.jrm.register(mb);
            MBeanImpl mBeanImpl = mb;
            return mBeanImpl;
        }
        finally {
            if (this.mom.registrationDebug()) {
                this.dputil.exit();
            }
        }
    }

    public synchronized void unregister(Object obj) throws InstanceNotFoundException, MBeanRegistrationException {
        MBeanImpl mb;
        if (obj == this.root) {
            this.rootIsSet = false;
            this.root = null;
            this.rootEntity = null;
        }
        if ((mb = this.objectMap.get(obj)) == null) {
            throw Exceptions.self.objectNotFound(obj);
        }
        for (Map<String, MBeanImpl> nameToMBean : mb.children().values()) {
            for (MBeanImpl child : nameToMBean.values()) {
                this.unregister(child.target());
            }
        }
        this.removeFromObjectMaps(mb);
        this.jrm.unregister(mb);
        if (mb.parent() != null) {
            mb.parent().removeChild(mb);
        }
    }

    public synchronized ObjectName getObjectName(Object obj) {
        MBeanImpl result = this.objectMap.get(obj);
        return result.objectName();
    }

    public synchronized Object getObject(ObjectName oname) {
        return this.objectNameMap.get(oname);
    }

    public synchronized MBeanImpl getMBeanImpl(Object obj) {
        return this.objectMap.get(obj);
    }

    public synchronized void clear() {
        if (this.rootIsSet) {
            try {
                this.unregister(this.root);
            }
            catch (InstanceNotFoundException ex) {
                throw Exceptions.self.shouldNotHappen(ex);
            }
            catch (MBeanRegistrationException ex) {
                throw Exceptions.self.shouldNotHappen(ex);
            }
        }
        this.objectMap.clear();
        this.objectNameMap.clear();
        this.rootEntity = null;
    }

    public ObjectName getRootParentName() {
        return this.rootParentName;
    }
}

