/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.annotation.context.RarBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.logging.Level;
import javax.resource.spi.Activation;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.AdministeredObject;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionDefinitions;
import javax.resource.spi.Connector;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ConfigPropertyHandler
extends AbstractHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbstractHandler.class);

    public Class<? extends Annotation> getAnnotationType() {
        return ConfigProperty.class;
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        ConfigProperty configProperty = (ConfigProperty)element.getAnnotation();
        if (aeHandler instanceof RarBundleContext) {
            RarBundleContext rbc = (RarBundleContext)aeHandler;
            ConnectorDescriptor desc = rbc.getDescriptor();
            String defaultValue = configProperty.defaultValue();
            String description = configProperty.description();
            boolean ignore = configProperty.ignore();
            Class<?> type = configProperty.type();
            if (element.getElementType().equals((Object)ElementType.METHOD)) {
                Method m = (Method)element.getAnnotatedElement();
                Class<?>[] parameters = m.getParameterTypes();
                if (parameters != null) {
                    if (parameters.length != 1) {
                        return this.getFailureResult(element, "more than one parameter for JavaBean setter method : [" + m.getName() + " ] ", true);
                    }
                } else {
                    return this.getFailureResult(element, "no parameters for JavaBean setter method : [" + m.getName() + " ] ", true);
                }
                Class<?> propertyType = parameters[0];
                if (type.equals(Object.class)) {
                    type = propertyType;
                } else if (!propertyType.isAssignableFrom(type)) {
                    return this.getFailureResult(element, "annotation type [" + type + "] and property-type" + " [" + propertyType + "] " + "are not assignment compatible", true);
                }
                EnvironmentProperty ep = new EnvironmentProperty();
                if (!description.equals("")) {
                    ep.setDescription(description);
                }
                if (!defaultValue.equals("")) {
                    ep.setValue(defaultValue);
                }
                ep.setType(type.getName());
                ep.setName(m.getName().substring(3));
                Class<?> c = m.getDeclaringClass();
                this.handleConfigPropertyAnnotation(element, desc, ep, c);
            } else if (element.getElementType().equals((Object)ElementType.FIELD)) {
                Field f = (Field)element.getAnnotatedElement();
                Class<?> c = f.getDeclaringClass();
                Class<?> returnType = f.getType();
                if (type.equals(Object.class)) {
                    type = returnType;
                } else if (!returnType.isAssignableFrom(type)) {
                    return this.getFailureResult(element, "annotation type [" + type + "] and return-type [" + returnType + "] " + "are not assignment compatible", true);
                }
                EnvironmentProperty ep = new EnvironmentProperty();
                if (!description.equals("")) {
                    ep.setDescription(description);
                }
                if (!defaultValue.equals("")) {
                    ep.setValue(defaultValue);
                }
                ep.setType(type.getName());
                ep.setName(f.getName());
                this.handleConfigPropertyAnnotation(element, desc, ep, c);
            }
        } else {
            return this.getFailureResult(element, "not a rar bundle context", true);
        }
        return this.getDefaultProcessedResult();
    }

    private void handleConfigPropertyAnnotation(AnnotationInfo element, ConnectorDescriptor desc, EnvironmentProperty ep, Class c) {
        if (ResourceAdapter.class.isAssignableFrom(c) || c.getAnnotation(Connector.class) != null) {
            this.processConnector(desc, ep);
        } else if (ManagedConnectionFactory.class.isAssignableFrom(c) || c.getAnnotation(ConnectionDefinition.class) != null) {
            this.processConnectionDefinition(element, desc, ep, c);
        } else if (ActivationSpec.class.isAssignableFrom(c) || c.getAnnotation(Activation.class) != null) {
            this.processActivation(element, desc, ep, c);
        } else if (c.getAnnotation(AdministeredObject.class) != null) {
            this.handleConfigPropertyForAdministeredObject(element, desc, ep, c);
        }
    }

    private void handleConfigPropertyForAdministeredObject(AnnotationInfo element, ConnectorDescriptor desc, EnvironmentProperty ep, Class c) {
        if (c.getAnnotation(AdministeredObject.class) != null) {
            Class[] adminObjectInterfaces;
            AdministeredObject ao = c.getAnnotation(AdministeredObject.class);
            for (Class adminObjectInterface : adminObjectInterfaces = ao.adminObjectInterfaces()) {
                AdminObject adminObject = desc.getAdminObject(adminObjectInterface.getName(), c.getName());
                if (adminObject != null) {
                    if (this.isConfigDefined(adminObject.getConfigProperties(), ep)) continue;
                    adminObject.addConfigProperty(ep);
                    continue;
                }
                this.getFailureResult(element, "could not get adminobject of interface [ " + adminObjectInterface.getName() + " ]" + " and class [ " + c.getName() + " ]", true);
            }
        }
    }

    private void processActivation(AnnotationInfo element, ConnectorDescriptor desc, EnvironmentProperty ep, Class c) {
        if (desc.getInBoundDefined()) {
            InboundResourceAdapter ira = desc.getInboundResourceAdapter();
            if (c.getAnnotation(Activation.class) != null) {
                Class[] messageListeners;
                Activation activation = c.getAnnotation(Activation.class);
                for (Class clz : messageListeners = activation.messageListeners()) {
                    MessageListener ml;
                    if (!ira.hasMessageListenerType(clz.getName()) || this.isConfigDefined((ml = ira.getMessageListener(clz.getName())).getConfigProperties(), ep)) continue;
                    ml.addConfigProperty(ep);
                }
            } else {
                this.debug("configProperty annotation is not annotated with Activation, but implements ActivationSpec");
            }
        } else {
            this.getFailureResult(element, "No Inbound RA yet defined ", true);
        }
    }

    private void processConnectionDefinition(AnnotationInfo element, ConnectorDescriptor desc, EnvironmentProperty ep, Class c) {
        if (desc.getOutBoundDefined()) {
            OutboundResourceAdapter ora = desc.getOutboundResourceAdapter();
            Set connectionDefinitions = ora.getConnectionDefs();
            boolean foundConnectionDefinition = false;
            for (Object o : connectionDefinitions) {
                ConnectionDefDescriptor cd = (ConnectionDefDescriptor)o;
                if (!cd.getManagedConnectionFactoryImpl().equals(c.getName())) continue;
                if (!this.isConfigDefined(cd.getConfigProperties(), ep)) {
                    cd.addConfigProperty(ep);
                }
                foundConnectionDefinition = true;
            }
            if (!foundConnectionDefinition) {
                this.getFailureResult(element, "could not find connection definition for MCF class " + c.getName(), true);
            }
        } else {
            this.getFailureResult(element, "Outbound RA is not yet defined", true);
        }
    }

    private void processConnector(ConnectorDescriptor desc, EnvironmentProperty ep) {
        if (!this.isConfigDefined(desc.getConfigProperties(), ep)) {
            desc.addConfigProperty(ep);
        }
    }

    private boolean isConfigDefined(Set configProperties, EnvironmentProperty ep) {
        boolean result = false;
        for (Object o : configProperties) {
            EnvironmentProperty ddEnvProperty = (EnvironmentProperty)o;
            if (!ddEnvProperty.getName().equals(ep.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    protected HandlerProcessingResult getDefaultProcessedResult() {
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{Connector.class, ConnectionDefinition.class, ConnectionDefinitions.class, Activation.class, AdministeredObject.class};
    }

    private void debug(String s) {
        this.logger.log(Level.INFO, "[ConfigPropertyHandler] " + s);
    }

    private HandlerProcessingResultImpl getFailureResult(AnnotationInfo element, String message, boolean doLog) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        result.addResult(this.getAnnotationType(), ResultType.FAILED);
        if (doLog) {
            AnnotatedElement o = element.getAnnotatedElement();
            String className = null;
            className = o instanceof Field ? ((Field)o).getDeclaringClass().getName() : ((Method)o).getDeclaringClass().getName();
            this.logger.log(Level.WARNING, "failed to handle annotation [ " + element.getAnnotation() + " ]" + " on class [ " + className + " ], reason : " + message);
        }
        return result;
    }
}

