/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.annotation.context.RarBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import javax.resource.spi.Connector;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SecurityPermissionHandler
extends AbstractHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbstractHandler.class);

    public Class<? extends Annotation> getAnnotationType() {
        return javax.resource.spi.SecurityPermission.class;
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        javax.resource.spi.SecurityPermission securityPermission = (javax.resource.spi.SecurityPermission)element.getAnnotation();
        if (aeHandler instanceof RarBundleContext) {
            boolean isConnectionDefinition = this.hasConnectorAnnotation(element);
            if (isConnectionDefinition) {
                RarBundleContext rarContext = (RarBundleContext)aeHandler;
                ConnectorDescriptor desc = rarContext.getDescriptor();
                SecurityPermission permission = new SecurityPermission(securityPermission.description(), securityPermission.permissionSpec());
                desc.addSecurityPermission(permission);
            } else {
                this.getFailureResult(element, "Not a @Connector annotation : @SecurityPermission must be specified along with @Connector annotation", true);
            }
        } else {
            this.getFailureResult(element, "Not a rar bundle context", true);
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getConnectorAnnotationTypes();
    }

    @Override
    protected HandlerProcessingResult getDefaultProcessedResult() {
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    private boolean hasConnectorAnnotation(AnnotationInfo element) {
        Class c = (Class)element.getAnnotatedElement();
        return c.getAnnotation(Connector.class) != null;
    }

    private HandlerProcessingResultImpl getFailureResult(AnnotationInfo element, String message, boolean doLog) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        result.addResult(this.getAnnotationType(), ResultType.FAILED);
        if (doLog) {
            Class c = (Class)element.getAnnotatedElement();
            String className = c.getName();
            this.logger.log(Level.WARNING, "failed to handle annotation [ " + element.getAnnotation() + " ]" + " on class [ " + className + " ], reason : " + message);
        }
        return result;
    }
}

