/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.provider;

import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.security.provider.BasePolicyWrapper;
import com.sun.enterprise.security.provider.PolicyConfigurationFactoryImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.glassfish.internal.api.Globals;
import sun.net.www.ParseUtil;
import sun.security.provider.PolicyFile;
import sun.security.provider.PolicyParser;

public class PolicyConfigurationImpl
implements PolicyConfiguration {
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PolicyConfigurationImpl.class);
    String CONTEXT_ID = null;
    private Permissions excludedPermissions = null;
    private Permissions uncheckedPermissions = null;
    private HashMap rolePermissionsTable = null;
    private SecurityRoleMapperFactory factory = (SecurityRoleMapperFactory)Globals.get(SecurityRoleMapperFactory.class);
    private static String policySuffix = ".policy";
    private static String PROVIDER_URL = "policy.url.";
    private static final Class[] permissionParams = new Class[]{String.class, String.class};
    public static final int OPEN_STATE = 0;
    public static final int INSERVICE_STATE = 2;
    public static final int DELETED_STATE = 3;
    protected int state = 0;
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private Lock rLock = this.rwLock.readLock();
    private Lock wLock = this.rwLock.writeLock();
    private boolean writeOnCommit = true;
    private boolean wasRefreshed = false;
    private Policy policy = null;
    private String policyUrlValue = null;
    private long[] lastModTimes = new long[2];
    private Object refreshLock = new Object();
    private String repository = null;
    private Permission setPolicyPermission = null;
    private PolicyConfigurationFactoryImpl fact = null;

    protected PolicyConfigurationImpl(String contextId, PolicyConfigurationFactoryImpl fact) {
        this.CONTEXT_ID = contextId;
        this.fact = fact;
        this.repository = fact.getRepository();
        this.initialize(true, true, false);
    }

    protected PolicyConfigurationImpl(File applicationPolicyDirectory, boolean open, boolean remove, PolicyConfigurationFactoryImpl fact) {
        this.fact = fact;
        this.CONTEXT_ID = applicationPolicyDirectory.getParentFile().getName() + '/' + applicationPolicyDirectory.getName();
        this.repository = fact.getRepository();
        String name = this.getPolicyFileName(true);
        File f = new File(name);
        if (!f.exists()) {
            String defMsg = "Unable to open Policy file: " + name;
            String msg = localStrings.getLocalString("pc.file_not_found", defMsg, new Object[]{name});
            logger.log(Level.SEVERE, msg);
            throw new RuntimeException(defMsg);
        }
        this.initialize(open, remove, true);
    }

    public String getContextID() throws PolicyContextException {
        this.checkSetPolicyPermission();
        return this.CONTEXT_ID;
    }

    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        this.assertStateIsOpen();
        assert (roleName != null);
        assert (permissions != null);
        if (roleName != null && permissions != null) {
            this.checkSetPolicyPermission();
            Enumeration<Permission> e = permissions.elements();
            while (e.hasMoreElements()) {
                this.getRolePermissions(roleName).add(e.nextElement());
                this.writeOnCommit = true;
            }
        }
    }

    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        this.assertStateIsOpen();
        assert (permission != null);
        assert (roleName != null);
        if (roleName != null && permission != null) {
            this.checkSetPolicyPermission();
            this.getRolePermissions(roleName).add(permission);
            this.writeOnCommit = true;
        }
    }

    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        this.assertStateIsOpen();
        assert (permissions != null);
        if (permissions != null) {
            this.checkSetPolicyPermission();
            Enumeration<Permission> e = permissions.elements();
            while (e.hasMoreElements()) {
                this.getUncheckedPermissions().add(e.nextElement());
                this.writeOnCommit = true;
            }
        }
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        this.assertStateIsOpen();
        assert (permission != null);
        if (permission != null) {
            this.checkSetPolicyPermission();
            this.getUncheckedPermissions().add(permission);
            this.writeOnCommit = true;
        }
    }

    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        this.assertStateIsOpen();
        assert (permissions != null);
        if (permissions != null) {
            this.checkSetPolicyPermission();
            Enumeration<Permission> e = permissions.elements();
            while (e.hasMoreElements()) {
                this.getExcludedPermissions().add(e.nextElement());
                this.writeOnCommit = true;
            }
        }
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        this.assertStateIsOpen();
        assert (permission != null);
        if (permission != null) {
            this.checkSetPolicyPermission();
            this.getExcludedPermissions().add(permission);
            this.writeOnCommit = true;
        }
    }

    public void removeRole(String roleName) throws PolicyContextException {
        this.assertStateIsOpen();
        assert (roleName != null);
        if (roleName != null && this.rolePermissionsTable != null) {
            this.checkSetPolicyPermission();
            if (this.rolePermissionsTable.remove(roleName) != null) {
                this.writeOnCommit = true;
            }
        }
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        this.assertStateIsOpen();
        this.checkSetPolicyPermission();
        if (this.uncheckedPermissions != null) {
            this.uncheckedPermissions = null;
            this.writeOnCommit = true;
        }
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        this.assertStateIsOpen();
        this.checkSetPolicyPermission();
        if (this.excludedPermissions != null) {
            this.excludedPermissions = null;
            this.writeOnCommit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws PolicyContextException {
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.stateIs(3)) {
                String defMsg = "Cannot perform Operation on a deleted PolicyConfiguration";
                String msg = localStrings.getLocalString("pc.invalid_op_for_state_delete", defMsg);
                logger.log(Level.WARNING, msg);
                throw new UnsupportedOperationException(defMsg);
            }
            try {
                this.checkSetPolicyPermission();
                if (this.stateIs(0)) {
                    this.generatePermissions();
                    this.setState(2);
                }
            }
            catch (Exception e) {
                String defMsg = "commit fail for contextod " + this.CONTEXT_ID;
                String msg = localStrings.getLocalString("pc.commit_failure", defMsg, new Object[]{this.CONTEXT_ID, e});
                logger.log(Level.SEVERE, msg);
                throw new PolicyContextException((Throwable)e);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC Policy Provider: PC.commit " + this.CONTEXT_ID);
            }
        }
    }

    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        this.assertStateIsOpen();
        String linkId = link.getContextID();
        if (this.CONTEXT_ID == linkId) {
            String defMsg = "Operation attempted to link PolicyConfiguration to itself.";
            String msg = localStrings.getLocalString("pc.unsupported_link_operation", defMsg);
            logger.log(Level.WARNING, msg);
            throw new IllegalArgumentException(defMsg);
        }
        this.checkSetPolicyPermission();
        this.updateLinkTable(linkId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws PolicyContextException {
        this.checkSetPolicyPermission();
        Object object = this.refreshLock;
        synchronized (object) {
            try {
                this.removePolicy();
            }
            finally {
                this.setState(3);
            }
        }
    }

    public boolean inService() throws PolicyContextException {
        this.checkSetPolicyPermission();
        boolean rvalue = this.stateIs(2);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC Policy Provider: inService: " + (rvalue ? "true " : "false ") + this.CONTEXT_ID);
        }
        return rvalue;
    }

    protected void checkSetPolicyPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.setPolicyPermission == null) {
                this.setPolicyPermission = new SecurityPermission("setPolicy");
            }
            sm.checkPermission(this.setPolicyPermission);
        }
    }

    protected Policy getPolicy() {
        if (this.stateIs(2)) {
            return this.policy;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JACC Policy Provider: getPolicy (" + this.CONTEXT_ID + ") is NOT in service");
        }
        return null;
    }

    protected Permissions getExcludedPolicy() {
        return this.stateIs(2) ? this.excludedPermissions : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(boolean force) {
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.stateIs(2) && (!this.wasRefreshed || force || this.filesChanged())) {
                int i = 0;
                String value = null;
                String urlKey = null;
                while ((value = Security.getProperty(urlKey = PROVIDER_URL + ++i)) != null && !value.equals("")) {
                }
                try {
                    Security.setProperty(urlKey, this.policyUrlValue);
                    if (this.fileChanged(false)) {
                        this.excludedPermissions = this.loadExcludedPolicy();
                    }
                    this.captureFileTime(true);
                    if (this.policy == null) {
                        this.policy = this.getNewPolicy();
                    } else {
                        this.policy.refresh();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("JACC Policy Provider: Called Policy.refresh on contextId: " + this.CONTEXT_ID + " policyUrlValue was " + this.policyUrlValue);
                        }
                    }
                    this.wasRefreshed = true;
                }
                finally {
                    Security.setProperty(urlKey, "");
                }
            }
        }
    }

    private Policy getNewPolicy() {
        Policy wrapper = Policy.getPolicy();
        if (wrapper != null && wrapper instanceof BasePolicyWrapper) {
            return ((BasePolicyWrapper)wrapper).getNewPolicy();
        }
        return new PolicyFile();
    }

    private void captureFileTime(boolean granted) {
        String name = this.getPolicyFileName(granted);
        File f = new File(name);
        this.lastModTimes[granted ? 1 : 0] = f.lastModified();
    }

    private boolean _fileChanged(boolean granted, File f) {
        return this.lastModTimes[granted ? 1 : 0] != f.lastModified();
    }

    private boolean fileChanged(boolean granted) {
        String name = this.getPolicyFileName(granted);
        File f = new File(name);
        return this._fileChanged(granted, f);
    }

    private boolean filesChanged() {
        return this.fileChanged(true) || this.fileChanged(false);
    }

    private boolean fileArrived(boolean granted) {
        boolean rvalue;
        String name = this.getPolicyFileName(granted);
        File f = new File(name);
        boolean bl = rvalue = f.exists() && this._fileChanged(granted, f);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC Policy Provider: file arrival check type: " + (granted ? "granted " : "excluded ") + " arrived: " + rvalue + " exists: " + f.exists() + " lastModified: " + f.lastModified() + " storedTime: " + this.lastModTimes[granted ? 1 : 0] + " state: " + (this.state == 0 ? "open " : "deleted ") + this.CONTEXT_ID);
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(boolean open, boolean remove, boolean fromFile) {
        Object object = this.refreshLock;
        synchronized (object) {
            String name = this.getPolicyFileName(true);
            if (open || remove) {
                this.setState(0);
            } else {
                this.setState(2);
            }
            try {
                if (remove) {
                    this.removePolicy();
                }
                this.policyUrlValue = ParseUtil.fileToEncodedURL(new File(name)).toString();
                if (fromFile && !remove) {
                    this.uncheckedPermissions = null;
                    this.rolePermissionsTable = null;
                    this.excludedPermissions = this.loadExcludedPolicy();
                    this.initLinkTable();
                    this.captureFileTime(true);
                    this.writeOnCommit = false;
                }
                this.wasRefreshed = false;
            }
            catch (MalformedURLException mue) {
                String defMsg = "Unable to convert Policy file Name to URL: " + name;
                String msg = localStrings.getLocalString("pc.file_to_url", defMsg, new Object[]{name, mue});
                logger.log(Level.SEVERE, msg);
                throw new RuntimeException(defMsg);
            }
        }
    }

    private String getPolicyFileName(boolean granted) {
        return granted ? this.getContextDirectoryName() + File.separator + "granted" + policySuffix : this.getContextDirectoryName() + File.separator + "excluded" + policySuffix;
    }

    private String getContextDirectoryName() {
        if (this.repository == null) {
            throw new RuntimeException("JACC Policy provider: repository not initialized");
        }
        return this.fact.getContextDirectoryName(this.CONTEXT_ID);
    }

    private void removePolicyContextDirectory() {
        String directoryName = this.getContextDirectoryName();
        File f = new File(directoryName);
        if (f.exists()) {
            File[] moduleDirs;
            File appDir;
            File[] fs;
            File[] files = f.listFiles();
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
            }
            if (!f.delete()) {
                String defMsg = "Failure removing policy context directory: " + directoryName;
                String msg = localStrings.getLocalString("pc.file_delete_error", defMsg);
                logger.log(Level.SEVERE, msg);
                throw new RuntimeException(defMsg);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC Policy Provider: Policy context directory removed: " + directoryName);
            }
            if ((fs = (appDir = f.getParentFile()).listFiles()) != null && fs.length > 0) {
                int i;
                boolean hasDir = false;
                for (i = 0; i < fs.length; ++i) {
                    if (!fs[i].isDirectory()) continue;
                    hasDir = true;
                    break;
                }
                if (!hasDir) {
                    for (i = 0; i < fs.length; ++i) {
                        fs[i].delete();
                    }
                }
            }
            if (!((moduleDirs = appDir.listFiles()) != null && moduleDirs.length != 0 || appDir.delete())) {
                String defMsg = "Failure removing policy context directory: " + appDir;
                String msg = localStrings.getLocalString("pc.file_delete_error", defMsg);
                logger.log(Level.SEVERE, msg);
                throw new RuntimeException(defMsg);
            }
        }
    }

    private void removePolicyFile(boolean granted) {
        String fileName = this.getPolicyFileName(granted);
        File f = new File(fileName);
        if (f.exists()) {
            if (!f.delete()) {
                String defMsg = "Failure removing policy file: " + fileName;
                String msg = localStrings.getLocalString("pc.file_delete_error", defMsg, new Object[]{fileName});
                logger.log(Level.SEVERE, msg);
                throw new RuntimeException(defMsg);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC Policy Provider: Policy file removed: " + fileName);
            }
        }
    }

    private void removePolicy() {
        this.excludedPermissions = null;
        this.uncheckedPermissions = null;
        this.rolePermissionsTable = null;
        this.removePolicyFile(true);
        this.removePolicyFile(false);
        this.removePolicyContextDirectory();
        this.initLinkTable();
        this.policy = null;
        this.writeOnCommit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLinkTable() {
        Object object = this.refreshLock;
        synchronized (object) {
            HashSet<String> linkSet = (HashSet<String>)this.fact.getLinkTable().get(this.CONTEXT_ID);
            if (linkSet != null) {
                linkSet.remove(this.CONTEXT_ID);
                this.fact.getLinkTable().remove(this.CONTEXT_ID);
            }
            linkSet = new HashSet<String>();
            linkSet.add(this.CONTEXT_ID);
            this.fact.getLinkTable().put(this.CONTEXT_ID, linkSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkTable(String otherId) {
        Object object = this.refreshLock;
        synchronized (object) {
            Set linkSet = (Set)this.fact.getLinkTable().get(this.CONTEXT_ID);
            Set otherLinkSet = (Set)this.fact.getLinkTable().get(otherId);
            if (otherLinkSet == null) {
                String defMsg = "Linked policy configuration (" + otherId + ") does not exist";
                String msg = localStrings.getLocalString("pc.invalid_link_target", defMsg, new Object[]{otherId});
                logger.log(Level.SEVERE, "pc.invalid_link_target", otherId);
                throw new RuntimeException(defMsg);
            }
            for (String id : otherLinkSet) {
                linkSet.add(id);
                this.fact.getLinkTable().put(id, linkSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int stateValue) {
        this.wLock.lock();
        try {
            this.state = stateValue;
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _stateIs(int stateValue) {
        this.rLock.lock();
        try {
            boolean bl = this.state == stateValue;
            return bl;
        }
        finally {
            this.rLock.unlock();
        }
    }

    private boolean stateIs(int stateValue) {
        boolean inState = this._stateIs(stateValue);
        if (stateValue == 2 && !inState) {
            if (this.fileArrived(true) || this.fileArrived(false)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("JACC Policy Provider: file arrived transition to inService:  state: " + (this.state == 0 ? "open " : "deleted ") + this.CONTEXT_ID);
                }
                this.initialize(false, false, true);
            }
            inState = this._stateIs(2);
        }
        return inState;
    }

    private void assertStateIsOpen() {
        if (!this.stateIs(0)) {
            String defMsg = "Operation invoked on closed or deleted PolicyConfiguration.";
            String msg = localStrings.getLocalString("pc.op_requires_state_open", defMsg);
            logger.log(Level.WARNING, msg);
            throw new UnsupportedOperationException(defMsg);
        }
    }

    private Permissions getUncheckedPermissions() {
        if (this.uncheckedPermissions == null) {
            this.uncheckedPermissions = new Permissions();
        }
        return this.uncheckedPermissions;
    }

    private Permissions getExcludedPermissions() {
        if (this.excludedPermissions == null) {
            this.excludedPermissions = new Permissions();
        }
        return this.excludedPermissions;
    }

    private Permissions getRolePermissions(String roleName) {
        Permissions rolePermissions;
        if (this.rolePermissionsTable == null) {
            this.rolePermissionsTable = new HashMap();
        }
        if ((rolePermissions = (Permissions)this.rolePermissionsTable.get(roleName)) == null) {
            rolePermissions = new Permissions();
            this.rolePermissionsTable.put(roleName, rolePermissions);
        }
        return rolePermissions;
    }

    private String escapeName(String name) {
        return name != null && name.indexOf(34) > 0 ? name.replaceAll("\"", "\\\\\"") : name;
    }

    private void generatePermissions() throws FileNotFoundException, IOException {
        Enumeration<Permission> pEnum;
        if (!this.writeOnCommit) {
            return;
        }
        Map roleToSubjectMap = null;
        if (this.rolePermissionsTable != null && this.factory != null) {
            Set linkSet;
            SecurityRoleMapper srm = this.factory.getRoleMapper(this.CONTEXT_ID);
            if (srm != null) {
                roleToSubjectMap = srm.getRoleToSubjectMapping();
            }
            if (roleToSubjectMap != null && (linkSet = (Set)this.fact.getLinkTable().get(this.CONTEXT_ID)) != null) {
                for (String contextId : linkSet) {
                    if (this.CONTEXT_ID.equals(contextId)) continue;
                    SecurityRoleMapper otherSrm = this.factory.getRoleMapper(contextId);
                    Map otherRoleToSubjectMap = null;
                    if (otherSrm != null) {
                        otherRoleToSubjectMap = otherSrm.getRoleToSubjectMapping();
                    }
                    if (otherRoleToSubjectMap == roleToSubjectMap) continue;
                    String defMsg = "Linked policy contexts have different roleToSubjectMaps (" + this.CONTEXT_ID + ")<->(" + contextId + ")";
                    String msg = localStrings.getLocalString("pc.linked_with_different_role_maps", defMsg, new Object[]{this.CONTEXT_ID, contextId});
                    logger.log(Level.SEVERE, msg);
                    throw new RuntimeException(defMsg);
                }
            }
        }
        if (roleToSubjectMap == null && this.rolePermissionsTable != null) {
            String defMsg = "This application has no role mapper factory defined";
            String msg = localStrings.getLocalString("pc.role_map_not_defined_at_commit", defMsg, new Object[]{this.CONTEXT_ID});
            logger.log(Level.SEVERE, msg);
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.deployment.norolemapperfactorydefine", defMsg));
        }
        PolicyParser parser = new PolicyParser(false);
        if (this.uncheckedPermissions != null && (pEnum = this.uncheckedPermissions.elements()).hasMoreElements()) {
            PolicyParser.GrantEntry grant = new PolicyParser.GrantEntry();
            while (pEnum.hasMoreElements()) {
                Permission p = pEnum.nextElement();
                PolicyParser.PermissionEntry entry = new PolicyParser.PermissionEntry(p.getClass().getName(), p.getName(), p.getActions());
                grant.add(entry);
            }
            parser.add(grant);
        }
        if (this.rolePermissionsTable != null) {
            Iterator roleIt = this.rolePermissionsTable.keySet().iterator();
            while (roleIt.hasNext()) {
                boolean withPrincipals = false;
                String roleName = (String)roleIt.next();
                Permissions rolePerms = this.getRolePermissions(roleName);
                Subject rolePrincipals = (Subject)roleToSubjectMap.get(roleName);
                if (rolePrincipals != null) {
                    for (Principal prin : rolePrincipals.getPrincipals()) {
                        assert (prin instanceof Principal);
                        if (prin instanceof Principal) {
                            withPrincipals = true;
                            PolicyParser.PrincipalEntry prinEntry = new PolicyParser.PrincipalEntry(prin.getClass().getName(), this.escapeName(prin.getName()));
                            PolicyParser.GrantEntry grant = new PolicyParser.GrantEntry();
                            grant.principals.add(prinEntry);
                            Enumeration<Permission> pEnum2 = rolePerms.elements();
                            while (pEnum2.hasMoreElements()) {
                                Permission perm = pEnum2.nextElement();
                                PolicyParser.PermissionEntry permEntry = new PolicyParser.PermissionEntry(perm.getClass().getName(), perm.getName(), perm.getActions());
                                grant.add(permEntry);
                            }
                            parser.add(grant);
                            continue;
                        }
                        String msg = localStrings.getLocalString("pc.non_principal_mapped_to_role", "non principal mapped to role " + roleName, new Object[]{prin, roleName});
                        logger.log(Level.WARNING, msg);
                    }
                }
                if (withPrincipals) continue;
                String msg = localStrings.getLocalString("pc.no_principals_mapped_to_role", "no principals mapped to role " + roleName, new Object[]{roleName});
                logger.log(Level.WARNING, msg);
            }
        }
        this.writeOnCommit = this.createPolicyFile(true, parser, this.writeOnCommit);
        if (this.excludedPermissions != null) {
            PolicyParser excludedParser = new PolicyParser(false);
            Enumeration<Permission> pEnum3 = this.excludedPermissions.elements();
            if (pEnum3.hasMoreElements()) {
                PolicyParser.GrantEntry grant = new PolicyParser.GrantEntry();
                while (pEnum3.hasMoreElements()) {
                    Permission p = pEnum3.nextElement();
                    PolicyParser.PermissionEntry entry = new PolicyParser.PermissionEntry(p.getClass().getName(), p.getName(), p.getActions());
                    grant.add(entry);
                }
                excludedParser.add(grant);
            }
            this.writeOnCommit = this.createPolicyFile(false, excludedParser, this.writeOnCommit);
        }
        if (!this.writeOnCommit) {
            this.wasRefreshed = false;
        }
    }

    private void createPolicyContextDirectory() {
        String contextDirectoryName = this.getContextDirectoryName();
        File d = new File(contextDirectoryName);
        if (d.exists()) {
            if (!d.isDirectory()) {
                String defMsg = "unable to create policy context directory";
                String msg = localStrings.getLocalString("pc.unable_to_create_context_directory", defMsg, new Object[]{contextDirectoryName});
                logger.log(Level.SEVERE, msg);
                throw new RuntimeException(defMsg);
            }
        } else {
            d.mkdirs();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createPolicyFile(boolean granted, PolicyParser parser, boolean woc) throws IOException {
        boolean result = woc;
        this.createPolicyContextDirectory();
        this.removePolicyFile(granted);
        String name = this.getPolicyFileName(granted);
        OutputStreamWriter writer = null;
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC Policy Provider: Writing grant statements to policy file: " + name);
            }
            writer = new FileWriter(name);
            parser.write(writer);
            result = false;
            if (writer == null) return result;
        }
        catch (FileNotFoundException fnfe) {
            try {
                String msg = localStrings.getLocalString("pc.file_error", "file not found " + name, new Object[]{name, fnfe});
                logger.log(Level.SEVERE, msg);
                throw fnfe;
                catch (IOException ioe) {
                    msg = localStrings.getLocalString("pc.file_write_error", "file IO error on file " + name, new Object[]{name, ioe});
                    logger.log(Level.SEVERE, msg);
                    throw ioe;
                }
            }
            catch (Throwable throwable) {
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    this.captureFileTime(granted);
                    throw throwable;
                }
                catch (Exception e) {
                    String defMsg = "Unable to close Policy file: " + name;
                    String msg = localStrings.getLocalString("pc.file_close_error", defMsg, new Object[]{name, e});
                    logger.log(Level.SEVERE, msg);
                    throw new RuntimeException(defMsg);
                }
            }
        }
        try {
            writer.close();
            this.captureFileTime(granted);
            return result;
        }
        catch (Exception e) {
            String defMsg = "Unable to close Policy file: " + name;
            String msg = localStrings.getLocalString("pc.file_close_error", defMsg, new Object[]{name, e});
            logger.log(Level.SEVERE, msg);
            throw new RuntimeException(defMsg);
        }
    }

    private Permission loadPermission(String className, String name, String actions) {
        Class<?> clazz = null;
        Permission permission = null;
        try {
            clazz = Class.forName(className);
            Constructor<?> c = clazz.getConstructor(permissionParams);
            permission = (Permission)c.newInstance(name, actions);
        }
        catch (Exception e) {
            String defMsg = "PolicyConfiguration error loading permission";
            String msg = localStrings.getLocalString("pc.permission_load_error", defMsg, new Object[]{className, e});
            logger.log(Level.SEVERE, msg);
            throw new RuntimeException(defMsg, e);
        }
        return permission;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Permissions loadExcludedPolicy() {
        block18: {
            result = null;
            name = this.getPolicyFileName(false);
            reader = null;
            parser = new PolicyParser(false);
            try {
                this.captureFileTime(false);
                reader = new FileReader(name);
                parser.read(reader);
                ** if (reader == null) goto lbl-1000
            }
            catch (FileNotFoundException fnf) {
                parser = null;
                if (reader == null) break block18;
                {
                    catch (Throwable var8_21) {
                        if (reader == null) throw var8_21;
                        try {
                            reader.close();
                            throw var8_21;
                        }
                        catch (Exception e) {
                            defMsg = "Unable to close Policy file: " + name;
                            msg = PolicyConfigurationImpl.localStrings.getLocalString("pc.file_close_error", defMsg, new Object[]{name, e});
                            PolicyConfigurationImpl.logger.log(Level.SEVERE, msg);
                            throw new RuntimeException(defMsg);
                        }
                    }
                }
                try {
                    reader.close();
                }
                catch (Exception e) {
                    defMsg = "Unable to close Policy file: " + name;
                    msg = PolicyConfigurationImpl.localStrings.getLocalString("pc.file_close_error", defMsg, new Object[]{name, e});
                    PolicyConfigurationImpl.logger.log(Level.SEVERE, msg);
                    throw new RuntimeException(defMsg);
                }
                catch (IOException ioe) {
                    defMsg = "Error reading Policy file: " + name;
                    msg = PolicyConfigurationImpl.localStrings.getLocalString("pc.file_read_error", defMsg, new Object[]{name, ioe});
                    PolicyConfigurationImpl.logger.log(Level.SEVERE, msg);
                    throw new RuntimeException(defMsg);
                    catch (PolicyParser.ParsingException pe) {
                        defMsg = "Unable to parse Policy file: " + name;
                        msg = PolicyConfigurationImpl.localStrings.getLocalString("pc.policy_parsing_exception", defMsg, new Object[]{name, pe});
                        PolicyConfigurationImpl.logger.log(Level.SEVERE, msg);
                        throw new RuntimeException(defMsg);
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    defMsg = "Unable to close Policy file: " + name;
                    msg = PolicyConfigurationImpl.localStrings.getLocalString("pc.file_close_error", defMsg, new Object[]{name, e});
                    PolicyConfigurationImpl.logger.log(Level.SEVERE, msg);
                    throw new RuntimeException(defMsg);
                }
            }
lbl-1000:
            // 1 sources

            {
            }
        }
        if (parser == null) return result;
        grants = parser.grantElements();
        block13: while (true) {
            if (grants.hasMoreElements() == false) return result;
            grant = grants.nextElement();
            if (grant.codeBase != null || grant.signedBy != null || grant.principals.size() != 0) {
                msg = PolicyConfigurationImpl.localStrings.getLocalString("pc.excluded_grant_context_ignored", "ignore excluded grant context", new Object[]{grant});
                PolicyConfigurationImpl.logger.log(Level.WARNING, msg);
                continue;
            }
            perms = grant.permissionEntries.elements();
            while (true) {
                if (perms.hasMoreElements()) ** break;
                continue block13;
                entry = perms.nextElement();
                p = this.loadPermission(entry.permission, entry.name, entry.action);
                if (result == null) {
                    result = new Permissions();
                }
                result.add(p);
            }
            break;
        }
    }
}

