/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.BindingsIterator;
import com.sun.enterprise.naming.impl.JavaURLContext;
import com.sun.enterprise.naming.impl.NamePairsEnum;
import com.sun.enterprise.naming.impl.ProviderManager;
import com.sun.enterprise.naming.impl.SerialContext;
import com.sun.enterprise.naming.impl.SerialNameParser;
import com.sun.enterprise.naming.util.LogFacade;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.JNDIBinding;
import org.glassfish.api.naming.NamingObjectProxy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public final class GlassfishNamingManagerImpl
implements GlassfishNamingManager {
    static Logger _logger = LogFacade.getLogger();
    public static final String IIOPOBJECT_FACTORY = "com.sun.enterprise.naming.util.IIOPObjectFactory";
    @Inject
    InvocationManager invMgr;
    private InitialContext initialContext;
    private Context cosContext;
    private NameParser nameParser = new SerialNameParser();
    private Map componentNamespaces;
    private Map<String, Map> appNamespaces;
    private Map<AppModuleKey, Map> moduleNamespaces;
    private Map<String, ComponentIdInfo> componentIdInfo;

    public GlassfishNamingManagerImpl() throws NamingException {
        this(new InitialContext());
    }

    void setInvocationManager(InvocationManager invMgr) {
        this.invMgr = invMgr;
    }

    public GlassfishNamingManagerImpl(InitialContext ic) throws NamingException {
        this.initialContext = ic;
        this.componentNamespaces = new Hashtable();
        this.appNamespaces = new HashMap<String, Map>();
        this.moduleNamespaces = new HashMap<AppModuleKey, Map>();
        this.componentIdInfo = new HashMap<String, ComponentIdInfo>();
        JavaURLContext.setNamingManager(this);
    }

    public Context getInitialContext() {
        return this.initialContext;
    }

    public NameParser getNameParser() {
        return this.nameParser;
    }

    public Remote initializeRemoteNamingSupport(ORB orb) throws NamingException {
        Remote remoteProvider = null;
        try {
            Hashtable<String, String> cosNamingEnv = new Hashtable<String, String>();
            cosNamingEnv.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
            cosNamingEnv.put("java.naming.corba.orb", (String)orb);
            this.cosContext = new InitialContext(cosNamingEnv);
            ProviderManager pm = ProviderManager.getProviderManager();
            remoteProvider = pm.initRemoteProvider(orb);
        }
        catch (RemoteException re) {
            NamingException ne = new NamingException("Exception during remote naming initialization");
            ne.initCause(ne);
            throw ne;
        }
        return remoteProvider;
    }

    private Context getCosContext() {
        return this.cosContext;
    }

    public void publishObject(String name, java.lang.Object obj, boolean rebind) throws NamingException {
        CompositeName nameobj = new CompositeName(name);
        this.publishObject(nameobj, obj, rebind);
    }

    public void publishObject(Name name, java.lang.Object obj, boolean rebind) throws NamingException {
        java.lang.Object serialObj = obj;
        if (rebind) {
            this.initialContext.rebind(name, serialObj);
        } else {
            this.initialContext.bind(name, serialObj);
        }
    }

    public void publishCosNamingObject(String name, java.lang.Object obj, boolean rebind) throws NamingException {
        CompositeName nameObj = new CompositeName(name);
        this.createSubContexts(nameObj, this.getCosContext());
        if (rebind) {
            this.getCosContext().rebind(name, obj);
        } else {
            this.getCosContext().bind(name, obj);
        }
        Reference serialObj = new Reference("reference", new StringRefAddr("url", name.toString()), IIOPOBJECT_FACTORY, null);
        this.publishObject(name, (java.lang.Object)serialObj, rebind);
    }

    public void unpublishObject(String name) throws NamingException {
        this.initialContext.unbind(name);
    }

    public void unpublishCosNamingObject(String name) throws NamingException {
        try {
            this.getCosContext().unbind(name);
        }
        catch (NamingException cne) {
            _logger.log(Level.WARNING, "Error during CosNaming.unbind for " + name);
        }
        this.initialContext.unbind(name);
    }

    public void unpublishObject(Name name) throws NamingException {
        this.unpublishObject(name.toString());
    }

    private void createSubContexts(Name name, Context rootCtx) throws NamingException {
        int numSubContexts = name.size() - 1;
        Context currentCtx = rootCtx;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating sub contexts for " + name);
        }
        for (int subCtxIndex = 0; subCtxIndex < numSubContexts; ++subCtxIndex) {
            Context newCtx;
            String subCtxName = name.get(subCtxIndex);
            try {
                java.lang.Object obj = currentCtx.lookup(subCtxName);
                if (obj == null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "name == null");
                    }
                    currentCtx = newCtx = currentCtx.createSubcontext(subCtxName);
                    continue;
                }
                if (obj instanceof Context) {
                    currentCtx = (Context)obj;
                    continue;
                }
                throw new NameAlreadyBoundException(subCtxName);
            }
            catch (NameNotFoundException e) {
                _logger.log(Level.FINE, "name not found", e);
                currentCtx = newCtx = currentCtx.createSubcontext(subCtxName);
            }
        }
    }

    private Map getComponentNamespace(String componentId) throws NamingException {
        HashMap<String, JavaURLContext> namespace = (HashMap<String, JavaURLContext>)this.componentNamespaces.get(componentId);
        if (namespace == null) {
            namespace = new HashMap<String, JavaURLContext>();
            this.componentNamespaces.put(componentId, namespace);
            JavaURLContext jc = new JavaURLContext("java:", null);
            namespace.put("java:", jc);
            namespace.put("java:/", jc);
            JavaURLContext jcc = new JavaURLContext("java:comp", null);
            namespace.put("java:comp", jcc);
            namespace.put("java:comp/", jcc);
            JavaURLContext jccEnv = new JavaURLContext("java:comp/env", null);
            namespace.put("java:comp/env", jccEnv);
            namespace.put("java:comp/env/", jccEnv);
        }
        return namespace;
    }

    private Map getModuleNamespace(AppModuleKey appModuleKey) throws NamingException {
        if (appModuleKey.getAppName() == null || appModuleKey.getModuleName() == null) {
            throw new NamingException("Invalid appModuleKey " + appModuleKey);
        }
        Hashtable<String, JavaURLContext> namespace = this.moduleNamespaces.get(appModuleKey);
        if (namespace == null) {
            namespace = new Hashtable<String, JavaURLContext>();
            this.moduleNamespaces.put(appModuleKey, namespace);
            JavaURLContext jc = new JavaURLContext("java:", null);
            namespace.put("java:", jc);
            namespace.put("java:/", jc);
            JavaURLContext jMod = new JavaURLContext("java:module", null);
            namespace.put("java:module", jMod);
            namespace.put("java:module/", jMod);
            JavaURLContext jModEnv = new JavaURLContext("java:module/env", null);
            namespace.put("java:module/env", jModEnv);
            namespace.put("java:module/env/", jModEnv);
        }
        return namespace;
    }

    private Map getAppNamespace(String appName) throws NamingException {
        if (appName == null) {
            throw new NamingException("Null appName");
        }
        Hashtable<String, JavaURLContext> namespace = this.appNamespaces.get(appName);
        if (namespace == null) {
            namespace = new Hashtable<String, JavaURLContext>();
            this.appNamespaces.put(appName, namespace);
            JavaURLContext jc = new JavaURLContext("java:", null);
            namespace.put("java:", jc);
            namespace.put("java:/", jc);
            JavaURLContext jApp = new JavaURLContext("java:app", null);
            namespace.put("java:app", jApp);
            namespace.put("java:app/", jApp);
            JavaURLContext jAppEnv = new JavaURLContext("java:app/env", null);
            namespace.put("java:app/env", jAppEnv);
            namespace.put("java:app/env/", jAppEnv);
        }
        return namespace;
    }

    private Map getNamespace(String componentId, String logicalJndiName) throws NamingException {
        ComponentIdInfo info = this.componentIdInfo.get(componentId);
        return info != null ? this.getNamespace(info.appName, info.moduleName, componentId, logicalJndiName) : this.getComponentNamespace(componentId);
    }

    private Map getNamespace(String appName, String moduleName, String componentId, String logicalJndiName) throws NamingException {
        Map namespace = null;
        namespace = logicalJndiName.startsWith("java:comp") ? this.getComponentNamespace(componentId) : (logicalJndiName.startsWith("java:module") ? this.getModuleNamespace(new AppModuleKey(appName, moduleName)) : (logicalJndiName.startsWith("java:app") ? this.getAppNamespace(appName) : this.getComponentNamespace(componentId)));
        return namespace;
    }

    private void bindToNamespace(Map namespace, String logicalJndiName, java.lang.Object value) throws NamingException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "naming.bind Binding name:{0}", new java.lang.Object[]{logicalJndiName});
        }
        if (namespace.put(logicalJndiName, value) != null) {
            _logger.log(Level.WARNING, "naming.alreadyexistsReference name [{0}] already exists for {1}", new java.lang.Object[]{logicalJndiName, namespace.toString()});
        }
        this.bindIntermediateContexts(namespace, logicalJndiName);
    }

    public void bindToComponentNamespace(String appName, String moduleName, String componentId, Collection<? extends JNDIBinding> bindings) throws NamingException {
        if (appName != null && moduleName != null) {
            ComponentIdInfo info = new ComponentIdInfo();
            info.appName = appName;
            info.moduleName = moduleName;
            info.componentId = componentId;
            this.componentIdInfo.put(componentId, info);
        }
        for (JNDIBinding jNDIBinding : bindings) {
            String logicalJndiName = jNDIBinding.getName();
            Map namespace = null;
            if (logicalJndiName.startsWith("java:comp")) {
                namespace = this.getComponentNamespace(componentId);
            } else if (logicalJndiName.startsWith("java:module")) {
                namespace = this.getModuleNamespace(new AppModuleKey(appName, moduleName));
            } else if (logicalJndiName.startsWith("java:app")) {
                namespace = this.getAppNamespace(appName);
            }
            if (namespace == null) continue;
            this.bindToNamespace(namespace, jNDIBinding.getName(), jNDIBinding.getValue());
        }
    }

    public void bindToModuleNamespace(String appName, String moduleName, Collection<? extends JNDIBinding> bindings) throws NamingException {
        for (JNDIBinding jNDIBinding : bindings) {
            Map namespace;
            String logicalJndiName = jNDIBinding.getName();
            if (logicalJndiName.startsWith("java:module")) {
                namespace = this.getModuleNamespace(new AppModuleKey(appName, moduleName));
                this.bindToNamespace(namespace, jNDIBinding.getName(), jNDIBinding.getValue());
                continue;
            }
            if (!logicalJndiName.startsWith("java:app")) continue;
            namespace = this.getAppNamespace(appName);
            this.bindToNamespace(namespace, jNDIBinding.getName(), jNDIBinding.getValue());
        }
    }

    public void bindToAppNamespace(String appName, Collection<? extends JNDIBinding> bindings) throws NamingException {
        for (JNDIBinding jNDIBinding : bindings) {
            String logicalJndiName = jNDIBinding.getName();
            if (!logicalJndiName.startsWith("java:app")) continue;
            Map namespace = this.getAppNamespace(appName);
            this.bindToNamespace(namespace, jNDIBinding.getName(), jNDIBinding.getValue());
        }
    }

    private void bindIntermediateContexts(Map namespace, String name) throws NamingException {
        String partialName = null;
        if (name.startsWith("java:comp/")) {
            partialName = "java:comp";
        } else if (name.startsWith("java:module/")) {
            partialName = "java:module";
        } else if (name.startsWith("java:app/")) {
            partialName = "java:app";
        } else {
            throw new NamingException("Invalid environment namespace name : " + name);
        }
        name = name.substring((partialName + "/").length());
        StringTokenizer toks = new StringTokenizer(name, "/", false);
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            if (namespace.get(partialName = partialName + "/" + tok) != null) continue;
            namespace.put(partialName, new JavaURLContext(partialName, null));
        }
    }

    public void unbindComponentObjects(String componentId) throws NamingException {
        this.componentNamespaces.remove(componentId);
        this.componentIdInfo.remove(componentId);
    }

    public void unbindAppObjects(String appName) throws NamingException {
        this.appNamespaces.remove(appName);
        Iterator<Map.Entry<AppModuleKey, Map>> moduleEntries = this.moduleNamespaces.entrySet().iterator();
        while (moduleEntries.hasNext()) {
            Map.Entry<AppModuleKey, Map> entry = moduleEntries.next();
            if (!entry.getKey().getAppName().equals(appName)) continue;
            moduleEntries.remove();
        }
    }

    public Context restoreJavaCompEnvContext(String contextName) throws NamingException {
        if (!contextName.startsWith("java:")) {
            throw new NamingException("Invalid context name [" + contextName + "]. Name must start with java:");
        }
        return new JavaURLContext(contextName, null);
    }

    public java.lang.Object lookup(String name) throws NamingException {
        return this.lookup(name, (SerialContext)null);
    }

    public java.lang.Object lookup(String name, SerialContext serialContext) throws NamingException {
        _logger.fine("serialcontext in GlassfishNamingManager.." + serialContext);
        Context ic = null;
        ic = serialContext != null ? serialContext : this.initialContext;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "GlassfishNamingManager : looking up name : " + name);
        }
        String componentId = this.getComponentId();
        return this.lookup(componentId, name, ic);
    }

    public java.lang.Object lookup(String componentId, String name) throws NamingException {
        return this.lookup(componentId, name, this.initialContext);
    }

    private java.lang.Object lookup(String componentId, String name, Context ctx) throws NamingException {
        Map namespace = this.getNamespace(componentId, name);
        java.lang.Object obj = namespace.get(name);
        if (obj == null) {
            throw new NameNotFoundException("No object bound to name " + name);
        }
        if (obj instanceof NamingObjectProxy) {
            NamingObjectProxy namingProxy = (NamingObjectProxy)obj;
            obj = namingProxy.create(ctx);
        }
        return obj;
    }

    public NamingEnumeration list(String name) throws NamingException {
        ArrayList list = this.listNames(name);
        return new NamePairsEnum(this, list.iterator());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        ArrayList list = this.listNames(name);
        return new BindingsIterator(this, list.iterator());
    }

    private ArrayList listNames(String name) throws NamingException {
        String componentId = this.getComponentId();
        Map namespace = this.getNamespace(componentId, name);
        java.lang.Object obj = namespace.get(name);
        if (obj == null) {
            throw new NameNotFoundException("No object bound to name " + name);
        }
        if (!(obj instanceof JavaURLContext)) {
            throw new NotContextException(name + " cannot be listed");
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator itr = namespace.keySet().iterator();
        if (!name.endsWith("/")) {
            name = name + "/";
        }
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.startsWith(name) || key.indexOf(47, name.length()) != -1) continue;
            list.add(key);
        }
        return list;
    }

    private String getComponentId() throws NamingException {
        String id = null;
        ComponentInvocation ci = this.invMgr.getCurrentInvocation();
        if (ci == null) {
            throw new NamingException("Invocation exception: Got null ComponentInvocation ");
        }
        try {
            id = ci.getComponentId();
            if (id == null) {
                NamingException nameEx = new NamingException("Invocation exception: ComponentId is null");
                throw nameEx;
            }
        }
        catch (Throwable th) {
            NamingException ine = new NamingException("Invocation exception: " + th);
            ine.initCause(th);
            throw ine;
        }
        return id;
    }

    private boolean isCOSNamingObj(java.lang.Object obj) {
        return obj instanceof Remote || obj instanceof Object;
    }

    private static class ComponentIdInfo {
        String appName;
        String moduleName;
        String componentId;

        private ComponentIdInfo() {
        }

        public String toString() {
            return "appName = " + this.appName + " , module = " + this.moduleName + " , componentId = " + this.componentId;
        }
    }

    private static class AppModuleKey {
        private String app;
        private String module;

        public AppModuleKey(String appName, String moduleName) {
            this.app = appName;
            this.module = moduleName;
        }

        public boolean equals(java.lang.Object o) {
            boolean equal = false;
            if (o != null && o instanceof AppModuleKey) {
                AppModuleKey other = (AppModuleKey)o;
                if (this.app.equals(other.app) && this.module.equals(other.module)) {
                    equal = true;
                }
            }
            return equal;
        }

        public int hashCode() {
            return this.app.hashCode();
        }

        public String getAppName() {
            return this.app;
        }

        public String getModuleName() {
            return this.module;
        }

        public String toString() {
            return "appName = " + this.app + " , module = " + this.module;
        }
    }
}

