/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.types.MessageDestinationReferenceContainer;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.types.ResourceEnvReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceReferenceContainer;
import com.sun.enterprise.deployment.types.RoleMappingContainer;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.deployment.util.AppClientVisitor;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import com.sun.enterprise.deployment.util.ConnectorVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DescriptorVisitor;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.WebBundleVisitor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import org.glassfish.resource.common.Resource;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
extends BundleDescriptor
implements Roles,
RoleMappingContainer,
WritableJndiNameEnvironment,
EjbReferenceContainer,
ResourceEnvReferenceContainer,
ResourceReferenceContainer,
ServiceReferenceContainer,
MessageDestinationReferenceContainer {
    private static final String LIBRARY_DIRECTORY_DEFAULT_VALUE = "lib";
    private static final String PERSISTENCE_UNIT_NAME_SEPARATOR = "#";
    private String generatedXMLDir;
    private Set<ModuleDescriptor<BundleDescriptor>> modules = new OrderedSet<ModuleDescriptor<BundleDescriptor>>();
    private boolean uniqueIdSet = false;
    private long uniqueId;
    private boolean virtual = false;
    private Boolean passByReference = null;
    private HashMap cmpDescriptors = null;
    private String cmpDescriptorsLock = new String("cmp descriptors lock");
    private boolean isDirty;
    private SecurityRoleMapper roleMapper;
    private String registrationName;
    private String appName;
    private String archiveName;
    private boolean initializeInOrder = false;
    private String realm;
    private Map<String, EntityManagerFactory> entityManagerFactories = new HashMap<String, EntityManagerFactory>();
    private Set<String> entityManagerFactoryUnitNames = new HashSet<String>();
    private Set<EnvironmentProperty> environmentProperties = new HashSet<EnvironmentProperty>();
    private Set<EjbReference> ejbReferences = new HashSet<EjbReference>();
    private Set<JmsDestinationReferenceDescriptor> jmsDestReferences = new HashSet<JmsDestinationReferenceDescriptor>();
    private Set<MessageDestinationReferenceDescriptor> messageDestReferences = new HashSet<MessageDestinationReferenceDescriptor>();
    private Set<ResourceReferenceDescriptor> resourceReferences = new HashSet<ResourceReferenceDescriptor>();
    private Set<ServiceReferenceDescriptor> serviceReferences = new HashSet<ServiceReferenceDescriptor>();
    private Set<EntityManagerFactoryReferenceDescriptor> entityManagerFactoryReferences = new HashSet<EntityManagerFactoryReferenceDescriptor>();
    private Set<EntityManagerReferenceDescriptor> entityManagerReferences = new HashSet<EntityManagerReferenceDescriptor>();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Application.class);
    private Set<Role> appRoles;
    private String libraryDirectory;
    private List<SecurityRoleMapping> roleMaps = new ArrayList<SecurityRoleMapping>();
    private boolean loadedFromApplicationXml = true;
    private List<Resource> resourceList = null;
    private boolean isPackagedAsSingleModule = false;
    private final Habitat habitat;
    private Set<DataSourceDefinitionDescriptor> datasourceDefinitionDescs = new HashSet<DataSourceDefinitionDescriptor>();
    static Logger _logger = DOLUtils.getDefaultLogger();

    public Application(Habitat habitat) {
        super("", localStrings.getLocalString("enterprise.deployment.application.description", "Application description"));
        this.habitat = habitat;
    }

    @Override
    public String getDefaultSpecVersion() {
        return "6";
    }

    @Override
    public boolean isEmpty() {
        return this.modules.isEmpty();
    }

    public static Application createApplication(Habitat habitat, String name, ModuleDescriptor<BundleDescriptor> newModule) {
        Application application = new Application(habitat);
        application.setVirtual(true);
        if (name == null && newModule.getDescriptor() != null) {
            name = newModule.getDescriptor().getDisplayName();
        }
        if (name != null) {
            application.setDisplayName(name);
            application.setName(name);
        }
        newModule.setStandalone(true);
        newModule.setArchiveUri(name);
        if (newModule.getDescriptor() != null) {
            newModule.getDescriptor().setApplication(application);
        }
        application.addModule(newModule);
        return application;
    }

    @Override
    public Set<EjbReference> getEjbReferenceDescriptors() {
        return this.ejbReferences;
    }

    @Override
    public void addEjbReferenceDescriptor(EjbReference ejbReference) {
        this.ejbReferences.add(ejbReference);
        ejbReference.setReferringBundleDescriptor(this);
    }

    @Override
    public void removeEjbReferenceDescriptor(EjbReference ejbReference) {
        this.ejbReferences.remove(ejbReference);
    }

    public EjbReference getEjbReferenceByName(String name) {
        return (EjbReferenceDescriptor)this.getEjbReference(name);
    }

    @Override
    public EjbReference getEjbReference(String name) {
        for (EjbReference er : this.getEjbReferenceDescriptors()) {
            if (!er.getName().equals(name)) continue;
            return er;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbrefbyname", "This app [{0}] has no ejb reference by the name of [{1}] ", new Object[]{this.getName(), name}));
    }

    @Override
    public Set<ServiceReferenceDescriptor> getServiceReferenceDescriptors() {
        return this.serviceReferences;
    }

    @Override
    public void addServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        serviceRef.setBundleDescriptor(this);
        this.serviceReferences.add(serviceRef);
    }

    @Override
    public void removeServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        this.serviceReferences.remove(serviceRef);
    }

    @Override
    public ServiceReferenceDescriptor getServiceReferenceByName(String name) {
        for (ServiceReferenceDescriptor srd : this.getServiceReferenceDescriptors()) {
            if (!srd.getName().equals(name)) continue;
            return srd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoservicerefbyname", "This app [{0}] has no service reference by the name of [{1}]", new Object[]{this.getRegistrationName(), name}));
    }

    @Override
    public Set<MessageDestinationReferenceDescriptor> getMessageDestinationReferenceDescriptors() {
        return this.messageDestReferences;
    }

    @Override
    public void addMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor messageDestRef) {
        messageDestRef.setReferringBundleDescriptor(this);
        this.messageDestReferences.add(messageDestRef);
    }

    @Override
    public void removeMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor msgDestRef) {
        this.messageDestReferences.remove(msgDestRef);
    }

    @Override
    public MessageDestinationReferenceDescriptor getMessageDestinationReferenceByName(String name) {
        for (MessageDestinationReferenceDescriptor mdr : this.messageDestReferences) {
            if (!mdr.getName().equals(name)) continue;
            return mdr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("exceptionapphasnomsgdestrefbyname", "This app [{0}] has no message destination reference by the name of [{1}]", new Object[]{this.getRegistrationName(), name}));
    }

    @Override
    public Set<JmsDestinationReferenceDescriptor> getJmsDestinationReferenceDescriptors() {
        return this.jmsDestReferences;
    }

    @Override
    public void addJmsDestinationReferenceDescriptor(JmsDestinationReferenceDescriptor jmsDestReference) {
        this.jmsDestReferences.add(jmsDestReference);
    }

    @Override
    public void removeJmsDestinationReferenceDescriptor(JmsDestinationReferenceDescriptor jmsDestReference) {
        this.jmsDestReferences.remove(jmsDestReference);
    }

    @Override
    public JmsDestinationReferenceDescriptor getJmsDestinationReferenceByName(String name) {
        for (JmsDestinationReferenceDescriptor jdr : this.getJmsDestinationReferenceDescriptors()) {
            if (!jdr.getName().equals(name)) continue;
            return jdr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnojmsdestrefbyname", "This app {0} has no resource environment reference by the name of {1}", new Object[]{this.getRegistrationName(), name}));
    }

    @Override
    public Set<ResourceReferenceDescriptor> getResourceReferenceDescriptors() {
        return this.resourceReferences;
    }

    @Override
    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.resourceReferences.add(resourceReference);
    }

    @Override
    public void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.resourceReferences.remove(resourceReference);
    }

    @Override
    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        for (ResourceReferenceDescriptor next : this.getResourceReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoresourcerefbyname", "This app {0} has no resource reference by the name of {1}", new Object[]{this.getRegistrationName(), name}));
    }

    @Override
    public EnvironmentProperty getEnvironmentPropertyByName(String name) {
        for (EnvironmentProperty ev : this.getEnvironmentProperties()) {
            if (!ev.getName().equals(name)) continue;
            return ev;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoenvpropertybyname", "This app {0} has no environment property by the name of {1}", new Object[]{this.getRegistrationName(), name}));
    }

    @Override
    public Set<EnvironmentProperty> getEnvironmentProperties() {
        return this.environmentProperties;
    }

    @Override
    public void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.environmentProperties.add(environmentProperty);
    }

    @Override
    public void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.getEnvironmentProperties().remove(environmentProperty);
    }

    @Override
    public Set<EntityManagerFactoryReferenceDescriptor> getEntityManagerFactoryReferenceDescriptors() {
        return this.entityManagerFactoryReferences;
    }

    @Override
    public EntityManagerFactoryReferenceDescriptor getEntityManagerFactoryReferenceByName(String name) {
        for (EntityManagerFactoryReferenceDescriptor next : this.getEntityManagerFactoryReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoentitymgrfactoryrefbyname", "This app {0} has no entity manager factory reference by the name of {1}", new Object[]{this.getRegistrationName(), name}));
    }

    @Override
    public void addEntityManagerFactoryReferenceDescriptor(EntityManagerFactoryReferenceDescriptor reference) {
        reference.setReferringBundleDescriptor(this);
        this.entityManagerFactoryReferences.add(reference);
    }

    @Override
    public Set<EntityManagerReferenceDescriptor> getEntityManagerReferenceDescriptors() {
        return this.entityManagerReferences;
    }

    @Override
    public EntityManagerReferenceDescriptor getEntityManagerReferenceByName(String name) {
        for (EntityManagerReferenceDescriptor next : this.getEntityManagerReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoentitymgrrefbyname", "This app {0} has no entity manager reference by the name of {1}", new Object[]{this.getRegistrationName(), name}));
    }

    @Override
    public void addEntityManagerReferenceDescriptor(EntityManagerReferenceDescriptor reference) {
        reference.setReferringBundleDescriptor(this);
        this.getEntityManagerReferenceDescriptors().add(reference);
    }

    @Override
    public Set<DataSourceDefinitionDescriptor> getDataSourceDefinitionDescriptors() {
        return this.datasourceDefinitionDescs;
    }

    @Override
    public void addDataSourceDefinitionDescriptor(DataSourceDefinitionDescriptor reference) {
        for (DataSourceDefinitionDescriptor desc : this.getDataSourceDefinitionDescriptors()) {
            if (!desc.getName().equals(reference.getName())) continue;
            throw new IllegalStateException(localStrings.getLocalString("exceptionapplicationduplicatedatasourcedefinition", "This application [{0}] cannot have datasource definitions of same name : [{1}]", new Object[]{this.getName(), reference.getName()}));
        }
        this.getDataSourceDefinitionDescriptors().add(reference);
    }

    @Override
    public void removeDataSourceDefinitionDescriptor(DataSourceDefinitionDescriptor reference) {
        this.getDataSourceDefinitionDescriptors().remove(reference);
    }

    @Override
    public Set<LifecycleCallbackDescriptor> getPostConstructDescriptors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPostConstructDescriptor(LifecycleCallbackDescriptor postConstructDesc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<LifecycleCallbackDescriptor> getPreDestroyDescriptors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPreDestroyDescriptor(LifecycleCallbackDescriptor preDestroyDesc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<InjectionCapable> getInjectableResourcesByClass(String className) {
        return this.getInjectableResourcesByClass(className, this);
    }

    @Override
    public InjectionInfo getInjectionInfoByClass(String className) {
        return this.getInjectionInfoByClass(className, this);
    }

    public void setGeneratedXMLDirectory(String xmlDir) {
        this.generatedXMLDir = xmlDir;
    }

    public String getGeneratedXMLDirectory() {
        return this.generatedXMLDir;
    }

    public void setRegistrationName(String appId) {
        SecurityRoleMapper roleMapper = null;
        try {
            roleMapper = this.getRoleMapper();
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        if (roleMapper != null) {
            SecurityRoleMapperFactory factory = (SecurityRoleMapperFactory)this.habitat.getComponent(SecurityRoleMapperFactory.class);
            if (factory == null) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.norolemapperfactorydefine", "This application has no role mapper factory defined"));
            }
            factory.removeRoleMapper(this.getName());
            roleMapper.setName(appId);
            factory.setRoleMapper(appId, roleMapper);
        }
        this.registrationName = appId;
    }

    public String getRegistrationName() {
        if (this.registrationName != null) {
            return this.registrationName;
        }
        return this.getName();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public boolean isInitializeInOrder() {
        return this.initializeInOrder;
    }

    public void setInitializeInOrder(boolean initializeInOrder) {
        this.initializeInOrder = initializeInOrder;
    }

    public void addEntityManagerFactory(String unitName, String persistenceRootUri, EntityManagerFactory emf) {
        String fullyQualifiedUnitName = persistenceRootUri + PERSISTENCE_UNIT_NAME_SEPARATOR + unitName;
        this.entityManagerFactories.put(fullyQualifiedUnitName, emf);
        if (this.entityManagerFactoryUnitNames.contains(unitName)) {
            this.entityManagerFactories.remove(unitName);
        } else {
            this.entityManagerFactories.put(unitName, emf);
            this.entityManagerFactoryUnitNames.add(unitName);
        }
    }

    public EntityManagerFactory getEntityManagerFactory(String unitName, BundleDescriptor declaringModule) {
        String lookupString = unitName;
        int separatorIndex = unitName.lastIndexOf(PERSISTENCE_UNIT_NAME_SEPARATOR);
        if (separatorIndex != -1) {
            String unqualifiedUnitName = unitName.substring(separatorIndex + 1);
            String path = unitName.substring(0, separatorIndex);
            String persistenceRootUri = this.getTargetUri(declaringModule, path);
            lookupString = persistenceRootUri + PERSISTENCE_UNIT_NAME_SEPARATOR + unqualifiedUnitName;
        }
        return this.entityManagerFactories.get(lookupString);
    }

    @Override
    public Set<EntityManagerFactory> getEntityManagerFactories() {
        return new HashSet<EntityManagerFactory>(this.entityManagerFactories.values());
    }

    @Override
    public Set<Role> getRoles() {
        HashSet<Role> roles = new HashSet<Role>();
        for (WebBundleDescriptor wbd : this.getWebBundleDescriptors()) {
            if (wbd == null) continue;
            roles.addAll(wbd.getRoles());
        }
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            if (ejbd == null) continue;
            roles.addAll(ejbd.getRoles());
        }
        return roles;
    }

    public Set<Role> getAppRoles() {
        if (this.appRoles == null) {
            this.appRoles = new HashSet<Role>();
        }
        return this.appRoles;
    }

    public void addAppRole(SecurityRoleDescriptor descriptor) {
        Role role = new Role(descriptor.getName());
        role.setDescription(descriptor.getDescription());
        this.getAppRoles().add(role);
    }

    @Override
    public void addRole(Role role) {
        for (WebBundleDescriptor wbd : this.getWebBundleDescriptors()) {
            wbd.addRole(role);
        }
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            ejbd.addRole(role);
        }
    }

    @Override
    public void removeRole(Role role) {
        this.getAppRoles().remove((Object)role);
        for (WebBundleDescriptor wbd : this.getWebBundleDescriptors()) {
            wbd.removeRole(role);
        }
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            ejbd.removeRole(role);
        }
    }

    @Override
    public void setName(String name) {
        name = name.replace('/', '-');
        name = name.replace('\\', '-');
        super.setName(name);
        if (this.getRoleMapper() != null) {
            this.getRoleMapper().setName(name);
        }
    }

    public void setLibraryDirectory(String value) {
        this.libraryDirectory = value;
    }

    public String getLibraryDirectory() {
        if (this.libraryDirectory != null) {
            return this.libraryDirectory.length() == 0 ? null : this.libraryDirectory;
        }
        return LIBRARY_DIRECTORY_DEFAULT_VALUE;
    }

    public String getLibraryDirectoryRawValue() {
        return this.libraryDirectory;
    }

    public int getWebComponentCount() {
        int count = 0;
        for (WebBundleDescriptor wbd : this.getWebBundleDescriptors()) {
            count += wbd.getWebComponentDescriptors().size();
        }
        return count;
    }

    public void removeModule(ModuleDescriptor<BundleDescriptor> descriptor) {
        if (this.modules.contains(descriptor)) {
            if (descriptor.getDescriptor() != null) {
                descriptor.getDescriptor().setApplication(null);
            }
            this.modules.remove(descriptor);
        }
    }

    public void addModule(ModuleDescriptor<BundleDescriptor> descriptor) {
        this.modules.add(descriptor);
        if (descriptor.getDescriptor() != null) {
            descriptor.getDescriptor().setApplication(this);
        }
    }

    public Set<ModuleDescriptor<BundleDescriptor>> getModules() {
        return this.modules;
    }

    public int getEjbComponentCount() {
        int count = 0;
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            count += ejbd.getEjbs().size();
        }
        return count;
    }

    public int getRarComponentCount() {
        return this.getBundleDescriptors(ConnectorDescriptor.class).size();
    }

    public EjbBundleDescriptor getEjbBundleByName(String name) {
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            if (!ejbd.getDisplayName().equals(name)) continue;
            return ejbd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbjarnamed", "This application has no ejb jars of name {0}", new Object[]{name}));
    }

    public String getTargetUri(BundleDescriptor origin, String relativeTargetUri) {
        String targetUri = null;
        try {
            String archiveUri = origin.getModuleDescriptor().getArchiveUri();
            URI originUri = new URI(archiveUri);
            URI resolvedUri = originUri.resolve(relativeTargetUri);
            targetUri = resolvedUri.getPath();
        }
        catch (URISyntaxException use) {
            _logger.log(Level.FINE, "origin " + origin + " has invalid syntax", use);
        }
        return targetUri;
    }

    public BundleDescriptor getRelativeBundle(BundleDescriptor origin, String relativeTargetUri) {
        String targetBundleUri = this.getTargetUri(origin, relativeTargetUri);
        BundleDescriptor targetBundle = null;
        if (targetBundleUri != null) {
            BundleDescriptor module = this.getModuleByUri(targetBundleUri);
            targetBundle = module instanceof BundleDescriptor ? module : null;
        }
        return targetBundle;
    }

    public String getRelativeUri(BundleDescriptor origin, BundleDescriptor target) {
        String originUri = origin.getModuleDescriptor().getArchiveUri();
        String targetUri = target.getModuleDescriptor().getArchiveUri();
        StringTokenizer tokenizer = new StringTokenizer(originUri, "/");
        int numTokens = tokenizer.countTokens();
        int numSeparators = numTokens > 0 ? numTokens - 1 : 0;
        StringBuffer relativeUri = new StringBuffer();
        for (int i = 0; i < numSeparators; ++i) {
            relativeUri.append("../");
        }
        relativeUri.append(targetUri);
        return relativeUri.toString();
    }

    public EjbBundleDescriptor getEjbBundleByUri(String name) {
        EjbBundleDescriptor desc = this.getModuleByTypeAndUri(EjbBundleDescriptor.class, name);
        if (desc != null) {
            return desc;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbjarnamed", "This application has no ejb jars of name {0}", new Object[]{name}));
    }

    public ModuleDescriptor<BundleDescriptor> getModuleDescriptorByUri(String uri) {
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            if (!aModule.getArchiveUri().equals(uri)) continue;
            return aModule;
        }
        return null;
    }

    public Collection<ModuleDescriptor<BundleDescriptor>> getModuleDescriptorsByType(XModuleType type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        LinkedList<ModuleDescriptor<BundleDescriptor>> results = new LinkedList<ModuleDescriptor<BundleDescriptor>>();
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            if (!type.equals(aModule.getModuleType())) continue;
            results.add(aModule);
        }
        return results;
    }

    public BundleDescriptor getModuleByUri(String uri) {
        ModuleDescriptor<BundleDescriptor> md = this.getModuleDescriptorByUri(uri);
        if (md != null) {
            return md.getDescriptor();
        }
        return null;
    }

    public <T extends BundleDescriptor> T getModuleByTypeAndUri(Class<T> type, String uri) {
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            try {
                BundleDescriptor descriptor = (BundleDescriptor)type.cast(aModule.getDescriptor());
                if (!descriptor.getModuleDescriptor().getArchiveUri().equals(uri)) continue;
                return (T)descriptor;
            }
            catch (ClassCastException e) {
            }
        }
        return null;
    }

    public EjbDescriptor getEjbByName(String ejbName) {
        for (EjbBundleDescriptor ejbd : this.getEjbBundleDescriptors()) {
            if (!ejbd.hasEjbByName(ejbName)) continue;
            return ejbd.getEjbByName(ejbName);
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnobeannamed", "This application has no beans of name {0}", new Object[]{ejbName}));
    }

    public boolean hasEjbByName(String ejbName) {
        for (EjbBundleDescriptor ebd : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
            if (!ebd.hasEjbByName(ejbName)) continue;
            return true;
        }
        return false;
    }

    public ApplicationClientDescriptor getApplicationClientByName(String name) {
        for (ApplicationClientDescriptor acd : this.getBundleDescriptors(ApplicationClientDescriptor.class)) {
            if (!acd.getDisplayName().equals(name)) continue;
            return acd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoappclientname", "This application has no application clients of name {0}", new Object[]{name}));
    }

    public ApplicationClientDescriptor getApplicationClientByUri(String name) {
        ApplicationClientDescriptor desc = this.getModuleByTypeAndUri(ApplicationClientDescriptor.class, name);
        if (desc != null) {
            return desc;
        }
        throw new IllegalArgumentException(name);
    }

    public WebBundleDescriptor getWebBundleDescriptorByName(String name) {
        for (WebBundleDescriptor wbd : this.getBundleDescriptors(WebBundleDescriptor.class)) {
            if (!wbd.getDisplayName().equals(name)) continue;
            return wbd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnowebappname", "This application has no web app of name {0}", new Object[]{name}));
    }

    public WebBundleDescriptor getWebBundleDescriptorByUri(String name) {
        WebBundleDescriptor desc = this.getModuleByTypeAndUri(WebBundleDescriptor.class, name);
        if (desc != null) {
            return desc;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnowebappname", "This application has no web app of name {0}", new Object[]{name}));
    }

    public ConnectorDescriptor getRarDescriptorByUri(String name) {
        ConnectorDescriptor desc = this.getModuleByTypeAndUri(ConnectorDescriptor.class, name);
        if (desc != null) {
            return desc;
        }
        throw new IllegalArgumentException(name);
    }

    public Set<JndiNameEnvironment> getJndiNameEnvironments() {
        HashSet<JndiNameEnvironment> jndiNameEnvironments = new HashSet<JndiNameEnvironment>();
        jndiNameEnvironments.add(this);
        jndiNameEnvironments.addAll(this.getWebBundleDescriptors());
        jndiNameEnvironments.addAll(this.getApplicationClientDescriptors());
        jndiNameEnvironments.addAll(this.getEjbDescriptors());
        return jndiNameEnvironments;
    }

    public Set<WebService> getWebServiceDescriptors() {
        HashSet<WebService> webServiceDescriptors = new HashSet<WebService>();
        HashSet<BundleDescriptor> bundles = new HashSet<BundleDescriptor>();
        bundles.addAll(this.getEjbBundleDescriptors());
        bundles.addAll(this.getWebBundleDescriptors());
        for (BundleDescriptor next : bundles) {
            WebServicesDescriptor webServicesDesc = next.getWebServices();
            webServiceDescriptors.addAll(webServicesDesc.getWebServices());
        }
        return webServiceDescriptors;
    }

    public Set<WebBundleDescriptor> getWebBundleDescriptors() {
        return this.getBundleDescriptors(WebBundleDescriptor.class);
    }

    public BundleDescriptor getStandaloneBundleDescriptor() {
        if (this.isVirtual()) {
            if (this.getModules().size() > 1) {
                throw new IllegalStateException("Virtual application contains more than one module");
            }
            return this.getModules().iterator().next().getDescriptor();
        }
        return null;
    }

    public <T extends BundleDescriptor> Set<T> getBundleDescriptors(Class<T> type) {
        if (type == null) {
            return null;
        }
        OrderedSet bundleSet = new OrderedSet();
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            try {
                BundleDescriptor descriptor = (BundleDescriptor)type.cast(aModule.getDescriptor());
                bundleSet.add(descriptor);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            if (aModule.getDescriptor() == null) continue;
            bundleSet.addAll(aModule.getDescriptor().getExtensionsDescriptors(type));
        }
        return bundleSet;
    }

    public Set<BundleDescriptor> getBundleDescriptors() {
        OrderedSet<BundleDescriptor> bundleSet = new OrderedSet<BundleDescriptor>();
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            if (aModule.getDescriptor() != null) {
                bundleSet.add(aModule.getDescriptor());
                continue;
            }
            DOLUtils.getDefaultLogger().fine("Null descriptor for module " + aModule.getArchiveUri());
        }
        return bundleSet;
    }

    @Override
    public void addBundleDescriptor(BundleDescriptor bundleDescriptor) {
        ModuleDescriptor newModule = bundleDescriptor.getModuleDescriptor();
        this.addModule(newModule);
    }

    public void removeBundleDescriptor(BundleDescriptor bundleDescriptor) {
        bundleDescriptor.setApplication(null);
        this.getWebBundleDescriptors().remove(bundleDescriptor);
    }

    public Set<EjbBundleDescriptor> getEjbBundleDescriptors() {
        return this.getBundleDescriptors(EjbBundleDescriptor.class);
    }

    public Set<ConnectorDescriptor> getRarDescriptors() {
        return this.getBundleDescriptors(ConnectorDescriptor.class);
    }

    public Set<ApplicationClientDescriptor> getApplicationClientDescriptors() {
        return this.getBundleDescriptors(ApplicationClientDescriptor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EjbCMPEntityDescriptor getCMPDescriptorFor(String className) {
        String string = this.cmpDescriptorsLock;
        synchronized (string) {
            if (this.cmpDescriptors == null) {
                this.cmpDescriptors = new HashMap();
                for (EjbBundleDescriptor bundle : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
                    for (EjbDescriptor ejb : bundle.getEjbs()) {
                        if (!(ejb instanceof EjbCMPEntityDescriptor)) continue;
                        this.cmpDescriptors.put(ejb.getEjbImplClassName(), ejb);
                    }
                }
            }
            return (EjbCMPEntityDescriptor)this.cmpDescriptors.get(className);
        }
    }

    public Vector getEjbDescriptors() {
        Vector<EjbDescriptor> ejbDescriptors = new Vector<EjbDescriptor>();
        for (EjbBundleDescriptor ejbBundleDescriptor : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
            ejbDescriptors.addAll(ejbBundleDescriptor.getEjbs());
        }
        return ejbDescriptors;
    }

    public boolean containsCMPEntity() {
        for (EjbBundleDescriptor ebd : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
            if (!ebd.containsCMPEntity()) continue;
            return true;
        }
        return false;
    }

    public EjbDescriptor[] getSortedEjbDescriptors() {
        Vector ejbDesc = this.getEjbDescriptors();
        EjbDescriptor[] descs = ejbDesc.toArray(new EjbDescriptor[ejbDesc.size()]);
        Arrays.sort(descs, new Comparator(){

            public int compare(Object o1, Object o2) {
                EjbDescriptor desc1 = (EjbDescriptor)o1;
                EjbDescriptor desc2 = (EjbDescriptor)o2;
                String moduleUri1 = desc1.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                String moduleUri2 = desc2.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                return (moduleUri1 + desc1.getName()).compareTo(moduleUri2 + desc2.getName());
            }
        });
        return descs;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isPackagedAsSingleModule() {
        return this.isPackagedAsSingleModule;
    }

    public void setPackagedAsSingleModule(boolean status) {
        this.isPackagedAsSingleModule = status;
    }

    public boolean isUniqueIdSet() {
        return this.uniqueIdSet;
    }

    public void setUniqueId(long id) {
        _logger.log(Level.FINE, "[Application] " + this.getName() + " , uid: " + id);
        this.uniqueId = id;
        EjbDescriptor[] descs = this.getSortedEjbDescriptors();
        for (int i = 0; i < descs.length; ++i) {
            descs[i].setUniqueId(id | (long)i);
            if (!_logger.isLoggable(Level.FINE)) continue;
            String module = descs[i].getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
            _logger.log(Level.FINE, "Ejb  " + module + ":" + descs[i].getName() + " id = " + descs[i].getUniqueId());
        }
        this.uniqueIdSet = true;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setPassByReference(boolean passByReference) {
        this.passByReference = passByReference;
    }

    public boolean getPassByReference() {
        boolean passByReference = false;
        if (this.isPassByReferenceDefined()) {
            passByReference = this.passByReference;
        }
        return passByReference;
    }

    public boolean isPassByReferenceDefined() {
        boolean passByReferenceDefined = false;
        if (this.passByReference != null) {
            passByReferenceDefined = true;
        }
        return passByReferenceDefined;
    }

    public void addApplication(Application application) {
        for (ModuleDescriptor<BundleDescriptor> md : application.getModules()) {
            this.addModule(md);
        }
    }

    public Set getArchivableDescriptors() {
        OrderedSet archivableDescriptors = new OrderedSet();
        archivableDescriptors.addAll(this.getBundleDescriptors());
        return archivableDescriptors;
    }

    public void setRoleMapper(SecurityRoleMapper roleMapper) {
        this.roleMapper = roleMapper;
    }

    public boolean hasRuntimeInformation() {
        return true;
    }

    @Override
    public SecurityRoleMapper getRoleMapper() {
        if (this.roleMapper == null) {
            SecurityRoleMapperFactory factory = (SecurityRoleMapperFactory)this.habitat.getComponent(SecurityRoleMapperFactory.class);
            if (factory == null) {
                _logger.log(Level.FINE, "SecurityRoleMapperFactory NOT set.");
            } else {
                this.roleMapper = factory.getRoleMapper(this.getName());
            }
        }
        return this.roleMapper;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            throw new RuntimeException("No class loader associated with application " + this.getName());
        }
        return this.classLoader;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Application");
        toStringBuffer.append("\n");
        super.print(toStringBuffer);
        toStringBuffer.append("\n smallIcon ").append(super.getSmallIconUri());
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            toStringBuffer.append("\n  Module : ");
            aModule.print(toStringBuffer);
        }
        toStringBuffer.append("\n EjbBundles: \n");
        if (this.getEjbBundleDescriptors() != null) {
            this.printDescriptorSet(this.getEjbBundleDescriptors(), toStringBuffer);
        }
        toStringBuffer.append("\n WebBundleDescriptors ");
        if (this.getWebBundleDescriptors() != null) {
            this.printDescriptorSet(this.getWebBundleDescriptors(), toStringBuffer);
        }
        toStringBuffer.append("\n applicationClientDescriptors ");
        if (this.getApplicationClientDescriptors() != null) {
            this.printDescriptorSet(this.getApplicationClientDescriptors(), toStringBuffer);
        }
        toStringBuffer.append("\n roles ").append(this.getRoles());
        toStringBuffer.append("\n RoleMapper ").append(this.getRoleMapper());
        toStringBuffer.append("\n Realm ").append(this.realm);
    }

    private void printDescriptorSet(Set descSet, StringBuffer sbuf) {
        for (Object obj : descSet) {
            if (obj instanceof Descriptor) {
                ((Descriptor)obj).print(sbuf);
                continue;
            }
            sbuf.append(obj);
        }
    }

    @Override
    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof ApplicationVisitor) {
            this.visit((ApplicationVisitor)aVisitor);
        } else {
            super.visit(aVisitor);
        }
    }

    public void visit(ApplicationVisitor aVisitor) {
        AppClientVisitor appclientVisitor;
        ConnectorVisitor connectorVisitor;
        WebBundleVisitor webVisitor;
        aVisitor.accept(this);
        EjbBundleVisitor ejbBundleVisitor = aVisitor.getEjbBundleVisitor();
        if (ejbBundleVisitor != null) {
            for (EjbBundleDescriptor ebd : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
                ebd.visit(ejbBundleVisitor);
            }
        }
        if ((webVisitor = aVisitor.getWebBundleVisitor()) != null) {
            for (WebBundleDescriptor wbd : this.getBundleDescriptors(WebBundleDescriptor.class)) {
                if (wbd == null) continue;
                wbd.visit(webVisitor);
            }
        }
        if ((connectorVisitor = aVisitor.getConnectorVisitor()) != null) {
            for (ConnectorDescriptor cd : this.getBundleDescriptors(ConnectorDescriptor.class)) {
                cd.visit(connectorVisitor);
            }
        }
        if ((appclientVisitor = aVisitor.getAppClientVisitor()) != null) {
            for (ApplicationClientDescriptor acd : this.getBundleDescriptors(ApplicationClientDescriptor.class)) {
                acd.visit(appclientVisitor);
            }
        }
        for (InjectionCapable injectable : this.getInjectableResources(this)) {
            aVisitor.accept(injectable);
        }
        Set<EjbReference> ejbRefs = this.getEjbReferenceDescriptors();
        Iterator<InjectionCapable> itr = ejbRefs.iterator();
        while (itr.hasNext()) {
            aVisitor.accept(itr.next());
        }
        for (ResourceReferenceDescriptor resourceReferenceDescriptor : this.getResourceReferenceDescriptors()) {
            aVisitor.accept(resourceReferenceDescriptor);
        }
        for (JmsDestinationReferenceDescriptor jmsDestinationReferenceDescriptor : this.getJmsDestinationReferenceDescriptors()) {
            aVisitor.accept(jmsDestinationReferenceDescriptor);
        }
        Set<MessageDestinationReferenceDescriptor> msgDestRefs = this.getMessageDestinationReferenceDescriptors();
        Iterator<MessageDestinationReferenceDescriptor> iterator = msgDestRefs.iterator();
        while (iterator.hasNext()) {
            aVisitor.accept((MessageDestinationReferencer)iterator.next());
        }
        for (MessageDestinationDescriptor msgDestDescriptor : this.getMessageDestinations()) {
            aVisitor.accept(msgDestDescriptor);
        }
        Set<ServiceReferenceDescriptor> set = this.getServiceReferenceDescriptors();
        Iterator<ServiceReferenceDescriptor> itr3 = set.iterator();
        while (itr3.hasNext()) {
            aVisitor.accept(itr3.next());
        }
    }

    @Override
    public String getModuleID() {
        return this.moduleID;
    }

    @Override
    public boolean isApplication() {
        return true;
    }

    @Override
    public XModuleType getModuleType() {
        return XModuleType.EAR;
    }

    public void addSecurityRoleMapping(SecurityRoleMapping roleMapping) {
        this.roleMaps.add(roleMapping);
    }

    public List<SecurityRoleMapping> getSecurityRoleMappings() {
        return this.roleMaps;
    }

    public void setLoadedFromApplicationXml(boolean bool) {
        this.loadedFromApplicationXml = bool;
    }

    public boolean isLoadedFromApplicationXml() {
        return this.loadedFromApplicationXml;
    }

    public void setResourceList(List<Resource> rList) {
        this.resourceList = rList;
    }

    public List<Resource> getResourceList() {
        return this.resourceList;
    }
}

