/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractCommonAttributeHandler;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.util.TypeUtil;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.TransportProtected;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAuthAnnotationHandler
extends AbstractCommonAttributeHandler
implements PostProcessor {
    AbstractAuthAnnotationHandler() {
    }

    protected abstract void processEjbMethodSecurity(Annotation var1, MethodDescriptor var2, EjbDescriptor var3);

    protected abstract void processSecurityConstraint(Annotation var1, SecurityConstraint var2, WebComponentDescriptor var3);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        if (!this.validateAccessControlAnnotations(ainfo)) {
            return this.getDefaultFailedResult();
        }
        Annotation authAnnotation = ainfo.getAnnotation();
        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            for (Object next : ejbDesc.getSecurityBusinessMethodDescriptors()) {
                Method m;
                MethodDescriptor md = (MethodDescriptor)next;
                if (this.hasMethodPermissionsFromDD(md, ejbDesc) || !TypeUtil.sameMethodSignature(m = md.getMethod(ejbDesc), annMethod)) continue;
                this.processEjbMethodSecurity(authAnnotation, md, ejbDesc);
            }
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        if (!this.validateAccessControlAnnotations(ainfo)) {
            return this.getDefaultFailedResult();
        }
        Annotation authAnnotation = ainfo.getAnnotation();
        boolean ok = true;
        if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
            for (WebComponentContext webCompContext : webCompContexts) {
                WebComponentDescriptor webCompDesc = webCompContext.getDescriptor();
                this.addAllHttpMethodConstraint(authAnnotation, webCompDesc, webCompContext);
            }
        } else {
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            if (this.isValidHttpServletAnnotatedMethod(annMethod)) {
                String httpMethod = annMethod.getName().substring(2).toUpperCase();
                for (WebComponentContext webCompContext : webCompContexts) {
                    WebComponentDescriptor webCompDesc = webCompContext.getDescriptor();
                    SecurityConstraint typeSecConstr = webCompContext.getTypeSecurityConstraint();
                    if (typeSecConstr != null) {
                        this.validateClassMethodAccessControlAnnotations(ainfo, typeSecConstr);
                        for (WebResourceCollection wrc : typeSecConstr.getWebResourceCollections()) {
                            wrc.addHttpMethodOmission(httpMethod);
                            this.addHttpMethodConstraint(authAnnotation, webCompDesc, httpMethod, wrc.getUrlPatterns(), webCompContext);
                        }
                        continue;
                    }
                    this.addHttpMethodConstraint(authAnnotation, webCompDesc, httpMethod, null, webCompContext);
                }
            } else {
                ok = false;
            }
        }
        return ok ? this.getDefaultProcessedResult() : this.getDefaultFailedResult();
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleContext webBundleContext) throws AnnotationProcessorException {
        return this.getInvalidAnnotatedElementHandlerResult((AnnotatedElementHandler)webBundleContext, ainfo);
    }

    @Override
    public void postProcessAnnotation(AnnotationInfo ainfo, AnnotatedElementHandler aeHandler) throws AnnotationProcessorException {
        EjbContext ejbContext = (EjbContext)aeHandler;
        EjbDescriptor ejbDesc = ejbContext.getDescriptor();
        Annotation authAnnotation = ainfo.getAnnotation();
        if (!(ejbContext.isInherited() || ejbDesc.getMethodPermissionsFromDD() != null && ejbDesc.getMethodPermissionsFromDD().size() != 0)) {
            for (MethodDescriptor md : this.getMethodAllDescriptors(ejbDesc)) {
                this.processEjbMethodSecurity(authAnnotation, md, ejbDesc);
            }
        } else {
            Class classAn = (Class)ainfo.getAnnotatedElement();
            for (Object next : ejbDesc.getSecurityBusinessMethodDescriptors()) {
                MethodDescriptor md = (MethodDescriptor)next;
                Method m = md.getMethod(ejbDesc);
                if (!classAn.equals(ejbContext.getDeclaringClass(md)) || this.hasMethodPermissionsFromDD(md, ejbDesc)) continue;
                this.processEjbMethodSecurity(authAnnotation, md, ejbDesc);
            }
        }
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    private Set<MethodDescriptor> getMethodAllDescriptors(EjbDescriptor ejbDesc) {
        HashSet<MethodDescriptor> methodAlls = new HashSet<MethodDescriptor>();
        if (ejbDesc.isRemoteInterfacesSupported() || ejbDesc.isRemoteBusinessInterfacesSupported()) {
            methodAlls.add(new MethodDescriptor("*", "", "Remote"));
            if (ejbDesc.isRemoteInterfacesSupported()) {
                methodAlls.add(new MethodDescriptor("*", "", "Home"));
            }
        }
        if (ejbDesc.isLocalInterfacesSupported() || ejbDesc.isLocalBusinessInterfacesSupported()) {
            methodAlls.add(new MethodDescriptor("*", "", "Local"));
            if (ejbDesc.isLocalInterfacesSupported()) {
                methodAlls.add(new MethodDescriptor("*", "", "LocalHome"));
            }
        }
        if (ejbDesc.isLocalBean()) {
            methodAlls.add(new MethodDescriptor("*", "", "Local"));
        }
        if (ejbDesc.hasWebServiceEndpointInterface()) {
            methodAlls.add(new MethodDescriptor("*", "", "ServiceEndpoint"));
        }
        return methodAlls;
    }

    private boolean hasMethodPermissionsFromDD(MethodDescriptor methodDesc, EjbDescriptor ejbDesc) {
        HashMap methodPermissionsFromDD = ejbDesc.getMethodPermissionsFromDD();
        if (methodPermissionsFromDD != null) {
            Set allMethods = ejbDesc.getMethodDescriptors();
            String ejbClassSymbol = methodDesc.getEjbClassSymbol();
            for (Object mdObjsObj : methodPermissionsFromDD.values()) {
                List mdObjs = (List)mdObjsObj;
                for (Object mdObj : mdObjs) {
                    MethodDescriptor md = (MethodDescriptor)mdObj;
                    for (Object style3MdObj : md.doStyleConversion(ejbDesc, allMethods)) {
                        MethodDescriptor style3Md = (MethodDescriptor)style3MdObj;
                        if (!methodDesc.equals(style3Md)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean validateAccessControlAnnotations(AnnotationInfo ainfo) throws AnnotationProcessorException {
        boolean validity = true;
        AnnotatedElement ae = ainfo.getAnnotatedElement();
        int count = 0;
        boolean hasDenyAll = false;
        count += ae.isAnnotationPresent(RolesAllowed.class) ? 1 : 0;
        if (ae.isAnnotationPresent(DenyAll.class)) {
            ++count;
            hasDenyAll = true;
        }
        if (count < 2 && ae.isAnnotationPresent(PermitAll.class)) {
            ++count;
        }
        if (count > 1) {
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.morethanoneauthannotation", "One cannot have more than one of @RolesAllowed, @PermitAll, @DenyAll in the same AnnotatedElement."));
            validity = false;
        }
        if (hasDenyAll && ae.isAnnotationPresent(TransportProtected.class)) {
            this.log(Level.WARNING, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.warningdenyalltransportprotected", "One should not have @DenyAll and @TransportProtected together. The @TransportProtected would be ignored."));
        }
        return validity;
    }

    private void validateClassMethodAccessControlAnnotations(AnnotationInfo ainfo, SecurityConstraint typeSecConstr) throws AnnotationProcessorException {
        if (typeSecConstr == null) {
            return;
        }
        AnnotatedElement ae = ainfo.getAnnotatedElement();
        AuthorizationConstraint authConstr = typeSecConstr.getAuthorizationConstraint();
        if (typeSecConstr.getUserDataConstraint() != null && ae.isAnnotationPresent(DenyAll.class) || authConstr != null && !authConstr.getSecurityRoles().hasMoreElements() && ae.isAnnotationPresent(TransportProtected.class)) {
            this.log(Level.WARNING, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.warningdenyalltransportprotected", "One should not have @DenyAll and @TransportProtected together. The @TransportProtected would be ignored."));
        }
    }

    private void addAllHttpMethodConstraint(Annotation authAnnotation, WebComponentDescriptor webCompDesc, WebComponentContext webCompContext) {
        SecurityConstraint securityConstraint = webCompContext.getTypeSecurityConstraint();
        if (securityConstraint == null) {
            Set<String> nonOverridedUrlPatterns = webCompContext.getNonOverridedUrlPatterns();
            if (nonOverridedUrlPatterns == null) {
                nonOverridedUrlPatterns = this.getNonOverridedUrlPatterns(webCompDesc);
                webCompContext.setNonOverridedUrlPatterns(nonOverridedUrlPatterns);
            }
            securityConstraint = this.createSecurityConstraint(webCompDesc, nonOverridedUrlPatterns, null);
            webCompContext.setTypeSecurityConstraint(securityConstraint);
        }
        if (securityConstraint != null) {
            this.processSecurityConstraint(authAnnotation, securityConstraint, webCompDesc);
        }
    }

    private void addHttpMethodConstraint(Annotation authAnnotation, WebComponentDescriptor webCompDesc, String httpMethod, Set<String> urlPatterns, WebComponentContext webCompContext) {
        SecurityConstraint securityConstraint;
        if (urlPatterns == null && (urlPatterns = webCompContext.getNonOverridedUrlPatterns()) == null) {
            urlPatterns = this.getNonOverridedUrlPatterns(webCompDesc);
            webCompContext.setNonOverridedUrlPatterns(urlPatterns);
        }
        if ((securityConstraint = webCompContext.getMethodSecurityConstraint(httpMethod)) == null && (securityConstraint = this.createSecurityConstraint(webCompDesc, urlPatterns, httpMethod)) != null) {
            SecurityConstraint typeSecurityConstraint = webCompContext.getTypeSecurityConstraint();
            if (typeSecurityConstraint != null) {
                securityConstraint.setAuthorizationConstraint(typeSecurityConstraint.getAuthorizationConstraint());
                securityConstraint.setUserDataConstraint(typeSecurityConstraint.getUserDataConstraint());
            }
            webCompContext.putMethodSecurityConstraint(httpMethod, securityConstraint);
        }
        if (securityConstraint != null) {
            this.processSecurityConstraint(authAnnotation, securityConstraint, webCompDesc);
        }
    }

    private boolean isValidHttpServletAnnotatedMethod(Method method) {
        String[] names;
        boolean valid = false;
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (String name : names = new String[]{"doDelete", "doGet", "doHead", "doOptions", "doPost", "doPut", "doTrace"}) {
            if (!methodName.equals(name)) continue;
            valid = true;
            break;
        }
        valid = valid && Void.TYPE.equals(returnType) && parameterTypes.length == 2 && parameterTypes[0].equals(HttpServletRequest.class) && parameterTypes[1].equals(HttpServletResponse.class);
        return valid;
    }

    private Set<String> getNonOverridedUrlPatterns(WebComponentDescriptor webCompDesc) {
        HashSet<String> nonOverridedUrlPatterns = new HashSet<String>();
        HashMap<String, Boolean> url2MatchMap = new HashMap<String, Boolean>();
        WebBundleDescriptor webBundleDesc = webCompDesc.getWebBundleDescriptor();
        Set<String> urlPatterns = webCompDesc.getUrlPatternsSet();
        Enumeration<SecurityConstraint> eSecConstr = webBundleDesc.getSecurityConstraints();
        while (eSecConstr.hasMoreElements()) {
            SecurityConstraint sc = eSecConstr.nextElement();
            for (WebResourceCollection wrc : sc.getWebResourceCollections()) {
                for (String up : wrc.getUrlPatterns()) {
                    for (String urlPattern : urlPatterns) {
                        if (!this.implies(up, urlPattern)) continue;
                        url2MatchMap.put(urlPattern, Boolean.TRUE);
                    }
                }
            }
        }
        for (String urlPattern : urlPatterns) {
            if (Boolean.TRUE.equals(url2MatchMap.get(urlPattern))) continue;
            nonOverridedUrlPatterns.add(urlPattern);
        }
        return nonOverridedUrlPatterns;
    }

    private SecurityConstraint createSecurityConstraint(WebComponentDescriptor webCompDesc, Set<String> urlPatterns, String httpMethod) {
        WebBundleDescriptor webBundleDesc = webCompDesc.getWebBundleDescriptor();
        if (urlPatterns.size() == 0) {
            return null;
        }
        SecurityConstraintImpl securityConstraint = new SecurityConstraintImpl();
        WebResourceCollectionImpl webResourceColl = new WebResourceCollectionImpl();
        for (String urlPattern : urlPatterns) {
            webResourceColl.addUrlPattern(urlPattern);
        }
        if (httpMethod != null) {
            webResourceColl.addHttpMethod(httpMethod);
        }
        securityConstraint.addWebResourceCollection((WebResourceCollection)webResourceColl);
        webBundleDesc.addSecurityConstraint((SecurityConstraint)securityConstraint);
        return securityConstraint;
    }

    private boolean implies(String pattern, String path) {
        if (pattern.equals(path)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            int length = (pattern = pattern.substring(0, pattern.length() - 2)).length();
            if (length == 0) {
                return true;
            }
            return path.startsWith(pattern) && (path.length() == length || path.substring(length).startsWith("/"));
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }
}

