/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.appclient;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.DataSourceDefinitionNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.EjbLocalReferenceNode;
import com.sun.enterprise.deployment.node.EjbReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerFactoryReferenceNode;
import com.sun.enterprise.deployment.node.EnvEntryNode;
import com.sun.enterprise.deployment.node.LifecycleCallbackNode;
import com.sun.enterprise.deployment.node.MessageDestinationNode;
import com.sun.enterprise.deployment.node.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.ResourceRefNode;
import com.sun.enterprise.deployment.node.ServiceReferenceNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientNode
extends BundleNode<ApplicationClientDescriptor> {
    private ApplicationClientDescriptor descriptor;
    public static final String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN";
    public static final String SYSTEM_ID_12 = "http://java.sun.com/dtd/application-client_1_2.dtd";
    public static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/application-client_1_3.dtd";
    public static final String SCHEMA_ID_14 = "application-client_1_4.xsd";
    public static final String SCHEMA_ID = "application-client_5.xsd";
    public static final String SPEC_VERSION = "5";
    private static final List<String> systemIDs = AppClientNode.initSystemIDs();
    public static final XMLElement tag = new XMLElement("application-client");

    private static List<String> initSystemIDs() {
        ArrayList<String> systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        systemIDs.add(SCHEMA_ID_14);
        return Collections.unmodifiableList(systemIDs);
    }

    public AppClientNode() {
        this.registerElementHandler(new XMLElement("env-entry"), EnvEntryNode.class, "addEnvironmentProperty");
        this.registerElementHandler(new XMLElement("ejb-ref"), EjbReferenceNode.class);
        this.registerElementHandler(new XMLElement("ejb-local-ref"), EjbLocalReferenceNode.class);
        this.registerElementHandler(new XMLElement("service-ref"), ServiceReferenceNode.class, "addServiceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("resource-ref"), ResourceRefNode.class, "addResourceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("resource-env-ref"), ResourceEnvRefNode.class, "addJmsDestinationReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination-ref"), MessageDestinationRefNode.class, "addMessageDestinationReferenceDescriptor");
        this.registerElementHandler(new XMLElement("persistence-unit-ref"), EntityManagerFactoryReferenceNode.class, "addEntityManagerFactoryReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination"), MessageDestinationNode.class, "addMessageDestination");
        this.registerElementHandler(new XMLElement("post-construct"), LifecycleCallbackNode.class, "addPostConstructDescriptor");
        this.registerElementHandler(new XMLElement("pre-destroy"), LifecycleCallbackNode.class, "addPreDestroyDescriptor");
        this.registerElementHandler(new XMLElement("data-source"), DataSourceDefinitionNode.class, "addDataSourceDefinitionDescriptor");
    }

    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_12, SYSTEM_ID_12);
        return tag.getQName();
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbReference) {
            DOLUtils.getDefaultLogger().fine("Adding ejb ref " + newDescriptor);
            this.getDescriptor().addEjbReferenceDescriptor((EjbReference)newDescriptor);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    @Override
    public ApplicationClientDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (ApplicationClientDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    @Override
    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("callback-handler", "setCallbackHandler");
        return table;
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return tag;
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return SCHEMA_ID;
    }

    @Override
    public List<String> getSystemIDs() {
        return systemIDs;
    }

    @Override
    public Node writeDescriptor(Node parent, ApplicationClientDescriptor appclientDesc) {
        Node appclientNode = super.writeDescriptor(parent, appclientDesc);
        this.writeEnvEntryDescriptors(appclientNode, appclientDesc.getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(appclientNode, appclientDesc.getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(appclientNode, appclientDesc.getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(appclientNode, appclientDesc.getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(appclientNode, appclientDesc.getJmsDestinationReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(appclientNode, appclientDesc.getMessageDestinationReferenceDescriptors().iterator());
        this.writeEntityManagerFactoryReferenceDescriptors(appclientNode, appclientDesc.getEntityManagerFactoryReferenceDescriptors().iterator());
        this.writePostConstructDescriptors(appclientNode, appclientDesc.getPostConstructDescriptors().iterator());
        this.writePreDestroyDescriptors(appclientNode, appclientDesc.getPreDestroyDescriptors().iterator());
        this.writeDataSourceDefinitionDescriptors(appclientNode, appclientDesc.getDataSourceDefinitionDescriptors().iterator());
        AppClientNode.appendTextChild(appclientNode, "callback-handler", appclientDesc.getCallbackHandler());
        this.writeMessageDestinations(appclientNode, appclientDesc.getMessageDestinations().iterator());
        return appclientNode;
    }

    @Override
    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

