/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.managedbean;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import java.util.Set;
import org.glassfish.api.interceptor.InterceptorInvoker;
import org.glassfish.api.interceptor.JavaEEInterceptorBuilder;
import org.jvnet.hk2.component.Habitat;

public class ManagedBeanCreatorImpl {
    private Habitat habitat;
    private InjectionManager injectionMgr;

    public ManagedBeanCreatorImpl(Habitat h) {
        this.habitat = h;
        this.injectionMgr = (InjectionManager)this.habitat.getByContract(InjectionManager.class);
    }

    public Object createManagedBean(ManagedBeanDescriptor desc) throws Exception {
        Object managedBean;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> managedBeanClass = loader.loadClass(desc.getBeanClassName());
        Object callerObject = managedBean = managedBeanClass.newInstance();
        Set interceptorClasses = desc.getAllInterceptorClasses();
        if (interceptorClasses.isEmpty() && !desc.hasAroundInvokeMethod()) {
            this.injectionMgr.injectInstance(managedBean, desc.getGlobalJndiName(), true);
            desc.addBeanInstanceInfo(managedBean);
        } else {
            JavaEEInterceptorBuilder interceptorBuilder = (JavaEEInterceptorBuilder)desc.getInterceptorBuilder();
            InterceptorInvoker interceptorInvoker = interceptorBuilder.createInvoker(managedBean);
            callerObject = interceptorInvoker.getProxy();
            Object[] interceptorInstances = interceptorInvoker.getInterceptorInstances();
            this.injectionMgr.injectInstance(managedBean, desc.getGlobalJndiName(), false);
            for (int i = 0; i < interceptorInstances.length; ++i) {
                this.injectionMgr.injectInstance(interceptorInstances[i], desc.getGlobalJndiName(), false);
            }
            interceptorInvoker.invokePostConstruct();
            desc.addBeanInstanceInfo(managedBean, (Object)interceptorInvoker);
        }
        return callerObject;
    }
}

