/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.DomainXmlEventListener;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.RepositoryNameValidator;
import com.sun.enterprise.admin.servermgmt.pe.IndexHtmlTokens;
import com.sun.enterprise.admin.servermgmt.pe.PEAccXmlTokens;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainConfigValidator;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainXmlTokens;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.servermgmt.pe.PEScriptsTokens;
import com.sun.enterprise.admin.servermgmt.pe.ProfileTransformationException;
import com.sun.enterprise.admin.servermgmt.pe.ProfileTransformer;
import com.sun.enterprise.admin.servermgmt.util.DomainXmlSAXParser;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEDomainsManager
extends RepositoryManager
implements DomainsManager {
    private static final StringManager strMgr = StringManager.getManager(PEDomainsManager.class);
    private static final String NAME_DELIMITER = ",";
    public static final String PROFILEPROPERTY_DOMAINXML_STYLESHEETS = "domain.xml.style-sheets";
    public static final String PROFILEPROPERTY_DOMAINXML_TOKENVALUES = "domain.xml.token-values";

    @Override
    public BitSet getDomainFlags() {
        BitSet bs = new BitSet();
        bs.set(1, false);
        return bs;
    }

    @Override
    public void validateDomain(DomainConfig domainConfig, boolean domainExists) throws DomainException {
        try {
            this.checkRepository(domainConfig, domainExists, domainExists);
        }
        catch (RepositoryException ex) {
            throw new DomainException(ex);
        }
    }

    @Override
    public void validateMasterPassword(DomainConfig domainConfig) throws DomainException {
        try {
            this.validateMasterPassword(domainConfig, PEDomainsManager.getMasterPasswordClear(domainConfig));
        }
        catch (RepositoryException ex) {
            throw new DomainException(ex);
        }
    }

    @Override
    public void createDomain(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        try {
            new RepositoryNameValidator(strMgr.getString("domainsRoot")).checkValidXmlToken(layout.getRepositoryRootDir().getAbsolutePath());
            layout.createRepositoryRoot();
            new PEDomainConfigValidator().validate(domainConfig);
            this.checkRepository(domainConfig, false);
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
        try {
            String masterPassword = PEDomainsManager.getMasterPasswordClear(domainConfig);
            layout.createRepositoryDirectories();
            this.createDomainXml(domainConfig);
            this.createDomainXmlEvents(domainConfig);
            this.createServerPolicyFile(domainConfig);
            this.createAdminKeyFile(domainConfig, PEDomainsManager.getDomainUser(domainConfig), PEDomainsManager.getDomainPasswordClear(domainConfig));
            this.createKeyFile(domainConfig, PEDomainsManager.getDomainUser(domainConfig), PEDomainsManager.getDomainPasswordClear(domainConfig));
            this.createAppClientContainerXml(domainConfig);
            this.createIndexFile(domainConfig);
            this.createDefaultWebXml(domainConfig);
            this.createLoginConf(domainConfig);
            this.createWssServerConfig(domainConfig);
            this.createWssServerConfigOld(domainConfig);
            this.createSSLCertificateDatabase(domainConfig, masterPassword);
            this.changeMasterPasswordInMasterPasswordFile(domainConfig, masterPassword, PEDomainsManager.saveMasterPassword(domainConfig));
            this.createPasswordAliasKeystore(domainConfig, masterPassword);
            this.createLoggingProperties(domainConfig);
            this.setPermissions(domainConfig);
        }
        catch (DomainException de) {
            FileUtils.liquidate((File)this.getDomainDir(domainConfig));
            throw de;
        }
        catch (Exception ex) {
            FileUtils.liquidate((File)this.getDomainDir(domainConfig));
            throw new DomainException(ex);
        }
    }

    protected void createJBIInstance(String instanceName, DomainConfig domainConfig) throws DomainException {
        try {
            this.getFileLayout(domainConfig).createJBIDomainDirectories();
            super.createJBIInstance(instanceName, domainConfig);
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
    }

    protected void setPermissions(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        try {
            this.chmod("-R u+x ", layout.getBinDir());
            this.chmod("-R g-rwx,o-rwx ", layout.getConfigRoot());
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("setPermissionError"), e);
        }
    }

    @Override
    public void deleteDomain(DomainConfig domainConfig) throws DomainException {
        try {
            this.deleteRepository(domainConfig);
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    @Override
    public String[] listDomains(DomainConfig domainConfig) throws DomainException {
        try {
            return this.listRepository(domainConfig);
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    protected void createDomainXmlEvents(DomainConfig domainConfig) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File domainXml = layout.getDomainConfigFile();
            DomainXmlSAXParser parser = new DomainXmlSAXParser();
            try {
                parser.parse(domainXml, layout.getDtdFile());
            }
            catch (Exception e) {
                throw new DomainException(strMgr.getString("domainXmlNotParsed"), e);
            }
            String className = parser.getDomainXmlEventListenerClass();
            if (className != null) {
                DomainXmlEventListener listener = (DomainXmlEventListener)Class.forName(className).newInstance();
                listener.handleCreateEvent(domainConfig);
            }
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("domainXmlEventsNotCreated"), e);
        }
    }

    protected TokenValueSet getDomainXmlTokens(DomainConfig domainConfig) {
        return PEDomainXmlTokens.getTokenValueSet(domainConfig);
    }

    protected void createDomainXml(DomainConfig domainConfig) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File dx = layout.getDomainConfigFile();
            TokenValueSet tokens = this.getDomainXmlTokens(domainConfig);
            String tn = (String)domainConfig.get("template.name");
            if (tn == null || tn.equals("")) {
                File dxt = layout.getDomainXmlTemplate();
                File tr = new File(layout.getTemplatesDir(), "domain.xml");
                this.generateFromTemplate(tokens, tr, dx);
            } else {
                File dxt = layout.getDomainXmlTemplate(tn);
                this.generateFromTemplate(tokens, dxt, dx);
            }
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("domainXmlNotCreated"), e);
        }
    }

    protected void createScripts(DomainConfig domainConfig) throws DomainException {
        TokenValueSet tokens = PEScriptsTokens.getTokenValueSet(domainConfig);
        this.createStartServ(domainConfig, tokens);
        this.createStopServ(domainConfig, tokens);
    }

    void createStartServ(DomainConfig domainConfig, TokenValueSet tokens) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File startServTemplate = layout.getStartServTemplate();
            File startServ = layout.getStartServ();
            this.generateFromTemplate(tokens, startServTemplate, startServ);
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("startServNotCreated"), e);
        }
    }

    void createStopServ(DomainConfig domainConfig, TokenValueSet tokens) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File stopServTemplate = layout.getStopServTemplate();
            File stopServ = layout.getStopServ();
            this.generateFromTemplate(tokens, stopServTemplate, stopServ);
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("stopServNotCreated"), e);
        }
    }

    protected void createAppClientContainerXml(DomainConfig domainConfig) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File accXmlTemplate = layout.getAppClientContainerXmlTemplate();
            File accXml = layout.getAppClientContainerXml();
            TokenValueSet tokens = PEAccXmlTokens.getTokenValueSet(domainConfig);
            this.generateFromTemplate(tokens, accXmlTemplate, accXml);
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("accXmlNotCreated"), e);
        }
    }

    protected void createIndexFile(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        File src = layout.getIndexFileTemplate();
        File dest = layout.getIndexFile();
        try {
            TokenValueSet tokens = IndexHtmlTokens.getTokenValueSet(domainConfig);
            this.generateFromTemplate(tokens, src, dest);
            this.handleLocalizedIndexHtmls(layout, tokens);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("indexFileNotCreated"), ioe);
        }
    }

    protected void createLoggingProperties(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        File src = layout.getLoggingPropertiesTemplate();
        File dest = layout.getLoggingProperties();
        try {
            this.generateFromTemplate(new TokenValueSet(), src, dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("loggingPropertiesNotCreated"), ioe);
        }
    }

    private void handleLocalizedIndexHtmls(PEFileLayout layout, TokenValueSet tokens) {
        Locale locale = Locale.getDefault();
        if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
            return;
        }
        File src = layout.getNonEnglishIndexFileTemplate(locale);
        File dest = layout.getIndexFile();
        if (src.exists()) {
            dest.renameTo(layout.getEnglishIndexFile());
            dest = layout.getIndexFile();
            try {
                this.generateFromTemplate(tokens, src, dest);
            }
            catch (IOException e) {
                String one = strMgr.getString("problemCopyingIndexHtml", (Object)src.getAbsolutePath(), (Object)dest.getAbsolutePath());
                System.out.println(one);
            }
        } else {
            String two = strMgr.getString("localeFileNotFound", (Object)locale, (Object)src.getAbsolutePath());
            System.out.println(two);
        }
    }

    protected void createDefaultWebXml(DomainConfig domainConfig) throws DomainException {
        PEFileLayout layout = this.getFileLayout(domainConfig);
        File src = layout.getDefaultWebXmlTemplate();
        File dest = layout.getDefaultWebXml();
        try {
            FileUtils.copy((File)src, (File)dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("defaultWebXmlNotCreated"), ioe);
        }
    }

    protected void createLoginConf(RepositoryConfig config) throws DomainException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getLoginConfTemplate();
        File dest = layout.getLoginConf();
        try {
            FileUtils.copy((File)src, (File)dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("loginConfNotCreated"), ioe);
        }
    }

    protected void createWssServerConfigOld(RepositoryConfig config) throws DomainException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getWssServerConfigOldTemplate();
        File dest = layout.getWssServerConfigOld();
        try {
            FileUtils.copy((File)src, (File)dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("wssserverconfignotcreated"), ioe);
        }
    }

    protected void createWssServerConfig(RepositoryConfig config) throws DomainException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getWssServerConfigTemplate();
        File dest = layout.getWssServerConfig();
        try {
            FileUtils.copy((File)src, (File)dest);
        }
        catch (IOException ioe) {
            throw new DomainException(strMgr.getString("wssserverconfignotcreated"), ioe);
        }
    }

    protected File getDomainDir(DomainConfig domainConfig) {
        return this.getRepositoryDir(domainConfig);
    }

    protected File getDomainRoot(DomainConfig domainConfig) {
        return this.getRepositoryRootDir(domainConfig);
    }

    String getDefaultInstance() {
        return "server";
    }

    protected static String getDomainUser(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.user");
    }

    protected static String getDomainPasswordClear(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.password");
    }

    protected static String getMasterPasswordClear(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.masterPassword");
    }

    protected static String getNewMasterPasswordClear(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.newMasterPassword");
    }

    protected static boolean saveMasterPassword(DomainConfig domainConfig) {
        Boolean b = (Boolean)domainConfig.get("domain.saveMasterPassword");
        return b;
    }

    @Override
    public String[] getExtraPasswordOptions(DomainConfig config) throws DomainException {
        return null;
    }

    private File invokeGenericXmlTemplateProcessing(File base, DomainConfig dc, String propName, File destDir) throws ProfileTransformationException {
        PEFileLayout layout = this.getFileLayout(dc);
        String profileName = dc.getProfile();
        File profileFolder = layout.getProfileFolder(profileName);
        String msg = strMgr.getString("genericProfileHandlingStarts", (Object)profileFolder.getName());
        System.out.println(msg);
        msg = strMgr.getString("genericXmlProcessing", (Object)base, (Object)profileFolder.getName(), (Object)propName);
        System.out.println(msg);
        File propsFile = layout.getProfilePropertiesFile(profileName);
        List<File> styleSheets = PEDomainsManager.getStyleSheetList(profileFolder, propsFile, propName);
        Properties p = new Properties();
        DefaultHandler er = new DefaultHandler();
        ProfileTransformer px = new ProfileTransformer(base, styleSheets, destDir, er, p);
        File transformed = px.transform();
        return transformed;
    }

    private static List<File> getStyleSheetList(File pf, File propsFile, String p) throws RuntimeException {
        if (!propsFile.exists() || !propsFile.canRead()) {
            String msg = strMgr.getString("profilePropertiesMissing", (Object)propsFile.getAbsolutePath());
            throw new IllegalArgumentException(msg);
        }
        try {
            String ssNames = PEDomainsManager.readProfilePropertyValue(propsFile, p);
            StringTokenizer tk = new StringTokenizer(ssNames, NAME_DELIMITER);
            ArrayList<File> list = new ArrayList<File>(tk.countTokens());
            while (tk.hasMoreTokens()) {
                File ss = new File(pf, tk.nextToken().trim());
                if (!ss.exists()) {
                    String msg = strMgr.getString("styleSheetNotFound", (Object)ss.getAbsolutePath());
                    throw new RuntimeException(msg);
                }
                list.add(ss);
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readProfilePropertyValue(File propsFile, String propName) throws IOException {
        Properties ps = new Properties();
        String propValue = null;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(propsFile));
        try {
            ps.load(bis);
            propValue = ps.getProperty(propName);
            if (propValue == null) {
                propValue = "";
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ee) {}
            }
        }
        return propValue;
    }

    private static void addTokenValuesIfAny(TokenValueSet tokens, PEFileLayout layout, String profileName, String propName) throws IOException {
        File propsFile = layout.getProfilePropertiesFile(profileName);
        String tvsAsString = PEDomainsManager.readProfilePropertyValue(propsFile, propName);
        Set<TokenValue> tvs = PEDomainsManager.s2TV(tvsAsString);
        tokens.addAll(tvs);
    }

    private static Set<TokenValue> s2TV(String nvpairs) {
        HashSet<TokenValue> set = new HashSet<TokenValue>();
        StringTokenizer st = new StringTokenizer(nvpairs, NAME_DELIMITER);
        while (st.hasMoreTokens()) {
            String tvs = st.nextToken();
            if (tvs == null || tvs.indexOf("=") == -1 || tvs.length() < 3) {
                String string = strMgr.getString("invalidToken", (Object)tvs);
            }
            tvs = tvs.trim();
            int e2 = tvs.indexOf("=");
            String t = tvs.substring(0, e2);
            String v = tvs.substring(e2 + 1);
            String msg = strMgr.getString("processingToken", (Object[])new String[]{t, v});
            System.out.println(msg);
            TokenValue tv = new TokenValue(t, v);
            set.add(tv);
        }
        return set;
    }
}

