/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.security.web.integration.WebPermissionUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstraintValue {
    static String[] connectKeys = new String[]{"NONE", "INTEGRAL", "CONFIDENTIAL"};
    static int ConnectTypeNone = 1;
    static HashMap connectHash = new HashMap();
    boolean excluded = false;
    boolean ignoreRoleList = false;
    List<String> roleList = new ArrayList<String>();
    int connectSet = 0;

    ConstraintValue() {
    }

    static boolean bitIsSet(int map, int bit) {
        return (map & bit) == bit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRole(String role) {
        List<String> list = this.roleList;
        synchronized (list) {
            if (!this.roleList.contains(role)) {
                this.roleList.add(role);
            }
        }
    }

    void setPredefinedOutcome(boolean outcome) {
        if (!outcome) {
            this.excluded = true;
        } else {
            this.ignoreRoleList = true;
        }
    }

    void addConnectType(String guarantee) {
        int b = ConnectTypeNone;
        if (guarantee != null) {
            Integer bit = (Integer)connectHash.get(guarantee);
            if (bit == null) {
                throw new IllegalArgumentException("constraint translation error-illegal trx guarantee");
            }
            b = bit;
        }
        this.connectSet |= b;
    }

    boolean isExcluded() {
        return this.excluded;
    }

    boolean isAuthConstrained() {
        if (this.excluded) {
            return true;
        }
        return !this.ignoreRoleList && !this.roleList.isEmpty();
    }

    boolean isTransportConstrained() {
        return this.excluded || this.connectSet != 0 && !ConstraintValue.bitIsSet(this.connectSet, ConnectTypeNone);
    }

    boolean isConnectAllowed(int cType) {
        return !this.excluded && (this.connectSet == 0 || ConstraintValue.bitIsSet(this.connectSet, ConnectTypeNone) || ConstraintValue.bitIsSet(this.connectSet, cType));
    }

    void setOutcome(Set<Role> roleSet, AuthorizationConstraint ac, UserDataConstraint udc) {
        if (ac == null) {
            this.setPredefinedOutcome(true);
        } else {
            Enumeration eroles = ac.getSecurityRoles();
            if (!eroles.hasMoreElements()) {
                this.setPredefinedOutcome(false);
            } else {
                while (eroles.hasMoreElements()) {
                    SecurityRoleDescriptor srd = (SecurityRoleDescriptor)eroles.nextElement();
                    String roleName = srd.getName();
                    if ("*".equals(roleName)) {
                        Iterator<Role> it = roleSet.iterator();
                        while (it.hasNext()) {
                            this.setRole(it.next().getName());
                        }
                        continue;
                    }
                    this.setRole(roleName);
                }
            }
        }
        this.addConnectType(udc == null ? null : udc.getTransportGuarantee());
        if (WebPermissionUtil.logger.isLoggable(Level.FINE)) {
            WebPermissionUtil.logger.log(Level.FINE, "JACC: setOutcome yields: " + this.toString());
        }
    }

    void setValue(ConstraintValue constraint) {
        this.excluded = constraint.excluded;
        this.ignoreRoleList = constraint.ignoreRoleList;
        this.roleList = new ArrayList<String>();
        for (String role : constraint.roleList) {
            this.roleList.add(role);
        }
        this.connectSet = constraint.connectSet;
    }

    public String toString() {
        String roles = " roles: ";
        Iterator<String> rit = this.roleList.iterator();
        while (rit.hasNext()) {
            roles = roles + " " + rit.next();
        }
        String transports = "transports: ";
        for (int i = 0; i < connectKeys.length; ++i) {
            if (!this.isConnectAllowed(1 << i)) continue;
            transports = transports + " " + connectKeys[i];
        }
        return " ConstraintValue (  excluded: " + this.excluded + " ignoreRoleList: " + this.ignoreRoleList + roles + transports + " ) ";
    }

    static {
        for (int i = 0; i < connectKeys.length; ++i) {
            connectHash.put(connectKeys[i], new Integer(1 << i));
        }
    }
}

