/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional.commands;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.Console;
import java.util.Collections;
import java.util.HashSet;

public class LoginCommand
extends CLICommand {
    private String adminUser = null;
    private String adminPassword = null;
    private static final LocalStringsImpl strings = new LocalStringsImpl(LoginCommand.class);

    public LoginCommand(String name, ProgramOptions programOpts, Environment env) throws CommandException, CommandValidationException {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException, CommandValidationException {
        this.processProgramOptions();
        HashSet opts = new HashSet();
        LoginCommand.addOption(opts, (String)"help", (char)'?', (String)"BOOLEAN", (boolean)false, (String)"false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 0;
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        this.programOpts.setInteractive(true);
        this.adminUser = this.getAdminUser();
        if (this.adminUser == null || this.adminUser.length() == 0) {
            this.adminUser = "anonymous";
            this.adminPassword = "";
        } else {
            this.adminPassword = this.adminUser.equals("anonymous") && (this.adminPassword == null || this.adminPassword.length() == 0) ? "" : this.getAdminPassword();
        }
        this.programOpts.setUser(this.adminUser);
        this.programOpts.setPassword(this.adminPassword);
        this.programOpts.setInteractive(false);
        if (!DASUtils.pingDASWithAuth((ProgramOptions)this.programOpts, (Environment)this.env)) {
            throw new CommandException(strings.get("InvalidCredentials", new Object[]{this.adminUser}));
        }
        this.saveLogin(this.programOpts.getHost(), this.programOpts.getPort(), this.adminUser, this.adminPassword);
        return 0;
    }

    private String getAdminUser() {
        Console cons = System.console();
        String user = null;
        if (cons != null) {
            cons.printf("%s ", strings.get("AdminUserPrompt", new Object[]{this.programOpts.getUser()}));
            String val = cons.readLine();
            if (val != null && val.length() > 0) {
                user = val;
            }
        }
        return user;
    }

    private String getAdminPassword() {
        String prompt = strings.get("AdminPasswordPrompt");
        return this.readPassword(prompt);
    }

    private void saveLogin(String host, int port, String user, String passwd) {
        block4: {
            LoginInfo login = null;
            try {
                LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
                if (host == null || host.equals("")) {
                    host = "localhost";
                }
                if (store.exists((login = new LoginInfo(host, port, user, passwd)).getHost(), login.getPort())) {
                    logger.printMessage(strings.get("OverwriteLoginMsgCreateDomain", new Object[]{login.getHost(), login.getPort()}));
                }
                store.store(login, true);
                logger.printMessage(strings.get("LoginInfoStored", new Object[]{user, login.getHost(), port, store.getName()}));
            }
            catch (Exception e) {
                logger.printWarning(strings.get("LoginInfoNotStored", new Object[]{login.getHost(), port}));
                if (!logger.isDebug()) break block4;
                logger.printExceptionStackTrace((Throwable)e);
            }
        }
    }
}

