/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional.commands;

import com.sun.enterprise.admin.cli.CLIProcessExecutor;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.optional.commands.DatabaseCommand;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.OS;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;

public final class StartDatabaseCommand
extends DatabaseCommand {
    private static final String DB_HOME = "dbhome";
    private static final String DATABASE_DIR_NAME = "databases";
    private String dbHome;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartDatabaseCommand.class);

    public StartDatabaseCommand(String name, ProgramOptions programOpts, Environment env) {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet opts = new LinkedHashSet();
        StartDatabaseCommand.addOption(opts, (String)"dbhost", (char)'\u0000', (String)"STRING", (boolean)false, (String)"0.0.0.0");
        StartDatabaseCommand.addOption(opts, (String)"dbport", (char)'\u0000', (String)"STRING", (boolean)false, (String)"1527");
        StartDatabaseCommand.addOption(opts, (String)DB_HOME, (char)'\u0000', (String)"STRING", (boolean)false, null);
        StartDatabaseCommand.addOption(opts, (String)"terse", (char)'\u0000', (String)"BOOLEAN", (boolean)false, (String)"false");
        StartDatabaseCommand.addOption(opts, (String)"echo", (char)'\u0000', (String)"BOOLEAN", (boolean)false, (String)"false");
        StartDatabaseCommand.addOption(opts, (String)"help", (char)'?', (String)"BOOLEAN", (boolean)false, (String)"false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 0;
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        if (this.options.containsKey("echo")) {
            this.programOpts.setEcho(this.getBooleanOption("echo"));
        }
        if (this.options.containsKey("terse")) {
            this.programOpts.setTerse(this.getBooleanOption("terse"));
        }
    }

    public String[] startDatabaseCmd() throws Exception {
        if (OS.isDarwin()) {
            return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "start", this.dbHost, this.dbPort, "true", this.dbHome};
        }
        return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "start", this.dbHost, this.dbPort, "true", this.dbHome};
    }

    public String[] sysinfoCmd() throws Exception {
        if (OS.isDarwin()) {
            return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "sysinfo", this.dbHost, this.dbPort, "false"};
        }
        return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "sysinfo", this.dbHost, this.dbPort, "false"};
    }

    private String getDatabaseHomeDir() {
        if (this.getOption(DB_HOME) != null) {
            return this.getOption(DB_HOME);
        }
        String currentDir = System.getProperty("user.dir");
        if (new File(currentDir, "derby.log").exists()) {
            return currentDir;
        }
        File installPath = GFLauncherUtils.getInstallDir();
        if (installPath != null) {
            File dbDir = new File(installPath, DATABASE_DIR_NAME);
            dbDir.mkdir();
            try {
                return dbDir.getCanonicalPath();
            }
            catch (IOException ioe) {
                return dbDir.getAbsolutePath();
            }
        }
        return null;
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        CLIProcessExecutor cpe = new CLIProcessExecutor();
        String dbLog = "";
        try {
            this.prepareProcessExecutor();
            this.dbHome = this.getDatabaseHomeDir();
            if (this.dbHome != null) {
                dbLog = this.dbHome + File.separator + "derby.log";
            }
            logger.printDebugMessage("Ping Database");
            cpe.execute("pingDatabaseCmd", this.pingDatabaseCmd(true), true);
            if (cpe.exitValue() > 0) {
                logger.printDebugMessage("Start Database");
                cpe.execute("startDatabaseCmd", this.startDatabaseCmd(), false);
                if (cpe.exitValue() != 0) {
                    throw new CommandException(strings.get("UnableToStartDatabase", new Object[]{dbLog}));
                }
            } else {
                if (cpe.exitValue() < 0) {
                    throw new CommandException(strings.get("CommandUnSuccessful", new Object[]{this.name}));
                }
                logger.printMessage(strings.get("StartDatabaseStatus", new Object[]{this.dbHost, this.dbPort}));
            }
        }
        catch (IllegalThreadStateException ite) {
            if (!this.programOpts.isTerse() && !this.getBooleanOption("terse")) {
                try {
                    logger.printDetailMessage(strings.get("database.info.msg", new Object[]{this.dbHost, this.dbPort}));
                    CLIProcessExecutor cpePing = new CLIProcessExecutor();
                    cpePing.execute("pingDatabaseCmd", this.pingDatabaseCmd(true), true);
                    for (int counter = 0; cpePing.exitValue() != 0 && counter < 5; ++counter) {
                        cpePing.execute("pingDatabaseCmd", this.pingDatabaseCmd(true), true);
                        Thread.sleep(500L);
                    }
                    logger.printDebugMessage("Database SysInfo");
                    CLIProcessExecutor cpeSysInfo = new CLIProcessExecutor();
                    cpeSysInfo.execute("sysinfoCmd", this.sysinfoCmd(), true);
                    if (cpeSysInfo.exitValue() != 0) {
                        logger.printMessage(strings.get("CouldNotGetSysInfo"));
                    }
                }
                catch (Exception e) {
                    throw new CommandException(strings.get("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
                }
            }
            logger.printMessage(strings.get("DatabaseStartMsg"));
            if (new File(dbLog).canWrite()) {
                logger.printMessage(strings.get("LogRedirectedTo", new Object[]{dbLog}));
            }
        }
        catch (Exception e) {
            throw new CommandException(strings.get("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
        }
        return 0;
    }
}

