/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.auth.realm.ldap.LDAPRealm;
import com.sun.enterprise.util.i18n.StringManager;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Property;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="setup-ldap-for-admin")
public class LDAPAdminAccessConfigurator
implements AdminCommand {
    @Param(name="basedn", shortName="b", optional=false)
    public volatile String basedn;
    @Param(name="new admin realm name", optional=true, primary=true)
    public volatile String name = "ldap-admin-realm";
    @Param(name="url", shortName="u", optional=true)
    public volatile String url = "ldap://localhost:389";
    @Param(name="ping", shortName="p", optional=true, defaultValue="false")
    public volatile Boolean ping = Boolean.FALSE;
    @Inject
    Configs allConfigs;
    private static final String ADMIN_SERVER = "server";
    private static final StringManager lsm = StringManager.getManager(LDAPAdminAccessConfigurator.class);
    private static final String DIR_P = "directory";
    private static final String BASEDN_P = "base-dn";
    private static final String JAAS_P = "jaas-context";
    private static final String JAAS_V = "ldapRealm";

    public void execute(AdminCommandContext context) {
        ActionReport rep = context.getActionReport();
        StringBuilder sb = new StringBuilder();
        if (this.url != null && !this.url.startsWith("ldap://") && !this.url.startsWith("ldaps://")) {
            this.url = this.url + "ldap://" + this.url;
        }
        this.pingLDAP(sb);
        try {
            this.configure(sb);
            rep.setMessage(sb.toString());
            rep.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tf) {
            rep.setMessage(tf.getMessage());
            rep.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        catch (PropertyVetoException e) {
            rep.setMessage(e.getMessage());
            rep.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void configure(StringBuilder sb) throws TransactionFailure, PropertyVetoException {
        Server s = ConfigBeansUtilities.getServerNamed((String)ADMIN_SERVER);
        String ac = s.getConfigRef();
        Config asc = null;
        for (Config cfg : this.allConfigs.getConfig()) {
            if (!cfg.getName().equals(ac)) continue;
            asc = cfg;
            break;
        }
        if (this.realmExists(asc)) {
            sb.append(lsm.getString("realm.exists", (Object)this.name));
            return;
        }
        this.createIt(asc.getSecurityService(), sb);
        List cs = asc.getAdminService().getJmxConnector();
        JmxConnector sys = null;
        for (JmxConnector c : cs) {
            if (!"system".equals(c.getName())) continue;
            sys = c;
            break;
        }
        if (sys != null) {
            this.configureJmxConnector(sys);
        }
        this.configureAdminRealmProperty(asc.getAdminService());
    }

    private void configureAdminRealmProperty(AdminService as) throws PropertyVetoException, TransactionFailure {
        SingleConfigCode<AdminService> scc = new SingleConfigCode<AdminService>(){

            public Object run(AdminService as) {
                return true;
            }
        };
    }

    private void createIt(SecurityService ss, final StringBuilder sb) throws TransactionFailure {
        SingleConfigCode<SecurityService> scc = new SingleConfigCode<SecurityService>(){

            public Object run(SecurityService ss) throws PropertyVetoException, TransactionFailure {
                AuthRealm ldapr = LDAPAdminAccessConfigurator.this.createLDAPRealm(ss);
                ss.getAuthRealm().add(ldapr);
                LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.realm.setup", (Object)LDAPAdminAccessConfigurator.this.name));
                return true;
            }
        };
        ConfigSupport.apply((SingleConfigCode)scc, (ConfigBeanProxy)ss);
    }

    private void configureJmxConnector(JmxConnector jc) throws PropertyVetoException, TransactionFailure {
        SingleConfigCode<JmxConnector> scc = new SingleConfigCode<JmxConnector>(){

            public Object run(JmxConnector jc) throws PropertyVetoException, TransactionFailure {
                jc.setAuthRealmName(LDAPAdminAccessConfigurator.this.name);
                return true;
            }
        };
        ConfigSupport.apply((SingleConfigCode)scc, (ConfigBeanProxy)jc);
    }

    private AuthRealm createLDAPRealm(SecurityService ss) throws TransactionFailure, PropertyVetoException {
        AuthRealm ar = (AuthRealm)ss.createChild(AuthRealm.class);
        ar.setClassname(LDAPRealm.class.getName());
        ar.setName(this.name);
        List props = ar.getProperty();
        Property p = (Property)ar.createChild(Property.class);
        p.setName(DIR_P);
        p.setValue(this.url);
        props.add(p);
        p = (Property)ar.createChild(Property.class);
        p.setName(BASEDN_P);
        p.setValue(this.basedn);
        props.add(p);
        p = (Property)ar.createChild(Property.class);
        p.setName(JAAS_P);
        p.setValue(JAAS_V);
        props.add(p);
        return ar;
    }

    private void pingLDAP(StringBuilder sb) {
        if (!this.ping.booleanValue()) {
            LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.noping", (Object)this.url));
            return;
        }
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url);
        try {
            new InitialContext(env);
            LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.ok", (Object)this.url));
        }
        catch (Exception e) {
            LDAPAdminAccessConfigurator.appendNL(sb, lsm.getString("ldap.na", (Object)this.url, (Object)e.getClass().getName(), (Object)e.getMessage()));
        }
    }

    private boolean realmExists(Config cfg) {
        List realms = cfg.getSecurityService().getAuthRealm();
        for (AuthRealm ar : realms) {
            if (!ar.getName().equals(this.name)) continue;
            return true;
        }
        return false;
    }

    private static void appendNL(StringBuilder sb, String s) {
        sb.append(s).append("%%%EOL%%%");
    }
}

