/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.security.web.integration.ConstraintValue;
import com.sun.enterprise.security.web.integration.MethodValue;
import com.sun.enterprise.security.web.integration.WebPermissionUtil;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapValue {
    int patternType;
    int patternLength;
    boolean irrelevantByQualifier;
    StringBuffer urlPatternSpec;
    HashMap<String, MethodValue> methodValues = new HashMap();
    ConstraintValue otherConstraint;

    MapValue(String urlPattern) {
        this.patternType = WebPermissionUtil.patternType(urlPattern);
        this.patternLength = urlPattern.length();
        this.irrelevantByQualifier = false;
        this.urlPatternSpec = new StringBuffer(urlPattern);
        this.methodValues = new HashMap();
        this.otherConstraint = new ConstraintValue();
    }

    void addQualifier(String urlPattern) {
        if (WebPermissionUtil.implies(urlPattern, this.urlPatternSpec.substring(0, this.patternLength))) {
            this.irrelevantByQualifier = true;
        }
        this.urlPatternSpec.append(":" + urlPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodValue getMethodValue(int methodIndex) {
        String methodName = MethodValue.getMethodName(methodIndex);
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            MethodValue methodValue = this.methodValues.get(methodName);
            if (methodValue == null) {
                methodValue = new MethodValue(methodName, this.otherConstraint);
                this.methodValues.put(methodName, methodValue);
                if (WebPermissionUtil.logger.isLoggable(Level.FINE)) {
                    WebPermissionUtil.logger.log(Level.FINE, "JACC: created MethodValue: " + methodValue);
                }
            }
            return methodValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getExcludedMethods() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (!v.isExcluded()) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getNoAuthMethods() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (v.isAuthConstrained()) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getAuthConstrainedMethods() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (!v.isAuthConstrained()) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getTransportConstrainedMethods() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (!v.isTransportConstrained()) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap getRoleMap() {
        HashMap<String, BitSet> roleMap = new HashMap<String, BitSet>();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (v.isExcluded() || !v.isAuthConstrained()) continue;
                for (String role : v.roleList) {
                    BitSet methodSet = (BitSet)roleMap.get(role);
                    if (methodSet == null) {
                        methodSet = new BitSet();
                        roleMap.put(role, methodSet);
                    }
                    methodSet.set(v.index);
                }
            }
        }
        return roleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getConnectMap(int cType) {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (!v.isConnectAllowed(cType)) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getMethodSet() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    void setMethodOutcomes(Set<Role> roleSet, AuthorizationConstraint ac, UserDataConstraint udc, BitSet methods, BitSet omittedMethods) {
        if (omittedMethods != null) {
            BitSet methodsInMap = this.getMethodSet();
            BitSet saved = (BitSet)omittedMethods.clone();
            omittedMethods.andNot(methodsInMap);
            int i = omittedMethods.nextSetBit(0);
            while (i >= 0) {
                this.getMethodValue(i);
                i = omittedMethods.nextSetBit(i + 1);
            }
            this.otherConstraint.setOutcome(roleSet, ac, udc);
            methodsInMap.andNot(saved);
            this.setMethodOutcomes(roleSet, ac, udc, methodsInMap, null);
        } else {
            int i = methods.nextSetBit(0);
            while (i >= 0) {
                this.getMethodValue(i).setOutcome(roleSet, ac, udc);
                i = methods.nextSetBit(i + 1);
            }
        }
    }
}

