/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.GlassfishNamingManagerImpl;
import com.sun.enterprise.naming.impl.NamedNamingObjectManager;
import com.sun.enterprise.naming.impl.SerialContext;
import com.sun.enterprise.naming.util.LogFacade;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.naming.ComponentNamingUtil;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.component.Habitat;

public final class JavaURLContext
implements Context,
Cloneable {
    static Logger _logger = LogFacade.getLogger();
    private static final boolean debug = false;
    private static GlassfishNamingManagerImpl namingManager;
    private Hashtable myEnv;
    private String myName = "";
    private SerialContext serialContext = null;

    public JavaURLContext(Hashtable environment) throws NamingException {
        this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
    }

    public JavaURLContext(String name, Hashtable env) throws NamingException {
        this(env);
        this.myName = name;
    }

    public JavaURLContext(Hashtable env, SerialContext serialContext) throws NamingException {
        this(env);
        this.serialContext = serialContext;
    }

    static void setNamingManager(GlassfishNamingManagerImpl mgr) {
        namingManager = mgr;
    }

    public Object lookup(String name) throws NamingException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "In javaURLContext.lookup, name = " + name + " serialcontext..." + this.serialContext);
        }
        if (name.equals("")) {
            return new JavaURLContext(this.myName, this.myEnv);
        }
        String fullName = name;
        if (!this.myName.equals("")) {
            fullName = this.myName.equals("java:") ? this.myName + name : this.myName + "/" + name;
        }
        try {
            Object obj = null;
            if (fullName.startsWith("java:comp/env/") || fullName.startsWith("java:module/env/") || fullName.startsWith("java:app/env/")) {
                obj = namingManager.lookup(fullName, this.serialContext);
            } else {
                obj = NamedNamingObjectManager.tryNamedProxies(name);
                if (obj == null) {
                    obj = namingManager.lookup(fullName, this.serialContext);
                }
            }
            if (obj == null) {
                throw new NamingException("No object found for " + name);
            }
            return obj;
        }
        catch (NamingException ex) {
            Habitat habitat = Globals.getDefaultHabitat();
            ProcessEnvironment processEnv = (ProcessEnvironment)habitat.getComponent(ProcessEnvironment.class);
            if (fullName.startsWith("java:app/") && processEnv.getProcessType() == ProcessEnvironment.ProcessType.ACC) {
                Context ic = namingManager.getInitialContext();
                String appName = (String)namingManager.getInitialContext().lookup("java:comp/AppName");
                Object obj = null;
                if (!fullName.startsWith("java:app/env/")) {
                    try {
                        String newPrefix = "java:global/" + appName + "/";
                        int javaAppLength = "java:app/".length();
                        String globalLookup = newPrefix + fullName.substring(javaAppLength);
                        obj = ic.lookup(globalLookup);
                    }
                    catch (NamingException javaappenvne) {
                        _logger.log(Level.FINE, "Trying global version of java:app ejb lookup", javaappenvne);
                    }
                }
                if (obj == null) {
                    ComponentNamingUtil compNamingUtil = (ComponentNamingUtil)habitat.getByContract(ComponentNamingUtil.class);
                    String internalGlobalJavaAppName = compNamingUtil.composeInternalGlobalJavaAppName(appName, fullName);
                    obj = ic.lookup(internalGlobalJavaAppName);
                }
                if (obj == null) {
                    throw new NamingException("No object found for " + name);
                }
                return obj;
            }
            throw ex;
        }
        catch (Exception ex) {
            throw (NamingException)new NameNotFoundException("No object bound for " + fullName).initCause(ex);
        }
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void unbind(String name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void unbind(Name name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void rename(String oldname, String newname) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new NamingException("java:comp namespace cannot be modified");
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            if (namingManager == null) {
                throw new NamingException();
            }
            return namingManager.list(this.myName);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            if (namingManager == null) {
                throw new NamingException();
            }
            return namingManager.listBindings(this.myName);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (namingManager == null) {
            throw new NamingException();
        }
        return namingManager.getNameParser();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String getNameInNamespace() throws NamingException {
        return this.myName;
    }
}

