/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.ClassPathBuilder;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.OS;
import java.io.File;
import java.io.FileFilter;

public abstract class DatabaseCommand
extends CLICommand {
    protected static final String DB_HOST = "dbhost";
    protected static final String DB_HOST_DEFAULT = "0.0.0.0";
    protected static final String DB_PORT = "dbport";
    protected static final String DB_PORT_DEFAULT = "1527";
    private static final String[] MODULES_IN_CLASSPATH = new String[]{"glassfish", "admin-cli", "cli-framework", "common-util"};
    protected String dbHost;
    protected String dbPort;
    protected File dbLocation;
    protected File sJavaHome;
    protected File sInstallRoot;
    protected File installModules;
    protected final ClassPathBuilder sClasspath = new ClassPathBuilder();
    protected final ClassPathBuilder sDatabaseClasspath = new ClassPathBuilder();
    private static final LocalStringsImpl strings = new LocalStringsImpl(DatabaseCommand.class);

    public DatabaseCommand(String name, ProgramOptions programOpts, Environment env) {
        super(name, programOpts, env);
    }

    protected void prepareProcessExecutor() throws Exception {
        this.sInstallRoot = new File(this.getSystemProperty("com.sun.aas.installRoot"));
        this.dbHost = this.getOption(DB_HOST);
        if (this.dbHost == null) {
            this.dbHost = DB_HOST_DEFAULT;
        }
        this.dbPort = this.getOption(DB_PORT);
        if (this.dbPort == null) {
            this.dbPort = DB_PORT_DEFAULT;
        } else {
            this.checkIfPortIsValid(this.dbPort);
        }
        this.sJavaHome = new File(this.getSystemProperty("com.sun.aas.javaRoot"));
        this.installModules = new File(this.sInstallRoot, "modules");
        this.dbLocation = new File(this.getSystemProperty("com.sun.aas.derbyRoot"));
        this.checkIfDbInstalled(this.dbLocation);
        this.sClasspath.addAll(this.installModules, new FileFilter(){

            public boolean accept(File f) {
                String n = f.getName();
                for (String prefix : MODULES_IN_CLASSPATH) {
                    if (!n.startsWith(prefix) || !n.endsWith(".jar")) continue;
                    return true;
                }
                return false;
            }
        });
        this.sDatabaseClasspath.add(this.dbLocation, new String[]{"lib", "derby.jar"}).add(this.dbLocation, new String[]{"lib", "derbytools.jar"}).add(this.dbLocation, new String[]{"lib", "derbynet.jar"}).add(this.dbLocation, new String[]{"lib", "derbyclient.jar"});
    }

    private void checkIfPortIsValid(String port) throws CommandValidationException {
        try {
            Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new CommandValidationException(strings.get("InvalidPortNumber", new Object[]{port}));
        }
    }

    private void checkIfDbInstalled(File dblocation) throws CommandException {
        if (!dblocation.exists()) {
            logger.printMessage(strings.get("DatabaseNotInstalled", new Object[]{dblocation}));
            throw new CommandException("dblocation not found: " + dblocation);
        }
        File derbyJar = new File(new File(this.dbLocation, "lib"), "derbyclient.jar");
        if (!derbyJar.exists()) {
            logger.printMessage(strings.get("DatabaseNotInstalled", new Object[]{dblocation}));
            throw new CommandException("derbyclient.jar not found in " + dblocation);
        }
    }

    protected String[] pingDatabaseCmd(boolean bRedirect) throws Exception {
        if (OS.isDarwin()) {
            return new String[]{this.getJavaExe().toString(), "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "ping", this.dbHost, this.dbPort, Boolean.valueOf(bRedirect).toString()};
        }
        return new String[]{this.getJavaExe().toString(), "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.admin.cli.optional.DerbyControl", "ping", this.dbHost, this.dbPort, Boolean.valueOf(bRedirect).toString()};
    }

    protected final File getJavaExe() {
        return new File(new File(this.sJavaHome, "bin"), "java");
    }
}

