/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.cli;

import com.sun.enterprise.admin.monitor.jndi.JndiNameLookupHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="list-jndi-entries")
@Scoped(value=PerLookup.class)
@I18n(value="list.jndi.entries")
public class ListJndiEntries
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListJndiEntries.class);
    @Param(name="context", optional=true)
    String contextName;
    @Param(primary=true, defaultValue="server")
    String target;

    public void execute(AdminCommandContext context) {
        List<String> names;
        ActionReport report = context.getActionReport();
        try {
            names = this.getNames(this.contextName);
        }
        catch (NamingException e) {
            report.setMessage(localStrings.getLocalString("list.jndi.entries.namingexception", "Naming Exception caught.") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        try {
            if (names.isEmpty()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(localStrings.getLocalString("list.jndi.entries.empty", "Nothing to list."));
            } else {
                for (String jndiName : names) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(jndiName);
                }
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.jndi.entries.fail", "Unable to list jndi entries.") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private List<String> getNames(String context) throws NamingException {
        JndiNameLookupHelper helper = new JndiNameLookupHelper();
        ArrayList<String> names = helper.getJndiEntriesByContextPath(context);
        return names;
    }
}

