/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.Pathnames;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.PathnameParser;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.AMXProxyHandler;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.stringifier.SmartStringifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathnamesImpl
extends AMXImplBase {
    private static final int MAX_CACHE_SIZE = 1024;
    private final ConcurrentMap<String, ObjectName> mPathnameCache = new ConcurrentHashMap<String, ObjectName>();

    public PathnamesImpl(ObjectName parentObjectName) {
        super(parentObjectName, Pathnames.class);
    }

    public ObjectName resolvePath(String path) {
        ObjectName result = (ObjectName)this.mPathnameCache.get(path);
        if (result != null) {
            return result;
        }
        if (path.equals("/")) {
            return this.getDomainRoot();
        }
        PathnameParser parser = new PathnameParser(path);
        String parentPath = parser.parentPath();
        String props = Util.makeProp((String)"pp", (String)parentPath);
        ObjectName pattern = JMXUtil.newObjectNamePattern((String)this.getObjectName().getDomain(), (String)props);
        Set<ObjectName> s = this.getMBeanServer().queryNames(pattern, null);
        ObjectName objectName = null;
        String type = parser.type();
        String name = parser.name();
        for (ObjectName child : s) {
            if (!type.equals(Util.getTypeProp((ObjectName)child))) continue;
            String nameProp = Util.getNameProp((ObjectName)child);
            if (nameProp == null) {
                if (name != null) continue;
                objectName = child;
                break;
            }
            if (name != null && name.equals(nameProp)) {
                objectName = child;
                break;
            }
            MBeanInfo mbeanInfo = this.getProxyFactory().getMBeanInfo(child);
            boolean singleton = AMXProxyHandler.singleton((MBeanInfo)mbeanInfo);
            if (!singleton || name != null) continue;
            objectName = child;
            break;
        }
        if (this.mPathnameCache.keySet().size() > 1024) {
            this.mPathnameCache.clear();
        }
        if (objectName != null) {
            this.mPathnameCache.put(path, objectName);
        }
        return objectName;
    }

    private AMXProxy resolveToProxy(String path) {
        ObjectName objectName = this.resolvePath(path);
        if (objectName == null) {
            return null;
        }
        return this.getProxyFactory().getProxy(objectName, AMXProxy.class);
    }

    public ObjectName[] resolvePaths(String[] paths) {
        ObjectName[] objectNames = new ObjectName[paths.length];
        int i = 0;
        for (String path : paths) {
            try {
                objectNames[i] = this.resolvePath(path);
            }
            catch (Exception e) {
                objectNames[i] = null;
            }
            ++i;
        }
        return objectNames;
    }

    public ObjectName[] ancestors(String path) {
        ObjectName objectName = this.resolvePath(path);
        if (objectName == null) {
            return null;
        }
        return this.ancestors(objectName);
    }

    public ObjectName[] ancestors(ObjectName mbean) {
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
        MBeanServer server = this.getMBeanServer();
        ObjectName cur = mbean;
        while (cur != null) {
            objectNames.add(cur);
            cur = (ObjectName)JMXUtil.getAttribute((MBeanServerConnection)server, (ObjectName)cur, (String)"Parent");
        }
        List reversed = ListUtil.reverse(objectNames);
        ObjectName[] ancestors = new ObjectName[reversed.size()];
        reversed.toArray(ancestors);
        return ancestors;
    }

    private List<AMXProxy> listChildren(AMXProxy top, List<AMXProxy> list, boolean recursive) {
        Set children = top.childrenSet();
        if (children == null) {
            return null;
        }
        for (AMXProxy child : children) {
            list.add(child);
            if (!recursive) continue;
            this.listChildren(child, list, true);
        }
        return list;
    }

    private List<AMXProxy> listChildren(String path, boolean recursive) {
        AMXProxy topProxy = this.resolveToProxy(path);
        if (topProxy == null) {
            return null;
        }
        return this.listChildren(topProxy, new ArrayList<AMXProxy>(), recursive);
    }

    public String[] getAllPathnames() {
        String[] allButRoot = this.listPaths("/", true);
        String[] all = new String[allButRoot.length + 1];
        all[0] = "/";
        System.arraycopy(allButRoot, 0, all, 1, allButRoot.length);
        return all;
    }

    public ObjectName[] listObjectNames(String path, boolean recursive) {
        List<AMXProxy> list = this.listChildren(path, recursive);
        List objectNames = Util.toObjectNameList(list);
        return (ObjectName[])CollectionUtil.toArray((Collection)objectNames, ObjectName.class);
    }

    public String[] listPaths(String path, boolean recursive) {
        List<AMXProxy> list = this.listChildren(path, recursive);
        ArrayList<String> paths = new ArrayList<String>();
        for (AMXProxy amx : list) {
            paths.add(amx.path());
        }
        return (String[])CollectionUtil.toArray(paths, String.class);
    }

    public String dump(String path) {
        ObjectName top = this.resolvePath(path);
        if (top == null) {
            return null;
        }
        AMXProxy topProxy = this.getProxyFactory().getProxy(top, AMXProxy.class);
        ArrayList<AMXProxy> list = new ArrayList<AMXProxy>();
        list.add(topProxy);
        this.listChildren(topProxy, list, true);
        String NL = "\n";
        StringBuffer buf = new StringBuffer();
        for (AMXProxy amx : list) {
            String p = amx.path();
            buf.append(p);
            buf.append("\n");
            Map attributesMap = amx.attributesMap();
            for (String name : attributesMap.keySet()) {
                buf.append("\t");
                buf.append(name);
                buf.append(" = ");
                buf.append("" + SmartStringifier.toString(attributesMap.get(name)));
                buf.append("\n");
            }
            buf.append("\n");
        }
        return buf.toString();
    }
}

